/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ProgressMonitorDialog
extends IconAndMessageDialog
implements IRunnableContext {
    private static String DEFAULT_TASKNAME = JFaceResources.getString("ProgressMonitorDialog.message");
    private static int LABEL_DLUS = 21;
    private static int BAR_DLUS = 9;
    protected ProgressIndicator progressIndicator;
    protected Label taskLabel;
    protected Label subTaskLabel;
    protected Button cancel;
    protected boolean operationCancelableState = false;
    protected boolean enableCancelButton;
    private ProgressMonitor progressMonitor = new ProgressMonitor();
    private String task;
    private int nestingDepth;
    protected Cursor arrowCursor;
    private Cursor waitCursor;
    private boolean openOnRun = true;

    protected void updateForClearBlocked() {
        this.progressIndicator.showNormal();
        this.setMessage(this.task, true);
        this.imageLabel.setImage(this.getImage());
    }

    protected void updateForSetBlocked(IStatus iStatus) {
        this.progressIndicator.showPaused();
        this.setMessage(iStatus.getMessage(), true);
        this.imageLabel.setImage(this.getImage());
    }

    public ProgressMonitorDialog(Shell shell) {
        super(shell);
        if (this.isResizable()) {
            this.setShellStyle(ProgressMonitorDialog.getDefaultOrientation() | 0x800 | 0x20 | 0x10000 | 0x10 | 0x400);
        } else {
            this.setShellStyle(ProgressMonitorDialog.getDefaultOrientation() | 0x800 | 0x20 | 0x10000);
        }
        this.setBlockOnOpen(false);
    }

    private void asyncSetOperationCancelButtonEnabled(final boolean bl) {
        if (this.getShell() != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorDialog.this.setOperationCancelButtonEnabled(bl);
                }
            });
        }
    }

    @Override
    protected void cancelPressed() {
        this.cancel.setEnabled(false);
        this.progressMonitor.setCanceled(true);
        super.cancelPressed();
    }

    @Override
    public boolean close() {
        if (this.getNestingDepth() <= 0) {
            this.clearCursors();
            return super.close();
        }
        return false;
    }

    protected void clearCursors() {
        Shell shell;
        if (this.cancel != null && !this.cancel.isDisposed()) {
            this.cancel.setCursor(null);
        }
        if ((shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setCursor(null);
        }
        if (this.arrowCursor != null) {
            this.arrowCursor.dispose();
        }
        if (this.waitCursor != null) {
            this.waitCursor.dispose();
        }
        this.arrowCursor = null;
        this.waitCursor = null;
    }

    @Override
    protected void configureShell(final Shell shell) {
        super.configureShell(shell);
        shell.setText(JFaceResources.getString("ProgressMonitorDialog.title"));
        if (this.waitCursor == null) {
            this.waitCursor = new Cursor((Device)shell.getDisplay(), 1);
        }
        shell.setCursor(this.waitCursor);
        shell.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog.this.setMessage((this).ProgressMonitorDialog.this.message, true);
                    }
                });
            }
        });
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.createCancelButton(composite);
    }

    protected void createCancelButton(Composite composite) {
        this.cancel = this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, true);
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
        }
        this.cancel.setCursor(this.arrowCursor);
        this.setOperationCancelButtonEnabled(this.enableCancelButton);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        this.setMessage(DEFAULT_TASKNAME, false);
        this.createMessageArea(composite);
        this.taskLabel = this.messageLabel;
        this.progressIndicator = new ProgressIndicator(composite);
        GridData gridData = new GridData();
        gridData.heightHint = this.convertVerticalDLUsToPixels(BAR_DLUS);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.progressIndicator.setLayoutData(gridData);
        this.subTaskLabel = new Label(composite, 16448);
        gridData = new GridData(768);
        gridData.heightHint = this.convertVerticalDLUsToPixels(LABEL_DLUS);
        gridData.horizontalSpan = 2;
        this.subTaskLabel.setLayoutData((Object)gridData);
        this.subTaskLabel.setFont(composite.getFont());
        return composite;
    }

    @Override
    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        if (point.x < 450) {
            point.x = 450;
        }
        return point;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    @Override
    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        this.setCancelable(bl2);
        try {
            this.aboutToRun();
            this.progressMonitor.forked = bl;
            ModalContext.run(iRunnableWithProgress, bl, this.getProgressMonitor(), this.getShell().getDisplay());
        }
        finally {
            this.finishedRun();
        }
    }

    public boolean getOpenOnRun() {
        return this.openOnRun;
    }

    public void setOpenOnRun(boolean bl) {
        this.openOnRun = bl;
    }

    protected int getNestingDepth() {
        return this.nestingDepth;
    }

    protected void incrementNestingDepth() {
        ++this.nestingDepth;
    }

    protected void decrementNestingDepth() {
        --this.nestingDepth;
    }

    protected void aboutToRun() {
        if (this.getOpenOnRun()) {
            this.open();
        } else {
            this.create();
        }
        this.incrementNestingDepth();
    }

    protected void finishedRun() {
        this.decrementNestingDepth();
        this.close();
    }

    public void setCancelable(boolean bl) {
        if (this.cancel == null) {
            this.enableCancelButton = bl;
        } else {
            this.asyncSetOperationCancelButtonEnabled(bl);
        }
    }

    protected void setOperationCancelButtonEnabled(boolean bl) {
        this.operationCancelableState = bl;
        if (this.cancel != null && !this.cancel.isDisposed()) {
            this.cancel.setEnabled(bl);
        }
    }

    @Override
    protected Image getImage() {
        return this.getInfoImage();
    }

    private void setMessage(String string, boolean bl) {
        String string2 = this.message = string == null ? "" : string;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        if (bl || this.messageLabel.isVisible()) {
            this.messageLabel.setToolTipText(this.message);
            this.messageLabel.setText(ProgressMonitorDialog.shortenText(this.message, (Control)this.messageLabel));
        }
    }

    private void update() {
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.update();
    }

    @Override
    public int open() {
        if (!this.getOpenOnRun() && this.getNestingDepth() == 0) {
            return 0;
        }
        int n = super.open();
        if (this.task == null || this.task.length() == 0) {
            this.setMessage(DEFAULT_TASKNAME, true);
        } else {
            this.setMessage(this.task, true);
        }
        return n;
    }

    private class ProgressMonitor
    implements IProgressMonitorWithBlocking {
        private String fSubTask = "";
        private volatile boolean fIsCanceled;
        protected boolean forked = false;
        protected boolean locked = false;

        private ProgressMonitor() {
        }

        public void beginTask(String string, int n) {
            if (ProgressMonitorDialog.this.progressIndicator.isDisposed()) {
                return;
            }
            if (string == null) {
                ProgressMonitorDialog.this.task = "";
            } else {
                ProgressMonitorDialog.this.task = string;
            }
            String string2 = ProgressMonitorDialog.this.task;
            if (string2.length() <= 0) {
                string2 = DEFAULT_TASKNAME;
            }
            ProgressMonitorDialog.this.setMessage(string2, false);
            if (!this.forked) {
                ProgressMonitorDialog.this.update();
            }
            if (n == -1) {
                ProgressMonitorDialog.this.progressIndicator.beginAnimatedTask();
            } else {
                ProgressMonitorDialog.this.progressIndicator.beginTask(n);
            }
        }

        public void done() {
            if (!ProgressMonitorDialog.this.progressIndicator.isDisposed()) {
                ProgressMonitorDialog.this.progressIndicator.sendRemainingWork();
                ProgressMonitorDialog.this.progressIndicator.done();
            }
        }

        public void setTaskName(String string) {
            if (string == null) {
                ProgressMonitorDialog.this.task = "";
            } else {
                ProgressMonitorDialog.this.task = string;
            }
            String string2 = ProgressMonitorDialog.this.task;
            if (string2.length() <= 0) {
                string2 = DEFAULT_TASKNAME;
            }
            ProgressMonitorDialog.this.setMessage(string2, false);
            if (!this.forked) {
                ProgressMonitorDialog.this.update();
            }
        }

        public boolean isCanceled() {
            return this.fIsCanceled;
        }

        public void setCanceled(boolean bl) {
            this.fIsCanceled = bl;
            if (this.locked) {
                this.clearBlocked();
            }
        }

        public void subTask(String string) {
            if (ProgressMonitorDialog.this.subTaskLabel.isDisposed()) {
                return;
            }
            this.fSubTask = string == null ? "" : string;
            ProgressMonitorDialog.this.subTaskLabel.setText(ProgressMonitorDialog.shortenText(this.fSubTask, (Control)ProgressMonitorDialog.this.subTaskLabel));
            if (!this.forked) {
                ProgressMonitorDialog.this.subTaskLabel.update();
            }
        }

        public void worked(int n) {
            this.internalWorked(n);
        }

        public void internalWorked(double d) {
            if (!ProgressMonitorDialog.this.progressIndicator.isDisposed()) {
                ProgressMonitorDialog.this.progressIndicator.worked(d);
            }
        }

        public void clearBlocked() {
            if (ProgressMonitorDialog.this.getShell() == null || ProgressMonitorDialog.this.getShell().isDisposed()) {
                return;
            }
            this.locked = false;
            ProgressMonitorDialog.this.updateForClearBlocked();
        }

        public void setBlocked(IStatus iStatus) {
            if (ProgressMonitorDialog.this.getShell() == null || ProgressMonitorDialog.this.getShell().isDisposed()) {
                return;
            }
            this.locked = true;
            ProgressMonitorDialog.this.updateForSetBlocked(iStatus);
        }
    }
}

