/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressIndicator
extends Composite {
    private static final int PROGRESS_MAX = 1000;
    private boolean animated = true;
    private StackLayout layout;
    private ProgressBar determinateProgressBar;
    private ProgressBar indeterminateProgressBar;
    private double totalWork;
    private double sumWorked;

    public ProgressIndicator(Composite composite) {
        this(composite, 0);
    }

    public ProgressIndicator(Composite composite, int n) {
        super(composite, 0);
        if ((n & 0x200) == 0) {
            n |= 0x100;
        }
        this.determinateProgressBar = new ProgressBar((Composite)this, n);
        this.indeterminateProgressBar = new ProgressBar((Composite)this, n | 2);
        this.layout = new StackLayout();
        this.setLayout((Layout)this.layout);
    }

    public void beginAnimatedTask() {
        this.done();
        this.layout.topControl = this.indeterminateProgressBar;
        this.layout();
        this.animated = true;
    }

    public void beginTask(int n) {
        this.done();
        this.totalWork = n;
        this.sumWorked = 0.0;
        this.determinateProgressBar.setMinimum(0);
        this.determinateProgressBar.setMaximum(1000);
        this.determinateProgressBar.setSelection(0);
        this.layout.topControl = this.determinateProgressBar;
        this.layout();
        this.animated = false;
    }

    public void done() {
        if (!this.animated) {
            this.determinateProgressBar.setMinimum(0);
            this.determinateProgressBar.setMaximum(0);
            this.determinateProgressBar.setSelection(0);
        }
        this.layout.topControl = null;
        this.layout();
    }

    public void sendRemainingWork() {
        this.worked(this.totalWork - this.sumWorked);
    }

    public void worked(double d) {
        if (d == 0.0 || this.animated) {
            return;
        }
        this.sumWorked += d;
        if (this.sumWorked > this.totalWork) {
            this.sumWorked = this.totalWork;
        }
        if (this.sumWorked < 0.0) {
            this.sumWorked = 0.0;
        }
        int n = (int)(this.sumWorked / this.totalWork * 1000.0);
        if (this.determinateProgressBar.getSelection() < n) {
            this.determinateProgressBar.setSelection(n);
        }
    }

    public void showError() {
        this.determinateProgressBar.setState(1);
        this.indeterminateProgressBar.setState(1);
    }

    public void showPaused() {
        this.determinateProgressBar.setState(4);
        this.indeterminateProgressBar.setState(4);
    }

    public void showNormal() {
        this.determinateProgressBar.setState(0);
        this.indeterminateProgressBar.setState(0);
    }
}

