/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;

public class PopupDialog
extends Window {
    private static GridDataFactory grabBothGridDataFactory;
    private static final String DIALOG_ORIGIN_X = "DIALOG_X_ORIGIN";
    private static final String DIALOG_ORIGIN_Y = "DIALOG_Y_ORIGIN";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_USE_PERSISTED_BOUNDS = "DIALOG_USE_PERSISTED_BOUNDS";
    private static final String DIALOG_VALUE_MIGRATED_TO_34 = "hasBeenMigratedTo34";
    private static final String DIALOG_USE_PERSISTED_SIZE = "DIALOG_USE_PERSISTED_SIZE";
    private static final String DIALOG_USE_PERSISTED_LOCATION = "DIALOG_USE_PERSISTED_LOCATION";
    public static final int HOVER_SHELLSTYLE = 540676;
    public static final int INFOPOPUP_SHELLSTYLE = 4;
    public static final int INFOPOPUPRESIZE_SHELLSTYLE = 16;
    public static final int POPUP_MARGINWIDTH = 0;
    public static final int POPUP_MARGINHEIGHT = 0;
    public static final int POPUP_VERTICALSPACING = 1;
    public static final int POPUP_HORIZONTALSPACING = 1;
    public static final String POPUP_IMG_MENU = "popup_menu_image";
    public static final String POPUP_IMG_MENU_DISABLED = "popup_menu_image_diabled";
    private static GridLayoutFactory popupLayoutFactory;
    private ToolBar toolBar = null;
    private MenuManager menuManager = null;
    private Control dialogArea;
    private Label titleLabel;
    private Label infoLabel;
    private Control titleSeparator;
    private Control infoSeparator;
    private Color infoColor;
    private Font infoFont;
    private Font titleFont;
    private boolean listenToDeactivate;
    private boolean listenToParentDeactivate;
    private Listener parentDeactivateListener;
    private boolean takeFocusOnOpen = false;
    private boolean showDialogMenu = false;
    private boolean showPersistActions = false;
    private boolean persistSize = false;
    private boolean persistLocation = false;
    private boolean isUsing34API = true;
    private String titleText;
    private String infoText;

    private static GridDataFactory getGrabBothGridData() {
        if (grabBothGridDataFactory == null) {
            grabBothGridDataFactory = GridDataFactory.fillDefaults().grab(true, true);
        }
        return grabBothGridDataFactory;
    }

    private static GridLayoutFactory getPopupLayout() {
        if (popupLayoutFactory == null) {
            popupLayoutFactory = GridLayoutFactory.fillDefaults().margins(0, 0).spacing(1, 1);
        }
        return popupLayoutFactory;
    }

    public PopupDialog(Shell shell, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, String string2) {
        this(shell, n, bl, bl2, bl2, bl3, bl4, string, string2, false);
    }

    public PopupDialog(Shell shell, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, String string2) {
        this(shell, n, bl, bl2, bl3, bl4, bl5, string, string2, true);
    }

    private PopupDialog(Shell shell, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, String string2, boolean bl6) {
        super(shell);
        if ((n & 8) != 0) {
            n &= 0xFFFFFB07;
        }
        this.setShellStyle(n);
        this.takeFocusOnOpen = bl;
        this.showDialogMenu = bl4;
        this.showPersistActions = bl5;
        this.titleText = string;
        this.infoText = string2;
        this.setBlockOnOpen(false);
        this.isUsing34API = bl6;
        this.persistSize = bl2;
        this.persistLocation = bl3;
        this.migrateBoundsSetting();
        this.initializeWidgetState();
    }

    @Override
    protected void configureShell(Shell shell) {
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(5, 5).applyTo((Composite)shell);
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (PopupDialog.this.listenToDeactivate && event.widget == PopupDialog.this.getShell() && PopupDialog.this.getShell().getShells().length == 0) {
                    PopupDialog.this.asyncClose();
                } else {
                    PopupDialog.this.listenToDeactivate = true;
                }
            }
        });
        shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == PopupDialog.this.getShell() && PopupDialog.this.getShell().getShells().length == 0) {
                    PopupDialog.this.listenToDeactivate = true;
                    PopupDialog.this.listenToParentDeactivate = !Util.isMac();
                }
            }
        });
        if ((this.getShellStyle() & 0x4000) != 0 && shell.getParent() != null) {
            this.parentDeactivateListener = new Listener(){

                public void handleEvent(Event event) {
                    if (PopupDialog.this.listenToParentDeactivate) {
                        PopupDialog.this.asyncClose();
                    } else {
                        PopupDialog.this.listenToParentDeactivate = PopupDialog.this.listenToDeactivate;
                    }
                }
            };
            shell.getParent().addListener(27, this.parentDeactivateListener);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                PopupDialog.this.handleDispose();
            }
        });
    }

    private void asyncClose() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PopupDialog.this.close();
            }
        });
    }

    @Override
    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        PopupDialog.getPopupLayout().applyTo(composite2);
        PopupDialog.getGrabBothGridData().applyTo((Control)composite2);
        if (this.hasTitleArea()) {
            this.createTitleMenuArea(composite2);
            this.titleSeparator = this.createHorizontalSeparator(composite2);
        }
        this.dialogArea = this.createDialogArea(composite2);
        if (this.dialogArea.getLayoutData() == null) {
            PopupDialog.getGrabBothGridData().applyTo(this.dialogArea);
        }
        if (this.hasInfoArea()) {
            this.infoSeparator = this.createHorizontalSeparator(composite2);
            this.createInfoTextArea(composite2);
        }
        this.applyColors(composite2);
        this.applyFonts(composite2);
        return composite2;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        PopupDialog.getPopupLayout().applyTo(composite2);
        PopupDialog.getGrabBothGridData().applyTo((Control)composite2);
        return composite2;
    }

    protected Control getFocusControl() {
        return this.dialogArea;
    }

    protected void setTabOrder(Composite composite) {
    }

    protected boolean hasTitleArea() {
        return this.titleText != null || this.showDialogMenu;
    }

    protected boolean hasInfoArea() {
        return this.infoText != null;
    }

    protected Control createTitleMenuArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        PopupDialog.getPopupLayout().copy().numColumns(2).applyTo(composite2);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)composite2);
        this.createTitleControl(composite2);
        if (this.showDialogMenu) {
            this.createDialogMenu(composite2);
        }
        return composite2;
    }

    protected Control createTitleControl(Composite composite) {
        this.titleLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(this.showDialogMenu ? 1 : 2, 1).applyTo((Control)this.titleLabel);
        if (this.titleText != null) {
            this.titleLabel.setText(this.titleText);
        }
        return this.titleLabel;
    }

    protected Control createInfoTextArea(Composite composite) {
        this.infoLabel = new Label(composite, 131072);
        this.infoLabel.setText(this.infoText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.infoLabel);
        Display display = composite.getDisplay();
        this.infoColor = new Color((Device)display, PopupDialog.blend(display.getSystemColor(29).getRGB(), display.getSystemColor(28).getRGB(), 0.56f));
        this.infoLabel.setForeground(this.infoColor);
        return this.infoLabel;
    }

    private static RGB blend(RGB rGB, RGB rGB2, float f) {
        Assert.isLegal((rGB != null ? 1 : 0) != 0);
        Assert.isLegal((rGB2 != null ? 1 : 0) != 0);
        Assert.isLegal((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0);
        float f2 = 1.0f - f;
        return new RGB((int)(f2 * (float)rGB.red + f * (float)rGB2.red), (int)(f2 * (float)rGB.green + f * (float)rGB2.green), (int)(f2 * (float)rGB.blue + f * (float)rGB2.blue));
    }

    private Control createHorizontalSeparator(Composite composite) {
        Label label = new Label(composite, 259);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)label);
        return label;
    }

    private void createDialogMenu(Composite composite) {
        this.toolBar = new ToolBar(composite, 0x800000);
        ToolItem toolItem = new ToolItem(this.toolBar, 8, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.toolBar);
        toolItem.setImage(JFaceResources.getImage(POPUP_IMG_MENU));
        toolItem.setDisabledImage(JFaceResources.getImage(POPUP_IMG_MENU_DISABLED));
        toolItem.setToolTipText(JFaceResources.getString("PopupDialog.menuTooltip"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PopupDialog.this.showDialogMenu();
            }
        });
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                PopupDialog.this.showDialogMenu();
            }
        });
    }

    protected void fillDialogMenu(IMenuManager iMenuManager) {
        iMenuManager.add(new GroupMarker("SystemMenuStart"));
        iMenuManager.add(new MoveAction());
        iMenuManager.add(new ResizeAction());
        if (this.showPersistActions) {
            if (this.isUsing34API) {
                iMenuManager.add(new PersistLocationAction());
                iMenuManager.add(new PersistSizeAction());
            } else {
                iMenuManager.add(new PersistBoundsAction());
            }
        }
        iMenuManager.add(new Separator("SystemMenuEnd"));
    }

    private void performTrackerAction(int n) {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Tracker tracker = new Tracker(shell.getDisplay(), n);
        tracker.setStippled(true);
        Rectangle[] rectangleArray = new Rectangle[]{shell.getBounds()};
        tracker.setRectangles(rectangleArray);
        boolean bl = this.listenToDeactivate;
        this.listenToDeactivate = false;
        if (tracker.open() && !shell.isDisposed()) {
            shell.setBounds(tracker.getRectangles()[0]);
        }
        tracker.dispose();
        this.listenToDeactivate = bl;
    }

    protected void showDialogMenu() {
        if (!this.showDialogMenu) {
            return;
        }
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            this.fillDialogMenu(this.menuManager);
        }
        this.listenToDeactivate = !Util.isGtk();
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle rectangle = this.toolBar.getBounds();
        Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
        point = this.getShell().toDisplay(point);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    protected void setInfoText(String string) {
        this.infoText = string;
        if (this.infoLabel != null) {
            this.infoLabel.setText(string);
        }
    }

    protected void setTitleText(String string) {
        this.titleText = string;
        if (this.titleLabel != null) {
            this.titleLabel.setText(string);
        }
    }

    protected boolean getPersistBounds() {
        return this.persistLocation && this.persistSize;
    }

    protected boolean getPersistLocation() {
        return this.persistLocation;
    }

    protected boolean getPersistSize() {
        return this.persistSize;
    }

    @Override
    public int open() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            shell = null;
            this.create();
            shell = this.getShell();
        }
        this.adjustBounds();
        this.constrainShellSize();
        this.setTabOrder((Composite)this.getContents());
        this.listenToDeactivate = false;
        this.listenToParentDeactivate = false;
        if (this.takeFocusOnOpen) {
            shell.open();
            this.getFocusControl().setFocus();
        } else {
            shell.setVisible(true);
        }
        return 0;
    }

    @Override
    public boolean close() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return true;
        }
        this.saveDialogBounds(this.getShell());
        this.initializeWidgetState();
        if (this.parentDeactivateListener != null) {
            this.getShell().getParent().removeListener(27, this.parentDeactivateListener);
            this.parentDeactivateListener = null;
        }
        return super.close();
    }

    protected IDialogSettings getDialogSettings() {
        return null;
    }

    protected void saveDialogBounds(Shell shell) {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            Object object;
            Point point = shell.getLocation();
            Point point2 = shell.getSize();
            Shell shell2 = this.getParentShell();
            if (shell2 != null) {
                object = shell2.getLocation();
                point.x -= object.x;
                point.y -= object.y;
            }
            object = this.getClass().getName();
            if (this.persistSize) {
                iDialogSettings.put(String.valueOf(object) + DIALOG_WIDTH, point2.x);
                iDialogSettings.put(String.valueOf(object) + DIALOG_HEIGHT, point2.y);
            }
            if (this.persistLocation) {
                iDialogSettings.put(String.valueOf(object) + DIALOG_ORIGIN_X, point.x);
                iDialogSettings.put(String.valueOf(object) + DIALOG_ORIGIN_Y, point.y);
            }
            if (this.showPersistActions && this.showDialogMenu) {
                iDialogSettings.put(String.valueOf(this.getClass().getName()) + DIALOG_USE_PERSISTED_SIZE, this.persistSize);
                iDialogSettings.put(String.valueOf(this.getClass().getName()) + DIALOG_USE_PERSISTED_LOCATION, this.persistLocation);
            }
        }
    }

    @Override
    protected Point getInitialSize() {
        IDialogSettings iDialogSettings;
        Point point = this.getDefaultSize();
        if (this.persistSize && (iDialogSettings = this.getDialogSettings()) != null) {
            try {
                int n = iDialogSettings.getInt(String.valueOf(this.getClass().getName()) + DIALOG_WIDTH);
                int n2 = iDialogSettings.getInt(String.valueOf(this.getClass().getName()) + DIALOG_HEIGHT);
                point = new Point(n, n2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return point;
    }

    protected Point getDefaultSize() {
        return super.getInitialSize();
    }

    protected Point getDefaultLocation(Point point) {
        return super.getInitialLocation(point);
    }

    protected void adjustBounds() {
    }

    @Override
    protected Point getInitialLocation(Point point) {
        IDialogSettings iDialogSettings;
        Point point2 = this.getDefaultLocation(point);
        if (this.persistLocation && (iDialogSettings = this.getDialogSettings()) != null) {
            try {
                int n = iDialogSettings.getInt(String.valueOf(this.getClass().getName()) + DIALOG_ORIGIN_X);
                int n2 = iDialogSettings.getInt(String.valueOf(this.getClass().getName()) + DIALOG_ORIGIN_Y);
                point2 = new Point(n, n2);
                Shell shell = this.getParentShell();
                if (shell != null) {
                    Point point3 = shell.getLocation();
                    point2.x += point3.x;
                    point2.y += point3.y;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return point2;
    }

    private void applyColors(Composite composite) {
        Color color = this.getForeground();
        if (color == null) {
            color = this.getDefaultForeground();
        }
        this.applyForegroundColor(color, (Control)composite, this.getForegroundColorExclusions());
        color = this.getBackground();
        if (color == null) {
            color = this.getDefaultBackground();
        }
        this.applyBackgroundColor(color, (Control)composite, this.getBackgroundColorExclusions());
    }

    protected Color getForeground() {
        return this.getDefaultForeground();
    }

    protected Color getBackground() {
        return this.getDefaultBackground();
    }

    private Color getDefaultForeground() {
        return this.getShell().getDisplay().getSystemColor(28);
    }

    private Color getDefaultBackground() {
        return this.getShell().getDisplay().getSystemColor(29);
    }

    private void applyFonts(Composite composite) {
        int n;
        FontData[] fontDataArray;
        Font font;
        Dialog.applyDialogFont((Control)composite);
        if (this.titleLabel != null) {
            font = this.titleLabel.getFont();
            fontDataArray = font.getFontData();
            n = 0;
            while (n < fontDataArray.length) {
                fontDataArray[n].setStyle(1);
                ++n;
            }
            this.titleFont = new Font((Device)this.titleLabel.getDisplay(), fontDataArray);
            this.titleLabel.setFont(this.titleFont);
        }
        if (this.infoLabel != null) {
            font = this.infoLabel.getFont();
            fontDataArray = font.getFontData();
            n = 0;
            while (n < fontDataArray.length) {
                fontDataArray[n].setHeight(fontDataArray[n].getHeight() * 9 / 10);
                ++n;
            }
            this.infoFont = new Font((Device)this.infoLabel.getDisplay(), fontDataArray);
            this.infoLabel.setFont(this.infoFont);
        }
    }

    private void applyForegroundColor(Color color, Control control, List list) {
        if (!list.contains(control)) {
            control.setForeground(color);
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.applyForegroundColor(color, controlArray[n], list);
                ++n;
            }
        }
    }

    private void applyBackgroundColor(Color color, Control control, List list) {
        if (!list.contains(control)) {
            control.setBackground(color);
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.applyBackgroundColor(color, controlArray[n], list);
                ++n;
            }
        }
    }

    protected void applyForegroundColor(Color color, Control control) {
        this.applyForegroundColor(color, control, this.getForegroundColorExclusions());
    }

    protected void applyBackgroundColor(Color color, Control control) {
        this.applyBackgroundColor(color, control, this.getBackgroundColorExclusions());
    }

    protected List getForegroundColorExclusions() {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        if (this.infoLabel != null) {
            arrayList.add(this.infoLabel);
        }
        if (this.titleSeparator != null) {
            arrayList.add(this.titleSeparator);
        }
        if (this.infoSeparator != null) {
            arrayList.add(this.infoSeparator);
        }
        return arrayList;
    }

    protected List getBackgroundColorExclusions() {
        ArrayList<Control> arrayList = new ArrayList<Control>(2);
        if (this.titleSeparator != null) {
            arrayList.add(this.titleSeparator);
        }
        if (this.infoSeparator != null) {
            arrayList.add(this.infoSeparator);
        }
        return arrayList;
    }

    private void initializeWidgetState() {
        IDialogSettings iDialogSettings;
        this.menuManager = null;
        this.dialogArea = null;
        this.titleLabel = null;
        this.titleSeparator = null;
        this.infoSeparator = null;
        this.infoLabel = null;
        this.toolBar = null;
        if (this.showDialogMenu && this.showPersistActions && (iDialogSettings = this.getDialogSettings()) != null) {
            String string = String.valueOf(this.getClass().getName()) + DIALOG_USE_PERSISTED_SIZE;
            if (iDialogSettings.get(string) != null || !this.isUsing34API) {
                this.persistSize = iDialogSettings.getBoolean(string);
            }
            if (iDialogSettings.get(string = String.valueOf(this.getClass().getName()) + DIALOG_USE_PERSISTED_LOCATION) != null || !this.isUsing34API) {
                this.persistLocation = iDialogSettings.getBoolean(string);
            }
        }
    }

    private void migrateBoundsSetting() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings == null) {
            return;
        }
        String string = this.getClass().getName();
        String string2 = String.valueOf(string) + DIALOG_USE_PERSISTED_BOUNDS;
        String string3 = iDialogSettings.get(string2);
        if (string3 == null || DIALOG_VALUE_MIGRATED_TO_34.equals(string3)) {
            return;
        }
        boolean bl = iDialogSettings.getBoolean(string2);
        iDialogSettings.put(String.valueOf(string) + DIALOG_USE_PERSISTED_LOCATION, bl);
        iDialogSettings.put(String.valueOf(string) + DIALOG_USE_PERSISTED_SIZE, bl);
        iDialogSettings.put(string2, DIALOG_VALUE_MIGRATED_TO_34);
    }

    private void handleDispose() {
        if (this.infoColor != null && !this.infoColor.isDisposed()) {
            this.infoColor.dispose();
        }
        this.infoColor = null;
        if (this.infoFont != null && !this.infoFont.isDisposed()) {
            this.infoFont.dispose();
        }
        this.infoFont = null;
        if (this.titleFont != null && !this.titleFont.isDisposed()) {
            this.titleFont.dispose();
        }
        this.titleFont = null;
    }

    private class MoveAction
    extends Action {
        MoveAction() {
            super(JFaceResources.getString("PopupDialog.move"), 1);
        }

        @Override
        public void run() {
            PopupDialog.this.performTrackerAction(0);
        }
    }

    private class PersistBoundsAction
    extends Action {
        PersistBoundsAction() {
            super(JFaceResources.getString("PopupDialog.persistBounds"), 2);
            this.setChecked(PopupDialog.this.persistLocation && PopupDialog.this.persistSize);
        }

        @Override
        public void run() {
            PopupDialog.this.persistSize = this.isChecked();
            PopupDialog.this.persistLocation = PopupDialog.this.persistSize;
        }
    }

    private class PersistLocationAction
    extends Action {
        PersistLocationAction() {
            super(JFaceResources.getString("PopupDialog.persistLocation"), 2);
            this.setChecked(PopupDialog.this.persistLocation);
        }

        @Override
        public void run() {
            PopupDialog.this.persistLocation = this.isChecked();
        }
    }

    private class PersistSizeAction
    extends Action {
        PersistSizeAction() {
            super(JFaceResources.getString("PopupDialog.persistSize"), 2);
            this.setChecked(PopupDialog.this.persistSize);
        }

        @Override
        public void run() {
            PopupDialog.this.persistSize = this.isChecked();
        }
    }

    private class ResizeAction
    extends Action {
        ResizeAction() {
            super(JFaceResources.getString("PopupDialog.resize"), 1);
        }

        @Override
        public void run() {
            PopupDialog.this.performTrackerAction(16);
        }
    }
}

