/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MessageDialogWithToggle
extends MessageDialog {
    public static final String ALWAYS = "always";
    public static final String NEVER = "never";
    public static final String PROMPT = "prompt";
    private String prefKey = null;
    private IPreferenceStore prefStore = null;
    private Button toggleButton = null;
    private String toggleMessage;
    private boolean toggleState;

    public static MessageDialogWithToggle open(int n, Shell shell, String string, String string2, String string3, boolean bl, IPreferenceStore iPreferenceStore, String string4, int n2) {
        MessageDialogWithToggle messageDialogWithToggle = new MessageDialogWithToggle(shell, string, null, string2, n, MessageDialogWithToggle.getButtonLabels(n), 0, string3, bl);
        messageDialogWithToggle.setShellStyle(messageDialogWithToggle.getShellStyle() | (n2 &= 0x10000000));
        messageDialogWithToggle.prefStore = iPreferenceStore;
        messageDialogWithToggle.prefKey = string4;
        messageDialogWithToggle.open();
        return messageDialogWithToggle;
    }

    public static MessageDialogWithToggle openError(Shell shell, String string, String string2, String string3, boolean bl, IPreferenceStore iPreferenceStore, String string4) {
        return MessageDialogWithToggle.open(1, shell, string, string2, string3, bl, iPreferenceStore, string4, 0);
    }

    public static MessageDialogWithToggle openInformation(Shell shell, String string, String string2, String string3, boolean bl, IPreferenceStore iPreferenceStore, String string4) {
        return MessageDialogWithToggle.open(2, shell, string, string2, string3, bl, iPreferenceStore, string4, 0);
    }

    public static MessageDialogWithToggle openOkCancelConfirm(Shell shell, String string, String string2, String string3, boolean bl, IPreferenceStore iPreferenceStore, String string4) {
        return MessageDialogWithToggle.open(5, shell, string, string2, string3, bl, iPreferenceStore, string4, 0);
    }

    public static MessageDialogWithToggle openWarning(Shell shell, String string, String string2, String string3, boolean bl, IPreferenceStore iPreferenceStore, String string4) {
        return MessageDialogWithToggle.open(4, shell, string, string2, string3, bl, iPreferenceStore, string4, 0);
    }

    public static MessageDialogWithToggle openYesNoCancelQuestion(Shell shell, String string, String string2, String string3, boolean bl, IPreferenceStore iPreferenceStore, String string4) {
        return MessageDialogWithToggle.open(6, shell, string, string2, string3, bl, iPreferenceStore, string4, 0);
    }

    public static MessageDialogWithToggle openYesNoQuestion(Shell shell, String string, String string2, String string3, boolean bl, IPreferenceStore iPreferenceStore, String string4) {
        return MessageDialogWithToggle.open(3, shell, string, string2, string3, bl, iPreferenceStore, string4, 0);
    }

    public MessageDialogWithToggle(Shell shell, String string, Image image, String string2, int n, String[] stringArray, int n2, String string3, boolean bl) {
        super(shell, string, image, string2, n, stringArray, n2);
        this.toggleMessage = string3;
        this.toggleState = bl;
        this.setButtonLabels(stringArray);
    }

    @Override
    protected void buttonPressed(int n) {
        super.buttonPressed(n);
        if (n != 1 && this.toggleState && this.prefStore != null && this.prefKey != null) {
            switch (n) {
                case 0: 
                case 2: 
                case 4: 
                case 10: {
                    this.prefStore.setValue(this.prefKey, ALWAYS);
                    break;
                }
                case 3: 
                case 21: {
                    this.prefStore.setValue(this.prefKey, NEVER);
                }
            }
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        String[] stringArray = this.getButtonLabels();
        Button[] buttonArray = new Button[stringArray.length];
        int n = this.getDefaultButtonIndex();
        int n2 = 256;
        int n3 = 0;
        while (n3 < stringArray.length) {
            Button button;
            String string = stringArray[n3];
            int n4 = this.mapButtonLabelToButtonID(string, n2);
            if (n4 == n2) {
                ++n2;
            }
            buttonArray[n3] = button = this.createButton(composite, n4, string, n == n3);
            ++n3;
        }
        this.setButtons(buttonArray);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.setToggleButton(this.createToggleButton(composite2));
        return composite2;
    }

    protected Button createToggleButton(Composite composite) {
        final Button button = new Button(composite, 16416);
        GridData gridData = new GridData(0);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.setFont(composite.getFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MessageDialogWithToggle.this.toggleState = button.getSelection();
            }
        });
        return button;
    }

    protected Button getToggleButton() {
        return this.toggleButton;
    }

    public IPreferenceStore getPrefStore() {
        return this.prefStore;
    }

    public String getPrefKey() {
        return this.prefKey;
    }

    public boolean getToggleState() {
        return this.toggleState;
    }

    public void setPrefKey(String string) {
        this.prefKey = string;
    }

    public void setPrefStore(IPreferenceStore iPreferenceStore) {
        this.prefStore = iPreferenceStore;
    }

    protected void setToggleButton(Button button) {
        if (button == null) {
            throw new NullPointerException("A message dialog with toggle may not have a null toggle button.");
        }
        if (!button.isDisposed()) {
            String string = this.toggleMessage == null ? JFaceResources.getString("MessageDialogWithToggle.defaultToggleMessage") : this.toggleMessage;
            button.setText(string);
            button.setSelection(this.toggleState);
        }
        this.toggleButton = button;
    }

    protected void setToggleMessage(String string) {
        this.toggleMessage = string;
        if (this.toggleButton != null && !this.toggleButton.isDisposed()) {
            String string2 = this.toggleMessage == null ? JFaceResources.getString("MessageDialogWithToggle.defaultToggleMessage") : this.toggleMessage;
            this.toggleButton.setText(string2);
        }
    }

    public void setToggleState(boolean bl) {
        this.toggleState = bl;
        if (this.toggleButton != null && !this.toggleButton.isDisposed()) {
            this.toggleButton.setSelection(bl);
        }
    }

    private int mapButtonLabelToButtonID(String string, int n) {
        if (IDialogConstants.OK_LABEL.equals(string)) {
            return 0;
        }
        if (IDialogConstants.YES_LABEL.equals(string)) {
            return 2;
        }
        if (IDialogConstants.NO_LABEL.equals(string)) {
            return 3;
        }
        if (IDialogConstants.CANCEL_LABEL.equals(string)) {
            return 1;
        }
        if (IDialogConstants.YES_TO_ALL_LABEL.equals(string)) {
            return 4;
        }
        if (IDialogConstants.SKIP_LABEL.equals(string)) {
            return 5;
        }
        if (IDialogConstants.STOP_LABEL.equals(string)) {
            return 6;
        }
        if (IDialogConstants.ABORT_LABEL.equals(string)) {
            return 7;
        }
        if (IDialogConstants.RETRY_LABEL.equals(string)) {
            return 8;
        }
        if (IDialogConstants.IGNORE_LABEL.equals(string)) {
            return 9;
        }
        if (IDialogConstants.PROCEED_LABEL.equals(string)) {
            return 10;
        }
        if (IDialogConstants.OPEN_LABEL.equals(string)) {
            return 11;
        }
        if (IDialogConstants.CLOSE_LABEL.equals(string)) {
            return 12;
        }
        if (IDialogConstants.BACK_LABEL.equals(string)) {
            return 14;
        }
        if (IDialogConstants.NEXT_LABEL.equals(string)) {
            return 15;
        }
        if (IDialogConstants.FINISH_LABEL.equals(string)) {
            return 16;
        }
        if (IDialogConstants.HELP_LABEL.equals(string)) {
            return 17;
        }
        if (IDialogConstants.NO_TO_ALL_LABEL.equals(string)) {
            return 21;
        }
        if (IDialogConstants.SHOW_DETAILS_LABEL.equals(string)) {
            return 13;
        }
        if (IDialogConstants.HIDE_DETAILS_LABEL.equals(string)) {
            return 13;
        }
        return n;
    }
}

