/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MessageDialog
extends IconAndMessageDialog {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int INFORMATION = 2;
    public static final int QUESTION = 3;
    public static final int WARNING = 4;
    public static final int CONFIRM = 5;
    public static final int QUESTION_WITH_CANCEL = 6;
    private String[] buttonLabels;
    private Button[] buttons;
    private int defaultButtonIndex;
    private String title;
    private Image titleImage;
    private Image image = null;
    private Control customArea;

    public MessageDialog(Shell shell, String string, Image image, String string2, int n, String[] stringArray, int n2) {
        super(shell);
        this.title = string;
        this.titleImage = image;
        this.message = string2;
        switch (n) {
            case 1: {
                this.image = this.getErrorImage();
                break;
            }
            case 2: {
                this.image = this.getInfoImage();
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                this.image = this.getQuestionImage();
                break;
            }
            case 4: {
                this.image = this.getWarningImage();
            }
        }
        this.buttonLabels = stringArray;
        this.defaultButtonIndex = n2;
    }

    @Override
    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        this.close();
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        if (this.titleImage != null) {
            shell.setImage(this.titleImage);
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.buttons = new Button[this.buttonLabels.length];
        int n = 0;
        while (n < this.buttonLabels.length) {
            Button button;
            String string = this.buttonLabels[n];
            this.buttons[n] = button = this.createButton(composite, n, string, this.defaultButtonIndex == n);
            ++n;
        }
    }

    protected Control createCustomArea(Composite composite) {
        return null;
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        this.createMessageArea(composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.customArea = this.createCustomArea(composite2);
        if (this.customArea == null) {
            this.customArea = new Label(composite2, 0);
        }
        return composite2;
    }

    @Override
    protected Button getButton(int n) {
        if (this.buttons == null || n < 0 || n >= this.buttons.length) {
            return null;
        }
        return this.buttons[n];
    }

    protected int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    @Override
    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.setReturnCode(-1);
    }

    @Override
    public int open() {
        return super.open();
    }

    public static boolean open(int n, Shell shell, String string, String string2, int n2) {
        MessageDialog messageDialog = new MessageDialog(shell, string, null, string2, n, MessageDialog.getButtonLabels(n), 0);
        messageDialog.setShellStyle(messageDialog.getShellStyle() | (n2 &= 0x10000000));
        return messageDialog.open() == 0;
    }

    static String[] getButtonLabels(int n) {
        String[] stringArray;
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                stringArray = new String[]{IDialogConstants.OK_LABEL};
                break;
            }
            case 5: {
                stringArray = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                break;
            }
            case 3: {
                stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                break;
            }
            case 6: {
                stringArray = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
            }
        }
        return stringArray;
    }

    public static boolean openConfirm(Shell shell, String string, String string2) {
        return MessageDialog.open(5, shell, string, string2, 0);
    }

    public static void openError(Shell shell, String string, String string2) {
        MessageDialog.open(1, shell, string, string2, 0);
    }

    public static void openInformation(Shell shell, String string, String string2) {
        MessageDialog.open(2, shell, string, string2, 0);
    }

    public static boolean openQuestion(Shell shell, String string, String string2) {
        return MessageDialog.open(3, shell, string, string2, 0);
    }

    public static void openWarning(Shell shell, String string, String string2) {
        MessageDialog.open(4, shell, string, string2, 0);
    }

    @Override
    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        if (bl && !this.customShouldTakeFocus()) {
            button.setFocus();
        }
        return button;
    }

    protected boolean customShouldTakeFocus() {
        if (this.customArea instanceof Label) {
            return false;
        }
        if (this.customArea instanceof CLabel) {
            return (this.customArea.getStyle() & 0x80000) > 0;
        }
        return true;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    protected String[] getButtonLabels() {
        return this.buttonLabels;
    }

    protected int getDefaultButtonIndex() {
        return this.defaultButtonIndex;
    }

    protected void setButtons(Button[] buttonArray) {
        if (buttonArray == null) {
            throw new NullPointerException("The array of buttons cannot be null.");
        }
        this.buttons = buttonArray;
    }

    protected void setButtonLabels(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("The array of button labels cannot be null.");
        }
        this.buttonLabels = stringArray;
    }
}

