/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialog
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private Text text;
    private Text errorMessageText;
    private String errorMessage;

    public InputDialog(Shell shell, String string, String string2, String string3, IInputValidator iInputValidator) {
        super(shell);
        this.title = string;
        this.message = string2;
        this.value = string3 == null ? "" : string3;
        this.validator = iInputValidator;
    }

    @Override
    protected void buttonPressed(int n) {
        this.value = n == 0 ? this.text.getText() : null;
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        if (this.message != null) {
            Label label = new Label(composite2, 64);
            label.setText(this.message);
            GridData gridData = new GridData(1796);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)gridData);
            label.setFont(composite.getFont());
        }
        this.text = new Text(composite2, this.getInputTextStyle());
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                InputDialog.this.validateInput();
            }
        });
        this.errorMessageText = new Text(composite2, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        InputDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected Label getErrorMessageLabel() {
        return null;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String string = null;
        if (this.validator != null) {
            string = this.validator.isValid(this.text.getText());
        }
        this.setErrorMessage(string);
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(string == null ? " \n " : string);
            boolean bl = string != null && StringConverter.removeWhiteSpaces(string).length() > 0;
            this.errorMessageText.setEnabled(bl);
            this.errorMessageText.setVisible(bl);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(string == null);
            }
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

