/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.TextControlCreator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImageAndMessageArea
extends Composite {
    private int BORDER_MARGIN = 2;
    private DecoratedField messageField;
    private Composite container;

    public ImageAndMessageArea(Composite composite, int n) {
        super(composite, n);
        this.container = new Composite((Composite)this, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = this.BORDER_MARGIN;
        gridLayout.marginBottom = this.BORDER_MARGIN;
        this.container.setLayout((Layout)gridLayout);
        this.messageField = new DecoratedField(this.container, 8 | n, new TextControlCreator());
        this.setFont(JFaceResources.getDialogFont());
        GridData gridData = new GridData(4, 4, true, true);
        int n2 = ((Text)this.messageField.getControl()).getLineHeight();
        gridData.heightHint = (n & 0x40) > 0 ? 2 * n2 : n2;
        this.messageField.getLayoutControl().setLayoutData((Object)gridData);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                ImageAndMessageArea.this.onPaint(paintEvent);
            }
        });
        this.setLayout(new Layout(){

            public void layout(Composite composite, boolean bl) {
                Rectangle rectangle = ImageAndMessageArea.this.getClientArea();
                ImageAndMessageArea.this.container.setBounds(rectangle.x + ImageAndMessageArea.this.BORDER_MARGIN, rectangle.y + ImageAndMessageArea.this.BORDER_MARGIN, rectangle.width - 2 * ImageAndMessageArea.this.BORDER_MARGIN, rectangle.height - 2 * ImageAndMessageArea.this.BORDER_MARGIN);
            }

            public Point computeSize(Composite composite, int n, int n2, boolean bl) {
                Point point = ImageAndMessageArea.this.container.computeSize(n, n2, bl);
                point.x += 4;
                point.y += 4;
                return point;
            }
        });
        this.setVisible(false);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.messageField.getLayoutControl().setBackground(color);
        this.messageField.getControl().setBackground(color);
        this.container.setBackground(color);
    }

    public void setText(String string) {
        ((Text)this.messageField.getControl()).setText(string);
    }

    public void setImage(Image image) {
        FieldDecorationRegistry fieldDecorationRegistry = FieldDecorationRegistry.getDefault();
        fieldDecorationRegistry.registerFieldDecoration("messageImage", null, image);
        this.messageField.addFieldDecoration(fieldDecorationRegistry.getFieldDecoration("messageImage"), 16512, false);
    }

    private void onPaint(PaintEvent paintEvent) {
        Rectangle rectangle = this.getClientArea();
        paintEvent.gc.setForeground(this.getForeground());
        paintEvent.gc.drawPolyline(new int[]{rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y + 2, rectangle.x + 2, rectangle.y, rectangle.x + rectangle.width - 3, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1});
    }

    public void setFont(Font font) {
        super.setFont(font);
        ((Text)this.messageField.getControl()).setFont(font);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        ((Text)this.messageField.getControl()).setToolTipText(string);
    }
}

