/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialog
extends IconAndMessageDialog {
    public static boolean AUTOMATED_MODE = false;
    private static final String NESTING_INDENT = "  ";
    private Button detailsButton;
    private String title;
    private List list;
    private boolean listCreated = false;
    private int displayMask = 65535;
    private IStatus status;
    private Clipboard clipboard;
    private boolean shouldIncludeTopLevelErrorInDetails = false;

    public ErrorDialog(Shell shell, String string, String string2, IStatus iStatus, int n) {
        super(shell);
        this.title = string == null ? JFaceResources.getString("Problem_Occurred") : string;
        this.message = string2 == null ? iStatus.getMessage() : JFaceResources.format("Reason", new Object[]{string2, iStatus.getMessage()});
        this.status = iStatus;
        this.displayMask = n;
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(n);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createDetailsButton(composite);
    }

    private void createSupportArea(Composite composite) {
        ErrorSupportProvider errorSupportProvider = Policy.getErrorSupportProvider();
        if (errorSupportProvider == null) {
            return;
        }
        if (!errorSupportProvider.validFor(this.status)) {
            return;
        }
        Composite composite2 = new Composite(composite, 0);
        errorSupportProvider.createSupportArea(composite2, this.status);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        if (composite2.getLayout() == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
        }
    }

    protected void createDetailsButton(Composite composite) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(composite, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.createMessageArea(composite2);
        this.createSupportArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = false;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        return composite2;
    }

    @Override
    protected void createDialogAndButtonArea(Composite composite) {
        Composite composite2;
        super.createDialogAndButtonArea(composite);
        if (this.dialogArea instanceof Composite && (composite2 = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(composite2, 0);
        }
    }

    @Override
    protected Image getImage() {
        if (this.status != null) {
            if (this.status.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (this.status.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    protected List createDropDownList(Composite composite) {
        this.list = new List(composite, 2818);
        this.populateList(this.list);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.horizontalSpan = 2;
        this.list.setLayoutData((Object)gridData);
        this.list.setFont(composite.getFont());
        Menu menu = new Menu((Control)this.list);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ErrorDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ErrorDialog.this.copyToClipboard();
            }
        });
        menuItem.setText(JFaceResources.getString("copy"));
        this.list.setMenu(menu);
        this.listCreated = true;
        return this.list;
    }

    @Override
    public int open() {
        if (!AUTOMATED_MODE && ErrorDialog.shouldDisplay(this.status, this.displayMask)) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    public static int openError(Shell shell, String string, String string2, IStatus iStatus) {
        return ErrorDialog.openError(shell, string, string2, iStatus, 7);
    }

    public static int openError(Shell shell, String string, String string2, IStatus iStatus, int n) {
        ErrorDialog errorDialog = new ErrorDialog(shell, string, string2, iStatus, n);
        return errorDialog.open();
    }

    private void populateList(List list) {
        this.populateList(list, this.status, 0, this.shouldIncludeTopLevelErrorInDetails);
    }

    private boolean listContentExists() {
        return this.listContentExists(this.status, this.shouldIncludeTopLevelErrorInDetails);
    }

    private void populateList(List list, IStatus iStatus, int n, boolean bl) {
        Object object;
        IStatus[] iStatusArray;
        if (!iStatus.matches(this.displayMask)) {
            return;
        }
        Throwable throwable = iStatus.getException();
        boolean bl2 = throwable instanceof CoreException;
        boolean bl3 = false;
        if (bl) {
            iStatusArray = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                iStatusArray.append(NESTING_INDENT);
                ++n2;
            }
            object = iStatus.getMessage();
            iStatusArray.append((String)object);
            list.add(iStatusArray.toString());
            bl3 = true;
        }
        if (!bl2 && throwable != null) {
            iStatusArray = new StringBuffer();
            int n3 = 0;
            while (n3 < n) {
                iStatusArray.append(NESTING_INDENT);
                ++n3;
            }
            object = throwable.getLocalizedMessage();
            if (object == null) {
                object = throwable.toString();
            }
            iStatusArray.append((String)object);
            list.add(iStatusArray.toString());
            bl3 = true;
        }
        if (bl3) {
            ++n;
        }
        if (bl2) {
            iStatusArray = (CoreException)throwable;
            object = iStatusArray.getStatus();
            if (this.message == null || this.message.indexOf(object.getMessage()) == -1) {
                this.populateList(list, (IStatus)object, n, true);
            }
        }
        iStatusArray = iStatus.getChildren();
        int n4 = 0;
        while (n4 < iStatusArray.length) {
            this.populateList(list, iStatusArray[n4], n, true);
            ++n4;
        }
    }

    private boolean listContentExists(IStatus iStatus, boolean bl) {
        IStatus[] iStatusArray;
        if (!iStatus.matches(this.displayMask)) {
            return false;
        }
        Throwable throwable = iStatus.getException();
        boolean bl2 = throwable instanceof CoreException;
        if (bl) {
            return true;
        }
        if (!bl2 && throwable != null) {
            return true;
        }
        boolean bl3 = false;
        if (bl2) {
            iStatusArray = (IStatus[])throwable;
            IStatus iStatus2 = iStatusArray.getStatus();
            if (this.message == null || this.message.indexOf(iStatus2.getMessage()) == -1) {
                bl3 |= this.listContentExists(iStatus2, true);
            }
        }
        iStatusArray = iStatus.getChildren();
        int n = 0;
        while (n < iStatusArray.length) {
            bl3 |= this.listContentExists(iStatusArray[n], true);
            ++n;
        }
        return bl3;
    }

    protected static boolean shouldDisplay(IStatus iStatus, int n) {
        IStatus[] iStatusArray = iStatus.getChildren();
        if (iStatusArray == null || iStatusArray.length == 0) {
            return iStatus.matches(n);
        }
        int n2 = 0;
        while (n2 < iStatusArray.length) {
            if (iStatusArray[n2].matches(n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void toggleDetailsArea() {
        boolean bl = false;
        Point point = this.getShell().getSize();
        if (this.listCreated) {
            this.list.dispose();
            this.listCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
            bl = false;
        } else {
            this.list = this.createDropDownList((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            this.getContents().getShell().layout();
            bl = true;
        }
        Point point2 = this.getShell().computeSize(-1, -1);
        int n = point2.y - point.y;
        if (bl && n > 0 || !bl && n < 0) {
            this.getShell().setSize(new Point(point.x, point.y + n));
        }
    }

    private void populateCopyBuffer(IStatus iStatus, StringBuffer stringBuffer, int n) {
        Object object;
        if (!iStatus.matches(this.displayMask)) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(NESTING_INDENT);
            ++n2;
        }
        stringBuffer.append(iStatus.getMessage());
        stringBuffer.append("\n");
        Throwable throwable = iStatus.getException();
        if (throwable instanceof CoreException) {
            object = (IStatus[])throwable;
            this.populateCopyBuffer(object.getStatus(), stringBuffer, n + 1);
        } else if (throwable != null) {
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(NESTING_INDENT);
                ++n3;
            }
            object = throwable.getLocalizedMessage();
            if (object == null) {
                object = throwable.toString();
            }
            stringBuffer.append((String)object);
            stringBuffer.append("\n");
        }
        object = iStatus.getChildren();
        int n4 = 0;
        while (n4 < ((IStatus[])object).length) {
            this.populateCopyBuffer(object[n4], stringBuffer, n + 1);
            ++n4;
        }
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.populateCopyBuffer(this.status, stringBuffer, 0);
        this.clipboard = new Clipboard(this.list.getDisplay());
        this.clipboard.setContents(new Object[]{stringBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    @Override
    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.listCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return this.listContentExists();
    }

    protected final void setStatus(IStatus iStatus) {
        if (this.status != iStatus) {
            this.status = iStatus;
        }
        this.shouldIncludeTopLevelErrorInDetails = true;
        if (this.listCreated) {
            this.repopulateList();
        }
    }

    private void repopulateList() {
        if (this.list != null && !this.list.isDisposed()) {
            this.list.removeAll();
            this.populateList(this.list);
        }
    }

    @Override
    int getColumnCount() {
        if (Policy.getErrorSupportProvider() == null) {
            return 2;
        }
        return 3;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }
}

