/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DialogSettings
implements IDialogSettings {
    private String name;
    private Map sections;
    private Map items;
    private Map arrayItems;
    private static final String TAG_SECTION = "section";
    private static final String TAG_NAME = "name";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private static final String TAG_LIST = "list";
    private static final String TAG_ITEM = "item";

    public DialogSettings(String string) {
        this.name = string;
        this.items = new HashMap();
        this.arrayItems = new HashMap();
        this.sections = new HashMap();
    }

    @Override
    public IDialogSettings addNewSection(String string) {
        DialogSettings dialogSettings = new DialogSettings(string);
        this.addSection(dialogSettings);
        return dialogSettings;
    }

    @Override
    public void addSection(IDialogSettings iDialogSettings) {
        this.sections.put(iDialogSettings.getName(), iDialogSettings);
    }

    @Override
    public String get(String string) {
        return (String)this.items.get(string);
    }

    @Override
    public String[] getArray(String string) {
        return (String[])this.arrayItems.get(string);
    }

    @Override
    public boolean getBoolean(String string) {
        return Boolean.valueOf((String)this.items.get(string));
    }

    @Override
    public double getDouble(String string) throws NumberFormatException {
        String string2 = (String)this.items.get(string);
        if (string2 == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + string + "\"");
        }
        return new Double(string2);
    }

    @Override
    public float getFloat(String string) throws NumberFormatException {
        String string2 = (String)this.items.get(string);
        if (string2 == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + string + "\"");
        }
        return new Float(string2).floatValue();
    }

    @Override
    public int getInt(String string) throws NumberFormatException {
        String string2 = (String)this.items.get(string);
        if (string2 == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + string + "\"");
        }
        return new Integer(string2);
    }

    @Override
    public long getLong(String string) throws NumberFormatException {
        String string2 = (String)this.items.get(string);
        if (string2 == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + string + "\"");
        }
        return new Long(string2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static IDialogSettings getOrCreateSection(IDialogSettings iDialogSettings, String string) {
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }

    @Override
    public IDialogSettings getSection(String string) {
        return (IDialogSettings)this.sections.get(string);
    }

    @Override
    public IDialogSettings[] getSections() {
        Collection collection = this.sections.values();
        IDialogSettings[] iDialogSettingsArray = new DialogSettings[collection.size()];
        collection.toArray(iDialogSettingsArray);
        return iDialogSettingsArray;
    }

    @Override
    public void load(Reader reader) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(reader));
            Node node = document.getFirstChild();
            while (node.getNodeType() == 8) {
                document.removeChild(node);
                node = document.getFirstChild();
            }
            this.load(document, (Element)node);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    @Override
    public void load(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
        this.load(bufferedReader);
        bufferedReader.close();
    }

    private void load(Document document, Element element) {
        String string;
        Object object;
        Node node;
        this.name = element.getAttribute(TAG_NAME);
        NodeList nodeList = element.getElementsByTagName(TAG_ITEM);
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (element == node.getParentNode()) {
                object = ((Element)nodeList.item(n)).getAttribute(TAG_KEY);
                string = ((Element)nodeList.item(n)).getAttribute(TAG_VALUE);
                this.items.put(object, string);
            }
            ++n;
        }
        nodeList = element.getElementsByTagName(TAG_LIST);
        n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (element == node.getParentNode()) {
                object = (Element)nodeList.item(n);
                string = object.getAttribute(TAG_KEY);
                NodeList nodeList2 = object.getElementsByTagName(TAG_ITEM);
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Element element2 = (Element)nodeList2.item(n2);
                    if (object == element2.getParentNode()) {
                        arrayList.add(element2.getAttribute(TAG_VALUE));
                    }
                    ++n2;
                }
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                this.arrayItems.put(string, stringArray);
            }
            ++n;
        }
        nodeList = element.getElementsByTagName(TAG_SECTION);
        n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (element == node.getParentNode()) {
                object = new DialogSettings("NoName");
                super.load(document, (Element)node);
                this.addSection((IDialogSettings)object);
            }
            ++n;
        }
    }

    @Override
    public void put(String string, String[] stringArray) {
        this.arrayItems.put(string, stringArray);
    }

    @Override
    public void put(String string, double d) {
        this.put(string, String.valueOf(d));
    }

    @Override
    public void put(String string, float f) {
        this.put(string, String.valueOf(f));
    }

    @Override
    public void put(String string, int n) {
        this.put(string, String.valueOf(n));
    }

    @Override
    public void put(String string, long l) {
        this.put(string, String.valueOf(l));
    }

    @Override
    public void put(String string, String string2) {
        this.items.put(string, string2);
    }

    @Override
    public void put(String string, boolean bl) {
        this.put(string, String.valueOf(bl));
    }

    @Override
    public void save(Writer writer) throws IOException {
        XMLWriter xMLWriter = new XMLWriter(writer);
        this.save(xMLWriter);
        xMLWriter.flush();
    }

    @Override
    public void save(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        XMLWriter xMLWriter = new XMLWriter(fileOutputStream);
        this.save(xMLWriter);
        xMLWriter.close();
    }

    private void save(XMLWriter xMLWriter) throws IOException {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(TAG_NAME, this.name == null ? "" : this.name);
        xMLWriter.startTag(TAG_SECTION, hashMap);
        hashMap.clear();
        for (String string : this.items.keySet()) {
            hashMap.put(TAG_KEY, string == null ? "" : string);
            stringArray = (String[])this.items.get(string);
            hashMap.put(TAG_VALUE, (String)(stringArray == null ? "" : stringArray));
            xMLWriter.printTag(TAG_ITEM, hashMap, true);
        }
        hashMap.clear();
        for (String string : this.arrayItems.keySet()) {
            hashMap.put(TAG_KEY, string == null ? "" : string);
            xMLWriter.startTag(TAG_LIST, hashMap);
            stringArray = (String[])this.arrayItems.get(string);
            hashMap.clear();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    String string2 = stringArray[n];
                    hashMap.put(TAG_VALUE, string2 == null ? "" : string2);
                    xMLWriter.printTag(TAG_ITEM, hashMap, true);
                    ++n;
                }
            }
            xMLWriter.endTag(TAG_LIST);
            hashMap.clear();
        }
        Iterator<Object> iterator = this.sections.values().iterator();
        while (iterator.hasNext()) {
            ((DialogSettings)iterator.next()).save(xMLWriter);
        }
        xMLWriter.endTag(TAG_SECTION);
    }

    private static class XMLWriter
    extends BufferedWriter {
        protected int tab = 0;
        protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

        public XMLWriter(OutputStream outputStream) throws IOException {
            this(new OutputStreamWriter(outputStream, "UTF8"));
        }

        public XMLWriter(Writer writer) throws IOException {
            super(writer);
            this.writeln(XML_VERSION);
        }

        private void writeln(String string) throws IOException {
            this.write(string);
            this.newLine();
        }

        public void endTag(String string) throws IOException {
            --this.tab;
            this.printTag("/" + string, null, false);
        }

        private void printTabulation() throws IOException {
            int n = 0;
            while (n < this.tab) {
                super.write(9);
                ++n;
            }
        }

        public void printTag(String string, HashMap hashMap, boolean bl) throws IOException {
            this.printTag(string, hashMap, true, true, bl);
        }

        private void printTag(String string, HashMap hashMap, boolean bl, boolean bl2, boolean bl3) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('<');
            stringBuffer.append(string);
            if (hashMap != null) {
                Enumeration enumeration = Collections.enumeration(hashMap.keySet());
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(" ");
                    String string2 = (String)enumeration.nextElement();
                    stringBuffer.append(string2);
                    stringBuffer.append("=\"");
                    stringBuffer.append(XMLWriter.getEscaped(String.valueOf(hashMap.get(string2))));
                    stringBuffer.append("\"");
                }
            }
            if (bl3) {
                stringBuffer.append('/');
            }
            stringBuffer.append('>');
            if (bl) {
                this.printTabulation();
            }
            if (bl2) {
                this.writeln(stringBuffer.toString());
            } else {
                this.write(stringBuffer.toString());
            }
        }

        public void startTag(String string, HashMap hashMap) throws IOException {
            this.startTag(string, hashMap, true);
            ++this.tab;
        }

        private void startTag(String string, HashMap hashMap, boolean bl) throws IOException {
            this.printTag(string, hashMap, true, bl, false);
        }

        private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
            String string = XMLWriter.getReplacement(c);
            if (string != null) {
                stringBuffer.append('&');
                stringBuffer.append(string);
                stringBuffer.append(';');
            } else {
                stringBuffer.append(c);
            }
        }

        private static String getEscaped(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            int n = 0;
            while (n < string.length()) {
                XMLWriter.appendEscapedChar(stringBuffer, string.charAt(n));
                ++n;
            }
            return stringBuffer.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

