/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class DialogPage
implements IDialogPage,
IMessageProvider {
    private Control control;
    private String title = null;
    private String description = null;
    private Image image = null;
    private ImageDescriptor imageDescriptor = null;
    private String message = null;
    private int messageType = 0;
    private String errorMessage = null;
    private FontMetrics fontMetrics;

    protected DialogPage() {
    }

    protected DialogPage(String string) {
        this.title = string;
    }

    protected DialogPage(String string, ImageDescriptor imageDescriptor) {
        this(string);
        this.imageDescriptor = imageDescriptor;
    }

    protected int convertHeightInCharsToPixels(int n) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels(this.fontMetrics, n);
    }

    protected int convertHorizontalDLUsToPixels(int n) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHorizontalDLUsToPixels(this.fontMetrics, n);
    }

    protected int convertVerticalDLUsToPixels(int n) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertVerticalDLUsToPixels(this.fontMetrics, n);
    }

    protected int convertWidthInCharsToPixels(int n) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels(this.fontMetrics, n);
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected String getDialogFontName() {
        return "org.eclipse.jface.dialogfont";
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected Font getFont() {
        return JFaceResources.getFontRegistry().get(this.getDialogFontName());
    }

    @Override
    public Image getImage() {
        if (this.image == null && this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getMessageType() {
        return this.messageType;
    }

    public Shell getShell() {
        return this.getControl().getShell();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected final String getToolTipText(int n) {
        return null;
    }

    protected void initializeDialogUnits(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    protected GridData setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
        return gridData;
    }

    protected boolean isControlCreated() {
        return this.control != null;
    }

    @Override
    public void performHelp() {
    }

    protected void setControl(Control control) {
        this.control = control;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    @Override
    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void setMessage(String string) {
        this.setMessage(string, 0);
    }

    public void setMessage(String string, int n) {
        this.message = string;
        this.messageType = n;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public void setVisible(boolean bl) {
        this.control.setVisible(bl);
    }
}

