/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DialogMessageArea {
    private Text messageText;
    private Label messageImageLabel;
    private Composite messageComposite;
    private String lastMessageText;
    private int lastMessageType;
    private CLabel titleLabel;

    public void createContents(Composite composite) {
        this.titleLabel = new CLabel(composite, 0);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.messageComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.messageComposite.setLayout((Layout)gridLayout);
        this.messageImageLabel = new Label(this.messageComposite, 0);
        this.messageImageLabel.setImage(JFaceResources.getImage("dialog_messasge_info_image"));
        this.messageImageLabel.setLayoutData((Object)new GridData(4));
        this.messageText = new Text(this.messageComposite, 0);
        this.messageText.setEditable(false);
        GridData gridData = new GridData(772);
        this.messageText.setLayoutData((Object)gridData);
    }

    public void setTitleLayoutData(Object object) {
        this.titleLabel.setLayoutData(object);
    }

    public void setMessageLayoutData(Object object) {
        this.messageComposite.setLayoutData(object);
    }

    public void showTitle(String string, Image image) {
        this.titleLabel.setImage(image);
        this.titleLabel.setText(string);
        this.restoreTitle();
    }

    public void restoreTitle() {
        this.titleLabel.setVisible(true);
        this.messageComposite.setVisible(false);
        this.lastMessageText = null;
        this.lastMessageType = 0;
    }

    public void updateText(String string, int n) {
        Image image = null;
        switch (n) {
            case 0: {
                if (string == null) {
                    this.restoreTitle();
                } else {
                    this.showTitle(string, null);
                }
                return;
            }
            case 1: {
                image = JFaceResources.getImage("dialog_messasge_info_image");
                break;
            }
            case 2: {
                image = JFaceResources.getImage("dialog_messasge_warning_image");
                break;
            }
            case 3: {
                image = JFaceResources.getImage("dialog_message_error_image");
            }
        }
        this.messageComposite.setVisible(true);
        this.titleLabel.setVisible(false);
        String string2 = Dialog.shortenText(string, (Control)this.messageText);
        if (string.equals(this.messageText.getToolTipText()) && image == this.messageImageLabel.getImage() && string2.equals(this.messageText.getText())) {
            return;
        }
        this.messageImageLabel.setImage(image);
        this.messageText.setText(Dialog.shortenText(string, (Control)this.messageText));
        this.messageText.setToolTipText(string);
        this.lastMessageText = string;
    }

    public void clearErrorMessage() {
        if (this.lastMessageText == null) {
            this.restoreTitle();
        } else {
            this.updateText(this.lastMessageText, this.lastMessageType);
        }
    }
}

