/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ControlEnableState {
    private List exceptions = null;
    private List states = new ArrayList();

    protected ControlEnableState(Control control) {
        this(control, null);
    }

    protected ControlEnableState(Control control, List list) {
        this.exceptions = list;
        this.readStateForAndDisable(control);
    }

    public static ControlEnableState disable(Control control) {
        return new ControlEnableState(control);
    }

    public static ControlEnableState disable(Control control, List list) {
        return new ControlEnableState(control, list);
    }

    private void readStateForAndDisable(Control control) {
        if (this.exceptions != null && this.exceptions.contains(control)) {
            return;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.readStateForAndDisable(controlArray[n]);
                ++n;
            }
        }
        this.states.add(new ItemState(control, control.getEnabled()));
        control.setEnabled(false);
    }

    public void restore() {
        int n = this.states.size();
        int n2 = 0;
        while (n2 < n) {
            ((ItemState)this.states.get(n2)).restore();
            ++n2;
        }
    }

    private class ItemState {
        protected Control item;
        protected boolean state;

        public ItemState(Control control, boolean bl) {
            this.item = control;
            this.state = bl;
        }

        public void restore() {
            if (this.item == null || this.item.isDisposed()) {
                return;
            }
            this.item.setEnabled(this.state);
        }
    }
}

