/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.jface.commands.ToggleState;

public class RadioState
extends ToggleState {
    private String radioGroupIdentifier = null;

    public void dispose() {
        this.setRadioGroupIdentifier(null);
    }

    public final void setRadioGroupIdentifier(String string) {
        if (string == null) {
            RadioStateManager.unregisterState(this.radioGroupIdentifier, this);
            this.radioGroupIdentifier = null;
        } else {
            this.radioGroupIdentifier = string;
            RadioStateManager.registerState(string, this);
        }
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof Boolean)) {
            throw new IllegalArgumentException("RadioState takes a Boolean as a value");
        }
        if (((Boolean)object).booleanValue() && this.radioGroupIdentifier != null) {
            RadioStateManager.activateGroup(this.radioGroupIdentifier, this);
        }
        super.setValue(object);
    }

    private static final class RadioStateManager {
        private static Map radioStatesById = null;

        private RadioStateManager() {
        }

        private static final void activateGroup(String string, RadioState radioState) {
            if (radioStatesById == null) {
                return;
            }
            Object v = radioStatesById.get(string);
            if (v instanceof RadioGroup) {
                RadioGroup radioGroup = (RadioGroup)v;
                radioGroup.activateMember(radioState);
            }
        }

        private static final void registerState(String string, RadioState radioState) {
            RadioGroup radioGroup;
            Object v;
            if (radioStatesById == null) {
                radioStatesById = new HashMap();
            }
            if ((v = radioStatesById.get(string)) instanceof RadioGroup) {
                radioGroup = (RadioGroup)v;
            } else {
                radioGroup = new RadioGroup();
                radioStatesById.put(string, radioGroup);
            }
            radioGroup.addMember(radioState);
        }

        private static final void unregisterState(String string, RadioState radioState) {
            if (radioStatesById == null) {
                return;
            }
            Object v = radioStatesById.get(string);
            if (v instanceof RadioGroup) {
                RadioGroup radioGroup = (RadioGroup)v;
                radioGroup.removeMember(radioState);
            }
        }

        private static final class RadioGroup
        implements IStateListener {
            private RadioState active = null;
            private Set members = null;

            private RadioGroup() {
            }

            private final void activateMember(RadioState radioState) {
                if (this.active != null && this.active != radioState) {
                    this.active.setValue(Boolean.FALSE);
                }
                this.active = radioState;
            }

            private final void addMember(RadioState radioState) {
                if (this.members == null) {
                    this.members = new HashSet(5);
                }
                this.members.add(radioState);
                radioState.addListener(this);
                Object object = radioState.getValue();
                if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                    this.activateMember(radioState);
                }
            }

            public final void handleStateChange(State state, Object object) {
                Object object2 = state.getValue();
                if (object2 instanceof Boolean && ((Boolean)object2).booleanValue()) {
                    this.activateMember((RadioState)state);
                }
            }

            private final void removeMember(RadioState radioState) {
                radioState.removeListener(this);
                if (this.active == radioState) {
                    this.active = null;
                }
                if (this.members == null) {
                    return;
                }
                this.members.remove((Object)radioState);
            }
        }
    }
}

