/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Event;

public final class ActionHandler
extends AbstractHandler {
    private final IAction action;
    private IPropertyChangeListener propertyChangeListener;

    public ActionHandler(IAction iAction) {
        if (iAction == null) {
            throw new NullPointerException();
        }
        this.action = iAction;
    }

    public final void addHandlerListener(IHandlerListener iHandlerListener) {
        if (!this.hasListeners()) {
            this.attachListener();
        }
        super.addHandlerListener(iHandlerListener);
    }

    private final void attachListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                @Override
                public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getProperty();
                    ActionHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)ActionHandler.this, "enabled".equals(string), "handled".equals(string)));
                }
            };
        }
        this.action.addPropertyChangeListener(this.propertyChangeListener);
    }

    private final void detachListener() {
        this.action.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public final void dispose() {
        if (this.hasListeners()) {
            this.action.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public final Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        if (this.action.getStyle() == 2 || this.action.getStyle() == 8) {
            this.action.setChecked(!this.action.isChecked());
        }
        Object object = executionEvent.getTrigger();
        try {
            if (object instanceof Event) {
                this.action.runWithEvent((Event)object);
            } else {
                this.action.runWithEvent(new Event());
            }
        }
        catch (Exception exception) {
            throw new ExecutionException("While executing the action, an exception occurred", (Throwable)exception);
        }
        return null;
    }

    public final IAction getAction() {
        return this.action;
    }

    public final boolean isEnabled() {
        return this.action.isEnabled();
    }

    public final boolean isHandled() {
        return this.action.isHandled();
    }

    public final void removeHandlerListener(IHandlerListener iHandlerListener) {
        super.removeHandlerListener(iHandlerListener);
        if (!this.hasListeners()) {
            this.detachListener();
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ActionHandler(");
        stringBuffer.append(this.action);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

