/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys.formatting;

import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.formatting.AbstractKeyFormatter;
import org.eclipse.jface.util.Util;

public final class NativeKeyFormatter
extends AbstractKeyFormatter {
    private static final String CARBON_KEY_DELIMITER_KEY = "CARBON_KEY_DELIMITER";
    private static final HashMap CARBON_KEY_LOOK_UP = new HashMap();
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(NativeKeyFormatter.class.getName());
    private static final String WIN32_KEY_STROKE_DELIMITER_KEY = "WIN32_KEY_STROKE_DELIMITER";

    static {
        CARBON_KEY_LOOK_UP.put("BS", "\u232b");
        CARBON_KEY_LOOK_UP.put("BACKSPACE", "\u232b");
        CARBON_KEY_LOOK_UP.put("CR", "\u21a9");
        CARBON_KEY_LOOK_UP.put("DEL", "\u2326");
        CARBON_KEY_LOOK_UP.put("DELETE", "\u2326");
        CARBON_KEY_LOOK_UP.put("ALT", "\u2325");
        CARBON_KEY_LOOK_UP.put("COMMAND", "\u2318");
        CARBON_KEY_LOOK_UP.put("CTRL", "\u2303");
        CARBON_KEY_LOOK_UP.put("SHIFT", "\u21e7");
        CARBON_KEY_LOOK_UP.put("ARROW_DOWN", "\u2193");
        CARBON_KEY_LOOK_UP.put("ARROW_LEFT", "\u2190");
        CARBON_KEY_LOOK_UP.put("ARROW_RIGHT", "\u2192");
        CARBON_KEY_LOOK_UP.put("ARROW_UP", "\u2191");
        CARBON_KEY_LOOK_UP.put("END", "\u2198");
        CARBON_KEY_LOOK_UP.put("NUMPAD_ENTER", "\u2324");
        CARBON_KEY_LOOK_UP.put("HOME", "\u2196");
        CARBON_KEY_LOOK_UP.put("PAGE_DOWN", "\u21df");
        CARBON_KEY_LOOK_UP.put("PAGE_UP", "\u21de");
    }

    @Override
    public final String format(int n) {
        String string;
        IKeyLookup iKeyLookup = KeyLookupFactory.getDefault();
        String string2 = iKeyLookup.formalNameLookup(n);
        if (Util.isMac() && (string = (String)CARBON_KEY_LOOK_UP.get(string2)) != null) {
            return string;
        }
        return super.format(n);
    }

    @Override
    protected String getKeyDelimiter() {
        if (Util.isMac()) {
            return Util.translateString(RESOURCE_BUNDLE, CARBON_KEY_DELIMITER_KEY, "");
        }
        return Util.translateString(RESOURCE_BUNDLE, "KEY_DELIMITER", "+");
    }

    @Override
    protected String getKeyStrokeDelimiter() {
        if (Util.isWindows()) {
            return Util.translateString(RESOURCE_BUNDLE, WIN32_KEY_STROKE_DELIMITER_KEY, " ");
        }
        return Util.translateString(RESOURCE_BUNDLE, "KEY_STROKE_DELIMITER", " ");
    }

    @Override
    protected int[] sortModifierKeys(int n) {
        IKeyLookup iKeyLookup = KeyLookupFactory.getDefault();
        int[] nArray = new int[4];
        int n2 = 0;
        if (Util.isWindows()) {
            if ((n & iKeyLookup.getCtrl()) != 0) {
                nArray[n2++] = iKeyLookup.getCtrl();
            }
            if ((n & iKeyLookup.getAlt()) != 0) {
                nArray[n2++] = iKeyLookup.getAlt();
            }
            if ((n & iKeyLookup.getShift()) != 0) {
                nArray[n2++] = iKeyLookup.getShift();
            }
        } else if (Util.isGtk() || Util.isMotif()) {
            if ((n & iKeyLookup.getShift()) != 0) {
                nArray[n2++] = iKeyLookup.getShift();
            }
            if ((n & iKeyLookup.getCtrl()) != 0) {
                nArray[n2++] = iKeyLookup.getCtrl();
            }
            if ((n & iKeyLookup.getAlt()) != 0) {
                nArray[n2++] = iKeyLookup.getAlt();
            }
        } else if (Util.isMac()) {
            if ((n & iKeyLookup.getShift()) != 0) {
                nArray[n2++] = iKeyLookup.getShift();
            }
            if ((n & iKeyLookup.getCtrl()) != 0) {
                nArray[n2++] = iKeyLookup.getCtrl();
            }
            if ((n & iKeyLookup.getAlt()) != 0) {
                nArray[n2++] = iKeyLookup.getAlt();
            }
            if ((n & iKeyLookup.getCommand()) != 0) {
                nArray[n2++] = iKeyLookup.getCommand();
            }
        }
        return nArray;
    }
}

