/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys.formatting;

import java.util.ResourceBundle;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.formatting.AbstractKeyFormatter;
import org.eclipse.jface.util.Util;

public final class EmacsKeyFormatter
extends AbstractKeyFormatter {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(EmacsKeyFormatter.class.getName());

    @Override
    public String format(int n) {
        String string;
        IKeyLookup iKeyLookup = KeyLookupFactory.getDefault();
        if (iKeyLookup.isModifierKey(n) && (string = Util.translateString(RESOURCE_BUNDLE, iKeyLookup.formalNameLookup(n), null)) != null) {
            return string;
        }
        return super.format(n).toLowerCase();
    }

    @Override
    protected String getKeyDelimiter() {
        return Util.translateString(RESOURCE_BUNDLE, "KEY_DELIMITER", "+");
    }

    @Override
    protected String getKeyStrokeDelimiter() {
        return Util.translateString(RESOURCE_BUNDLE, "KEY_STROKE_DELIMITER", " ");
    }

    @Override
    protected int[] sortModifierKeys(int n) {
        IKeyLookup iKeyLookup = KeyLookupFactory.getDefault();
        int[] nArray = new int[4];
        int n2 = 0;
        if ((n & iKeyLookup.getAlt()) != 0) {
            nArray[n2++] = iKeyLookup.getAlt();
        }
        if ((n & iKeyLookup.getCommand()) != 0) {
            nArray[n2++] = iKeyLookup.getCommand();
        }
        if ((n & iKeyLookup.getCtrl()) != 0) {
            nArray[n2++] = iKeyLookup.getCtrl();
        }
        if ((n & iKeyLookup.getShift()) != 0) {
            nArray[n2++] = iKeyLookup.getShift();
        }
        return nArray;
    }
}

