/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys.formatting;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.util.Util;

public abstract class AbstractKeyFormatter
implements IKeyFormatter {
    protected static final String KEY_DELIMITER_KEY = "KEY_DELIMITER";
    protected static final String KEY_STROKE_DELIMITER_KEY = "KEY_STROKE_DELIMITER";
    protected static final int[] NO_MODIFIER_KEYS = new int[0];
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(AbstractKeyFormatter.class.getName());
    private static final Set resourceBundleKeys = new HashSet();

    static {
        Enumeration<String> enumeration = RESOURCE_BUNDLE.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            resourceBundleKeys.add(string);
        }
    }

    @Override
    public String format(int n) {
        IKeyLookup iKeyLookup = KeyLookupFactory.getDefault();
        String string = iKeyLookup.formalNameLookup(n);
        if (resourceBundleKeys.contains(string)) {
            return Util.translateString(RESOURCE_BUNDLE, string, string);
        }
        return string;
    }

    @Override
    public String format(KeySequence keySequence) {
        StringBuffer stringBuffer = new StringBuffer();
        KeyStroke[] keyStrokeArray = keySequence.getKeyStrokes();
        int n = keyStrokeArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.format(keyStrokeArray[n2]));
            if (n2 + 1 < n) {
                stringBuffer.append(this.getKeyStrokeDelimiter());
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    @Override
    public String format(KeyStroke keyStroke) {
        int n;
        String string = this.getKeyDelimiter();
        int n2 = keyStroke.getModifierKeys();
        int[] nArray = this.sortModifierKeys(n2);
        StringBuffer stringBuffer = new StringBuffer();
        if (nArray != null) {
            n = 0;
            while (n < nArray.length) {
                int n3 = nArray[n];
                if (n3 != 0) {
                    stringBuffer.append(this.format(n3));
                    stringBuffer.append(string);
                }
                ++n;
            }
        }
        if ((n = keyStroke.getNaturalKey()) != 0) {
            stringBuffer.append(this.format(n));
        }
        return stringBuffer.toString();
    }

    protected abstract String getKeyDelimiter();

    protected abstract String getKeyStrokeDelimiter();

    protected abstract int[] sortModifierKeys(int var1);
}

