/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.NativeKeyFormatter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;

public final class SWTKeySupport {
    private static final IKeyFormatter NATIVE_FORMATTER = new NativeKeyFormatter();

    public static final KeyStroke convertAcceleratorToKeyStroke(int n) {
        int n2 = n & SWT.MODIFIER_MASK;
        int n3 = n == n2 ? 0 : n - n2;
        return KeyStroke.getInstance(n2, n3);
    }

    public static final int convertEventToModifiedAccelerator(Event event) {
        int n = event.stateMask & SWT.MODIFIER_MASK;
        char c = SWTKeySupport.topKey(event);
        return n + SWTKeySupport.toUpperCase(c);
    }

    public static final int convertEventToUnmodifiedAccelerator(Event event) {
        return SWTKeySupport.convertEventToUnmodifiedAccelerator(event.stateMask, event.keyCode);
    }

    private static final int convertEventToUnmodifiedAccelerator(int n, int n2) {
        int n3 = n & SWT.MODIFIER_MASK;
        int n4 = n2;
        return n3 + SWTKeySupport.toUpperCase(n4);
    }

    public static final int convertEventToUnmodifiedAccelerator(KeyEvent keyEvent) {
        return SWTKeySupport.convertEventToUnmodifiedAccelerator(keyEvent.stateMask, keyEvent.keyCode);
    }

    public static final int convertEventToUnshiftedModifiedAccelerator(Event event) {
        if (Character.isLetter((char)event.keyCode)) {
            return SWTKeySupport.convertEventToUnmodifiedAccelerator(event);
        }
        int n = event.stateMask & (SWT.MODIFIER_MASK ^ 0x20000);
        char c = SWTKeySupport.topKey(event);
        return n + SWTKeySupport.toUpperCase(c);
    }

    public static final int convertKeyStrokeToAccelerator(KeyStroke keyStroke) {
        return keyStroke.getModifierKeys() + keyStroke.getNaturalKey();
    }

    public static IKeyFormatter getKeyFormatterForPlatform() {
        return NATIVE_FORMATTER;
    }

    private static final char topKey(Event event) {
        boolean bl;
        char c = event.character;
        boolean bl2 = bl = (event.stateMask & 0x40000) != 0;
        if (bl && event.character != event.keyCode && event.character < ' ' && (event.keyCode & 0x1000000) == 0) {
            c = (char)(c + 64);
        }
        return c;
    }

    private static final int toUpperCase(int n) {
        if (n > 65535) {
            return n;
        }
        char c = (char)n;
        return Character.isLetter(c) ? (int)Character.toUpperCase(c) : n;
    }

    protected SWTKeySupport() {
    }
}

