/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;

public final class SWTKeyLookup
implements IKeyLookup {
    private final Map modifierKeyTable = new HashMap();
    private final Map nameTable = new HashMap();
    private final Map naturalKeyTable = new HashMap();

    SWTKeyLookup() {
        Integer n = new Integer(65536);
        Integer n2 = new Integer(0x400000);
        Integer n3 = new Integer(262144);
        Integer n4 = new Integer(131072);
        this.modifierKeyTable.put("ALT", n);
        this.nameTable.put(n, "ALT");
        this.modifierKeyTable.put("COMMAND", n2);
        this.nameTable.put(n2, "COMMAND");
        this.modifierKeyTable.put("CTRL", n3);
        this.nameTable.put(n3, "CTRL");
        this.modifierKeyTable.put("SHIFT", n4);
        this.nameTable.put(n4, "SHIFT");
        this.modifierKeyTable.put("M1", Util.isMac() ? n2 : n3);
        this.modifierKeyTable.put("M2", n4);
        this.modifierKeyTable.put("M3", n);
        this.modifierKeyTable.put("M4", Util.isMac() ? n3 : n2);
        Integer n5 = new Integer(0x1000002);
        this.naturalKeyTable.put("ARROW_DOWN", n5);
        this.nameTable.put(n5, "ARROW_DOWN");
        Integer n6 = new Integer(0x1000003);
        this.naturalKeyTable.put("ARROW_LEFT", n6);
        this.nameTable.put(n6, "ARROW_LEFT");
        Integer n7 = new Integer(0x1000004);
        this.naturalKeyTable.put("ARROW_RIGHT", n7);
        this.nameTable.put(n7, "ARROW_RIGHT");
        Integer n8 = new Integer(0x1000001);
        this.naturalKeyTable.put("ARROW_UP", n8);
        this.nameTable.put(n8, "ARROW_UP");
        Integer n9 = new Integer(16777302);
        this.naturalKeyTable.put("BREAK", n9);
        this.nameTable.put(n9, "BREAK");
        Integer n10 = new Integer(8);
        this.naturalKeyTable.put("BS", n10);
        this.nameTable.put(n10, "BS");
        this.naturalKeyTable.put("BACKSPACE", n10);
        Integer n11 = new Integer(16777298);
        this.naturalKeyTable.put("CAPS_LOCK", n11);
        this.nameTable.put(n11, "CAPS_LOCK");
        Integer n12 = new Integer(13);
        this.naturalKeyTable.put("CR", n12);
        this.nameTable.put(n12, "CR");
        this.naturalKeyTable.put("ENTER", n12);
        this.naturalKeyTable.put("RETURN", n12);
        Integer n13 = new Integer(127);
        this.naturalKeyTable.put("DEL", n13);
        this.nameTable.put(n13, "DEL");
        this.naturalKeyTable.put("DELETE", n13);
        Integer n14 = new Integer(0x1000008);
        this.naturalKeyTable.put("END", n14);
        this.nameTable.put(n14, "END");
        Integer n15 = new Integer(27);
        this.naturalKeyTable.put("ESC", n15);
        this.nameTable.put(n15, "ESC");
        this.naturalKeyTable.put("ESCAPE", n15);
        Integer n16 = new Integer(0x100000A);
        this.naturalKeyTable.put("F1", n16);
        this.nameTable.put(n16, "F1");
        Integer n17 = new Integer(0x100000B);
        this.naturalKeyTable.put("F2", new Integer(0x100000B));
        this.nameTable.put(n17, "F2");
        Integer n18 = new Integer(0x100000C);
        this.naturalKeyTable.put("F3", new Integer(0x100000C));
        this.nameTable.put(n18, "F3");
        Integer n19 = new Integer(0x100000D);
        this.naturalKeyTable.put("F4", new Integer(0x100000D));
        this.nameTable.put(n19, "F4");
        Integer n20 = new Integer(0x100000E);
        this.naturalKeyTable.put("F5", new Integer(0x100000E));
        this.nameTable.put(n20, "F5");
        Integer n21 = new Integer(0x100000F);
        this.naturalKeyTable.put("F6", new Integer(0x100000F));
        this.nameTable.put(n21, "F6");
        Integer n22 = new Integer(0x1000010);
        this.naturalKeyTable.put("F7", new Integer(0x1000010));
        this.nameTable.put(n22, "F7");
        Integer n23 = new Integer(0x1000011);
        this.naturalKeyTable.put("F8", new Integer(0x1000011));
        this.nameTable.put(n23, "F8");
        Integer n24 = new Integer(0x1000012);
        this.naturalKeyTable.put("F9", new Integer(0x1000012));
        this.nameTable.put(n24, "F9");
        Integer n25 = new Integer(0x1000013);
        this.naturalKeyTable.put("F10", new Integer(0x1000013));
        this.nameTable.put(n25, "F10");
        Integer n26 = new Integer(0x1000014);
        this.naturalKeyTable.put("F11", new Integer(0x1000014));
        this.nameTable.put(n26, "F11");
        Integer n27 = new Integer(0x1000015);
        this.naturalKeyTable.put("F12", new Integer(0x1000015));
        this.nameTable.put(n27, "F12");
        Integer n28 = new Integer(0x1000016);
        this.naturalKeyTable.put("F13", new Integer(0x1000016));
        this.nameTable.put(n28, "F13");
        Integer n29 = new Integer(0x1000017);
        this.naturalKeyTable.put("F14", new Integer(0x1000017));
        this.nameTable.put(n29, "F14");
        Integer n30 = new Integer(0x1000018);
        this.naturalKeyTable.put("F15", new Integer(0x1000018));
        this.nameTable.put(n30, "F15");
        Integer n31 = new Integer(0x1000019);
        this.naturalKeyTable.put("F16", new Integer(0x1000019));
        this.nameTable.put(n31, "F16");
        Integer n32 = new Integer(0x100001A);
        this.naturalKeyTable.put("F17", new Integer(0x100001A));
        this.nameTable.put(n32, "F17");
        Integer n33 = new Integer(0x100001B);
        this.naturalKeyTable.put("F18", new Integer(0x100001B));
        this.nameTable.put(n33, "F18");
        Integer n34 = new Integer(0x100001C);
        this.naturalKeyTable.put("F19", new Integer(0x100001C));
        this.nameTable.put(n34, "F19");
        Integer n35 = new Integer(0x100001D);
        this.naturalKeyTable.put("F20", new Integer(0x100001D));
        this.nameTable.put(n35, "F20");
        Integer n36 = new Integer(12);
        this.naturalKeyTable.put("FF", n36);
        this.nameTable.put(n36, "FF");
        Integer n37 = new Integer(0x1000007);
        this.naturalKeyTable.put("HOME", n37);
        this.nameTable.put(n37, "HOME");
        Integer n38 = new Integer(0x1000009);
        this.naturalKeyTable.put("INSERT", n38);
        this.nameTable.put(n38, "INSERT");
        Integer n39 = new Integer(10);
        this.naturalKeyTable.put("LF", n39);
        this.nameTable.put(n39, "LF");
        Integer n40 = new Integer(0);
        this.naturalKeyTable.put("NUL", n40);
        this.nameTable.put(n40, "NUL");
        Integer n41 = new Integer(16777299);
        this.naturalKeyTable.put("NUM_LOCK", n41);
        this.nameTable.put(n41, "NUM_LOCK");
        Integer n42 = new Integer(0x1000030);
        this.naturalKeyTable.put("NUMPAD_0", n42);
        this.nameTable.put(n42, "NUMPAD_0");
        Integer n43 = new Integer(0x1000031);
        this.naturalKeyTable.put("NUMPAD_1", n43);
        this.nameTable.put(n43, "NUMPAD_1");
        Integer n44 = new Integer(16777266);
        this.naturalKeyTable.put("NUMPAD_2", n44);
        this.nameTable.put(n44, "NUMPAD_2");
        Integer n45 = new Integer(0x1000033);
        this.naturalKeyTable.put("NUMPAD_3", n45);
        this.nameTable.put(n45, "NUMPAD_3");
        Integer n46 = new Integer(16777268);
        this.naturalKeyTable.put("NUMPAD_4", n46);
        this.nameTable.put(n46, "NUMPAD_4");
        Integer n47 = new Integer(16777269);
        this.naturalKeyTable.put("NUMPAD_5", n47);
        this.nameTable.put(n47, "NUMPAD_5");
        Integer n48 = new Integer(16777270);
        this.naturalKeyTable.put("NUMPAD_6", n48);
        this.nameTable.put(n48, "NUMPAD_6");
        Integer n49 = new Integer(16777271);
        this.naturalKeyTable.put("NUMPAD_7", n49);
        this.nameTable.put(n49, "NUMPAD_7");
        Integer n50 = new Integer(16777272);
        this.naturalKeyTable.put("NUMPAD_8", n50);
        this.nameTable.put(n50, "NUMPAD_8");
        Integer n51 = new Integer(16777273);
        this.naturalKeyTable.put("NUMPAD_9", n51);
        this.nameTable.put(n51, "NUMPAD_9");
        Integer n52 = new Integer(16777259);
        this.naturalKeyTable.put("NUMPAD_ADD", n52);
        this.nameTable.put(n52, "NUMPAD_ADD");
        Integer n53 = new Integer(16777262);
        this.naturalKeyTable.put("NUMPAD_DECIMAL", n53);
        this.nameTable.put(n53, "NUMPAD_DECIMAL");
        Integer n54 = new Integer(16777263);
        this.naturalKeyTable.put("NUMPAD_DIVIDE", n54);
        this.nameTable.put(n54, "NUMPAD_DIVIDE");
        Integer n55 = new Integer(0x1000050);
        this.naturalKeyTable.put("NUMPAD_ENTER", n55);
        this.nameTable.put(n55, "NUMPAD_ENTER");
        Integer n56 = new Integer(16777277);
        this.naturalKeyTable.put("NUMPAD_EQUAL", n56);
        this.nameTable.put(n56, "NUMPAD_EQUAL");
        Integer n57 = new Integer(16777258);
        this.naturalKeyTable.put("NUMPAD_MULTIPLY", n57);
        this.nameTable.put(n57, "NUMPAD_MULTIPLY");
        Integer n58 = new Integer(16777261);
        this.naturalKeyTable.put("NUMPAD_SUBTRACT", n58);
        this.nameTable.put(n58, "NUMPAD_SUBTRACT");
        Integer n59 = new Integer(0x1000006);
        this.naturalKeyTable.put("PAGE_DOWN", n59);
        this.nameTable.put(n59, "PAGE_DOWN");
        Integer n60 = new Integer(0x1000005);
        this.naturalKeyTable.put("PAGE_UP", n60);
        this.nameTable.put(n60, "PAGE_UP");
        Integer n61 = new Integer(0x1000055);
        this.naturalKeyTable.put("PAUSE", n61);
        this.nameTable.put(n61, "PAUSE");
        Integer n62 = new Integer(16777303);
        this.naturalKeyTable.put("PRINT_SCREEN", n62);
        this.nameTable.put(n62, "PRINT_SCREEN");
        Integer n63 = new Integer(16777300);
        this.naturalKeyTable.put("SCROLL_LOCK", n63);
        this.nameTable.put(n63, "SCROLL_LOCK");
        Integer n64 = new Integer(32);
        this.naturalKeyTable.put("SPACE", n64);
        this.nameTable.put(n64, "SPACE");
        Integer n65 = new Integer(9);
        this.naturalKeyTable.put("TAB", n65);
        this.nameTable.put(n65, "TAB");
        Integer n66 = new Integer(11);
        this.naturalKeyTable.put("VT", n66);
        this.nameTable.put(n66, "VT");
    }

    @Override
    public final int formalKeyLookup(String string) {
        Object v = this.naturalKeyTable.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (string.length() > 0) {
            throw new IllegalArgumentException("Unrecognized formal key name: " + string);
        }
        return string.charAt(0);
    }

    @Override
    public final Integer formalKeyLookupInteger(String string) {
        Object v = this.naturalKeyTable.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return new Integer(string.charAt(0));
    }

    @Override
    public final int formalModifierLookup(String string) {
        Object v = this.modifierKeyTable.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return 0;
    }

    @Override
    public final String formalNameLookup(int n) {
        Integer n2 = new Integer(n);
        Object v = this.nameTable.get(n2);
        if (v instanceof String) {
            return (String)v;
        }
        return "" + (char)n;
    }

    @Override
    public final int getAlt() {
        return 65536;
    }

    @Override
    public final int getCommand() {
        return 0x400000;
    }

    @Override
    public final int getCtrl() {
        return 262144;
    }

    @Override
    public final int getShift() {
        return 131072;
    }

    @Override
    public final boolean isModifierKey(int n) {
        return (n & SWT.MODIFIER_MASK) != 0;
    }
}

