/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys;

import java.util.StringTokenizer;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.jface.util.Util;

public final class KeyStroke
extends Trigger
implements Comparable {
    public static final String KEY_DELIMITER = "+";
    public static final String KEY_DELIMITERS = "+";
    public static final int NO_KEY = 0;
    private final int modifierKeys;
    private final int naturalKey;

    public static final KeyStroke getInstance(int n) {
        return new KeyStroke(0, n);
    }

    public static final KeyStroke getInstance(int n, int n2) {
        return new KeyStroke(n, n2);
    }

    public static final KeyStroke getInstance(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("Cannot parse a null string");
        }
        IKeyLookup iKeyLookup = KeyLookupFactory.getDefault();
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+", true);
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n3 % 2 == 0) {
                if (stringTokenizer.hasMoreTokens()) {
                    int n4 = iKeyLookup.formalModifierLookup(string2 = string2.toUpperCase());
                    if (n4 == 0) {
                        throw new ParseException("Cannot create key stroke with duplicate or non-existent modifier key: " + string2);
                    }
                    n |= n4;
                } else if (string2.length() == 1) {
                    n2 = string2.charAt(0);
                } else {
                    string2 = string2.toUpperCase();
                    n2 = iKeyLookup.formalKeyLookup(string2);
                }
            }
            ++n3;
        }
        return new KeyStroke(n, n2);
    }

    private KeyStroke(int n, int n2) {
        this.modifierKeys = n;
        this.naturalKey = n2;
    }

    public final int compareTo(Object object) {
        KeyStroke keyStroke = (KeyStroke)object;
        int n = Util.compare(this.modifierKeys, keyStroke.modifierKeys);
        if (n == 0) {
            n = Util.compare(this.naturalKey, keyStroke.naturalKey);
        }
        return n;
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof KeyStroke)) {
            return false;
        }
        KeyStroke keyStroke = (KeyStroke)object;
        if (this.modifierKeys != keyStroke.modifierKeys) {
            return false;
        }
        return this.naturalKey == keyStroke.naturalKey;
    }

    public final String format() {
        return KeyFormatterFactory.getDefault().format(this);
    }

    public final int getModifierKeys() {
        return this.modifierKeys;
    }

    public final int getNaturalKey() {
        return this.naturalKey;
    }

    @Override
    public final int hashCode() {
        return this.modifierKeys << 4 + this.naturalKey;
    }

    public final boolean isComplete() {
        return this.naturalKey != 0;
    }

    public final String toString() {
        return KeyFormatterFactory.getFormalKeyFormatter().format(this);
    }
}

