/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public final class KeySequenceText {
    private static final String EMPTY_STRING = "";
    public static final int INFINITE = -1;
    public static final String P_KEY_SEQUENCE = "org.eclipse.jface.bindings.keys.KeySequenceText.KeySequence";
    public static final List TRAPPED_KEYS;
    private final KeyTrapListener keyFilter = new KeyTrapListener();
    private KeySequence keySequence = KeySequence.getInstance();
    private Collection listeners = null;
    private int maxStrokes = -1;
    private final Text text;
    private final UpdateSequenceListener updateSequenceListener = new UpdateSequenceListener();

    static {
        TreeSet<KeyStroke> treeSet = new TreeSet<KeyStroke>();
        treeSet.add(SWTKeySupport.convertAcceleratorToKeyStroke(9));
        treeSet.add(SWTKeySupport.convertAcceleratorToKeyStroke(131081));
        treeSet.add(SWTKeySupport.convertAcceleratorToKeyStroke(8));
        ArrayList arrayList = new ArrayList(treeSet);
        TRAPPED_KEYS = Collections.unmodifiableList(arrayList);
    }

    public KeySequenceText(Text text) {
        Object object;
        this.text = text;
        if (Util.isMac()) {
            object = new Font((Device)this.text.getDisplay(), "Lucida Grande", 13, 0);
            this.text.setFont(object);
            this.text.addDisposeListener(new DisposeListener((Font)object){
                private final /* synthetic */ Font val$font;
                {
                    this.val$font = font;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    this.val$font.dispose();
                }
            });
        }
        this.text.addListener(2, (Listener)this.keyFilter);
        this.text.addListener(1, (Listener)this.keyFilter);
        object = new TraversalFilterManager();
        this.text.addFocusListener((FocusListener)object);
        this.text.addDisposeListener(new DisposeListener((TraversalFilterManager)object){
            private final /* synthetic */ TraversalFilterManager val$traversalFilterManager;
            {
                this.val$traversalFilterManager = traversalFilterManager;
            }

            public void widgetDisposed(DisposeEvent disposeEvent) {
                this.val$traversalFilterManager.dispose();
            }
        });
        this.text.addModifyListener((ModifyListener)this.updateSequenceListener);
    }

    public final void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (iPropertyChangeListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(iPropertyChangeListener);
    }

    public void clear() {
        KeySequence keySequence = this.keySequence;
        this.keySequence = KeySequence.getInstance();
        this.text.setText(EMPTY_STRING);
        this.firePropertyChangeEvent(keySequence);
    }

    /*
     * Unable to fully structure code
     */
    private final int deleteSelection(KeyStroke[] var1_1, boolean var2_2, KeyStroke[][] var3_3) {
        var4_4 = this.text.getSelection();
        var5_5 = var4_4.x;
        var6_6 = var4_4.y;
        var7_7 = new String();
        var8_8 = new ArrayList<KeyStroke>();
        var9_9 = 0;
        var10_10 = var1_1.length;
        var11_11 = 0;
        while (var11_11 < var10_10 && var7_7.length() < var5_5) {
            var9_9 = var7_7.length();
            var8_8.add(var1_1[var11_11]);
            var7_7 = KeySequence.getInstance(var8_8).format();
            ++var11_11;
        }
        var12_12 = var7_7.length() == var5_5 ? var8_8.size() : var8_8.size() - 1;
        if (var5_5 != var6_6) ** GOTO lbl24
        var3_3[0] = var1_1;
        return var12_12;
lbl-1000:
        // 1 sources

        {
            var8_8.add(var1_1[var11_11]);
            var7_7 = KeySequence.getInstance(var8_8).format();
            ++var11_11;
lbl24:
            // 2 sources

            ** while (var11_11 < var10_10 && var7_7.length() < var6_6)
        }
lbl25:
        // 1 sources

        var13_13 = var8_8.size() - 1;
        if (var13_13 < 0) {
            var13_13 = 0;
        }
        var14_14 = var10_10 - (var13_13 - var12_12 + 1);
        var3_3[0] = new KeyStroke[var14_14];
        var15_15 = var1_1[var12_12];
        var16_16 = new KeyStroke[var14_14];
        System.arraycopy(var1_1, 0, var16_16, 0, var12_12);
        System.arraycopy(var1_1, var13_13 + 1, var16_16, var12_12, var10_10 - var13_13 - 1);
        System.arraycopy(var16_16, 0, var3_3[0], 0, var14_14);
        if (var2_2 && var9_9 + (var19_19 = (var18_18 = KeyStroke.getInstance(var17_17 = var15_15.getModifierKeys(), 0)).format().length()) <= var5_5) {
            var20_20 = new KeyStroke[var14_14 + 1];
            System.arraycopy(var3_3[0], 0, var20_20, 0, var12_12);
            var20_20[var12_12] = var18_18;
            System.arraycopy(var3_3[0], var12_12, var20_20, var12_12 + 1, var14_14 - var12_12);
            var3_3[0] = var20_20;
        }
        return var12_12;
    }

    protected final void firePropertyChangeEvent(KeySequence keySequence) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, P_KEY_SEQUENCE, keySequence, this.getKeySequence());
            while (iterator.hasNext()) {
                IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)iterator.next();
                iPropertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    private String getText() {
        return this.text.getText();
    }

    private boolean hasIncompleteStroke() {
        return !this.keySequence.isComplete();
    }

    private boolean hasSelection() {
        return this.text.getSelectionCount() > 0;
    }

    public void insert(KeyStroke keyStroke) {
        KeyStroke[] keyStrokeArray;
        if (!keyStroke.isComplete()) {
            return;
        }
        KeySequence keySequence = this.getKeySequence();
        KeyStroke[] keyStrokeArray2 = keySequence.getKeyStrokes();
        if (this.hasIncompleteStroke() && !keySequence.isEmpty()) {
            int n = keyStrokeArray2.length - 1;
            keyStrokeArray = new KeyStroke[n];
            System.arraycopy(keyStrokeArray2, 0, keyStrokeArray, 0, n);
        } else {
            keyStrokeArray = keyStrokeArray2;
        }
        KeyStroke[][] keyStrokeArray3 = new KeyStroke[1][];
        int n = this.deleteSelection(keyStrokeArray, false, keyStrokeArray3);
        if (n == -1) {
            n = 0;
        }
        KeyStroke[] keyStrokeArray4 = this.insertStrokeAt(keyStrokeArray, keyStroke, n);
        this.keyFilter.clearInsertionIndex();
        this.setKeySequence(KeySequence.getInstance(keyStrokeArray4));
    }

    private final KeyStroke[] insertStrokeAt(KeyStroke[] keyStrokeArray, KeyStroke keyStroke, int n) {
        KeyStroke keyStroke2;
        int n2 = keyStrokeArray.length;
        KeyStroke keyStroke3 = keyStroke2 = n >= n2 ? null : keyStrokeArray[n];
        if (keyStroke2 != null && !keyStroke2.isComplete()) {
            int n3 = keyStroke2.getModifierKeys();
            int n4 = keyStroke.getNaturalKey();
            keyStrokeArray[n] = KeyStroke.getInstance(n3 |= keyStroke.getModifierKeys(), n4);
            return keyStrokeArray;
        }
        KeyStroke[] keyStrokeArray2 = new KeyStroke[n2 + 1];
        System.arraycopy(keyStrokeArray, 0, keyStrokeArray2, 0, n);
        keyStrokeArray2[n] = keyStroke;
        if (n < n2) {
            System.arraycopy(keyStrokeArray, n, keyStrokeArray2, n + 1, n2 - n);
        }
        return keyStrokeArray2;
    }

    private boolean isCursorInLastPosition() {
        return this.text.getSelection().y >= this.getText().length();
    }

    public final void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (iPropertyChangeListener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(iPropertyChangeListener);
    }

    public void setKeySequence(KeySequence keySequence) {
        KeyStroke[] keyStrokeArray;
        KeyStroke[] keyStrokeArray2;
        KeySequence keySequence2 = this.keySequence;
        if (keySequence == null) {
            this.text.setText(EMPTY_STRING);
        } else {
            this.keySequence = keySequence;
        }
        if (this.maxStrokes != -1 && this.maxStrokes < (keyStrokeArray2 = this.keySequence.getKeyStrokes()).length) {
            keyStrokeArray = new KeyStroke[this.maxStrokes];
            System.arraycopy(keyStrokeArray2, 0, keyStrokeArray, 0, this.maxStrokes);
            this.keySequence = KeySequence.getInstance(keyStrokeArray);
        }
        if (!(keyStrokeArray2 = this.getText()).equals(keyStrokeArray = this.keySequence.format())) {
            this.text.removeModifyListener((ModifyListener)this.updateSequenceListener);
            this.text.setText(this.keySequence.format());
            this.text.addModifyListener((ModifyListener)this.updateSequenceListener);
            this.text.setSelection(this.getText().length());
        }
        this.firePropertyChangeEvent(keySequence2);
    }

    public int getKeyStrokeLimit() {
        return this.maxStrokes;
    }

    public void setKeyStrokeLimit(int n) {
        if (n <= 0 && n != -1) {
            throw new IllegalArgumentException();
        }
        this.maxStrokes = n;
        this.setKeySequence(this.getKeySequence());
    }

    private class KeyTrapListener
    implements Listener {
        private int insertionIndex = -1;

        private KeyTrapListener() {
        }

        void clearInsertionIndex() {
            this.insertionIndex = -1;
        }

        private final KeyStroke[] deleteKeyStroke(KeyStroke[] keyStrokeArray) {
            this.clearInsertionIndex();
            if (KeySequenceText.this.hasSelection()) {
                KeyStroke[][] keyStrokeArray2 = new KeyStroke[1][];
                KeySequenceText.this.deleteSelection(keyStrokeArray, false, keyStrokeArray2);
                return keyStrokeArray2[0];
            }
            if (keyStrokeArray.length > 0) {
                int n = keyStrokeArray.length - 1;
                KeyStroke[] keyStrokeArray3 = new KeyStroke[n];
                System.arraycopy(keyStrokeArray, 0, keyStrokeArray3, 0, n);
                return keyStrokeArray3;
            }
            return keyStrokeArray;
        }

        public void handleEvent(Event event) {
            KeyStroke[] keyStrokeArray = KeySequenceText.this.getKeySequence().getKeyStrokes();
            if (event.type == 1) {
                keyStrokeArray = this.handleKeyDown(event, keyStrokeArray);
            } else if (event.type == 2) {
                keyStrokeArray = this.handleKeyUp(event, keyStrokeArray);
            }
            KeySequenceText.this.setKeySequence(KeySequence.getInstance(keyStrokeArray));
            event.doit = false;
        }

        private KeyStroke[] handleKeyDown(Event event, KeyStroke[] keyStrokeArray) {
            if ((event.character == '\b' || event.character == '\u007f') && event.stateMask == 0) {
                return this.deleteKeyStroke(keyStrokeArray);
            }
            return this.insertKeyStroke(event, keyStrokeArray);
        }

        private final KeyStroke[] handleKeyUp(Event event, KeyStroke[] keyStrokeArray) {
            if (KeySequenceText.this.hasIncompleteStroke()) {
                KeyStroke[] keyStrokeArray2;
                Event event2 = new Event();
                event2.stateMask = (event.keyCode & SWT.MODIFIER_MASK) != 0 ? event.stateMask - event.keyCode : event.stateMask;
                int n = SWTKeySupport.convertEventToUnmodifiedAccelerator(event2);
                KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke(n);
                int n2 = keyStrokeArray.length;
                if (n2 > 0 && keyStroke.getModifierKeys() != 0) {
                    keyStrokeArray2 = new KeyStroke[n2];
                    System.arraycopy(keyStrokeArray, 0, keyStrokeArray2, 0, n2 - 1);
                    keyStrokeArray2[n2 - 1] = keyStroke;
                } else if (n2 > 0) {
                    keyStrokeArray2 = new KeyStroke[n2 - 1];
                    System.arraycopy(keyStrokeArray, 0, keyStrokeArray2, 0, n2 - 1);
                } else if (keyStroke.getModifierKeys() != 0) {
                    keyStrokeArray2 = new KeyStroke[n2 + 1];
                    System.arraycopy(keyStrokeArray, 0, keyStrokeArray2, 0, n2);
                    keyStrokeArray2[n2] = keyStroke;
                } else {
                    keyStrokeArray2 = keyStrokeArray;
                }
                return keyStrokeArray2;
            }
            return keyStrokeArray;
        }

        private final KeyStroke[] insertKeyStroke(Event event, KeyStroke[] keyStrokeArray) {
            int n = SWTKeySupport.convertEventToUnmodifiedAccelerator(event);
            KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke(n);
            if (16777299 == keyStroke.getNaturalKey() || 16777298 == keyStroke.getNaturalKey() || 16777300 == keyStroke.getNaturalKey()) {
                return keyStrokeArray;
            }
            if (this.insertionIndex != -1) {
                if (keyStroke.isComplete()) {
                    keyStrokeArray = KeySequenceText.this.insertStrokeAt(keyStrokeArray, keyStroke, this.insertionIndex);
                    this.clearInsertionIndex();
                }
            } else if (KeySequenceText.this.hasSelection()) {
                KeyStroke[][] keyStrokeArray2 = new KeyStroke[1][];
                this.insertionIndex = KeySequenceText.this.deleteSelection(keyStrokeArray, keyStroke.isComplete(), keyStrokeArray2);
                keyStrokeArray = keyStrokeArray2[0];
                if (keyStroke.isComplete() || this.insertionIndex >= keyStrokeArray.length) {
                    keyStrokeArray = KeySequenceText.this.insertStrokeAt(keyStrokeArray, keyStroke, this.insertionIndex);
                    this.clearInsertionIndex();
                }
            } else {
                KeyStroke[] keyStrokeArray3;
                if (KeySequenceText.this.hasIncompleteStroke() && keyStrokeArray.length > 0) {
                    keyStrokeArray3 = new KeyStroke[keyStrokeArray.length - 1];
                    System.arraycopy(keyStrokeArray, 0, keyStrokeArray3, 0, keyStrokeArray.length - 1);
                    keyStrokeArray = keyStrokeArray3;
                }
                if (keyStrokeArray.length == 0 || this.insertionIndex >= keyStrokeArray.length || KeySequenceText.this.isCursorInLastPosition()) {
                    keyStrokeArray = KeySequenceText.this.insertStrokeAt(keyStrokeArray, keyStroke, keyStrokeArray.length);
                    this.clearInsertionIndex();
                } else {
                    keyStrokeArray3 = new KeyStroke[1][];
                    this.insertionIndex = KeySequenceText.this.deleteSelection(keyStrokeArray, keyStroke.isComplete(), (KeyStroke[][])keyStrokeArray3);
                    keyStrokeArray = keyStrokeArray3[0];
                    if (keyStroke.isComplete()) {
                        keyStrokeArray = KeySequenceText.this.insertStrokeAt(keyStrokeArray, keyStroke, this.insertionIndex);
                        this.clearInsertionIndex();
                    }
                }
            }
            return keyStrokeArray;
        }
    }

    private class TraversalFilter
    implements Listener {
        private TraversalFilter() {
        }

        public void handleEvent(Event event) {
            switch (event.detail) {
                case 0: 
                case 2: 
                case 4: 
                case 128: 
                case 256: 
                case 512: {
                    event.type = 0;
                    event.doit = false;
                    break;
                }
                case 8: 
                case 16: {
                    if ((event.stateMask & (SWT.MODIFIER_MASK ^ 0x20000)) != 0) {
                        event.type = 0;
                        event.doit = false;
                        break;
                    }
                }
                default: {
                    if (!KeySequenceText.this.hasIncompleteStroke()) break;
                    KeyStroke[] keyStrokeArray = KeySequenceText.this.getKeySequence().getKeyStrokes();
                    int n = keyStrokeArray.length - 1;
                    if (n >= 1) {
                        KeyStroke[] keyStrokeArray2 = new KeyStroke[n];
                        System.arraycopy(keyStrokeArray, 0, keyStrokeArray2, 0, n);
                        KeySequenceText.this.setKeySequence(KeySequence.getInstance(keyStrokeArray2));
                        break;
                    }
                    KeySequenceText.this.setKeySequence(KeySequence.getInstance());
                }
            }
        }
    }

    private class TraversalFilterManager
    implements FocusListener {
        private TraversalFilter filter;
        private boolean filtering;

        private TraversalFilterManager() {
            this.filter = new TraversalFilter();
            this.filtering = false;
        }

        public void focusGained(FocusEvent focusEvent) {
            Display.getCurrent().addFilter(31, (Listener)this.filter);
            this.filtering = true;
        }

        public void focusLost(FocusEvent focusEvent) {
            Display.getCurrent().removeFilter(31, (Listener)this.filter);
            this.filtering = false;
        }

        public void dispose() {
            if (this.filtering) {
                Display.getCurrent().removeFilter(31, (Listener)this.filter);
            }
        }
    }

    private class UpdateSequenceListener
    implements ModifyListener {
        private UpdateSequenceListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            try {
                KeySequence keySequence = KeySequenceText.this.getKeySequence();
                String string = KeySequenceText.this.getText();
                KeySequence keySequence2 = KeySequence.getInstance(string);
                if (!keySequence.equals(keySequence2)) {
                    KeySequenceText.this.setKeySequence(keySequence2);
                }
            }
            catch (ParseException parseException) {
                KeySequenceText.this.setKeySequence(KeySequenceText.this.getKeySequence());
            }
        }
    }
}

