/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings.keys;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.jface.util.Util;

public final class KeySequence
extends TriggerSequence
implements Comparable {
    private static final KeySequence EMPTY_KEY_SEQUENCE = new KeySequence(new KeyStroke[0]);
    public static final String KEY_STROKE_DELIMITER = " ";
    public static final String KEY_STROKE_DELIMITERS = " \b\r\u007f\u001b\f\n\u0000\t\u000b";

    public static final KeySequence getInstance() {
        return EMPTY_KEY_SEQUENCE;
    }

    public static final KeySequence getInstance(KeySequence keySequence, KeyStroke keyStroke) {
        if (keySequence == null || keyStroke == null) {
            throw new NullPointerException();
        }
        KeyStroke[] keyStrokeArray = keySequence.getKeyStrokes();
        int n = keyStrokeArray.length;
        KeyStroke[] keyStrokeArray2 = new KeyStroke[n + 1];
        System.arraycopy(keyStrokeArray, 0, keyStrokeArray2, 0, n);
        keyStrokeArray2[n] = keyStroke;
        return new KeySequence(keyStrokeArray2);
    }

    public static final KeySequence getInstance(KeyStroke keyStroke) {
        return new KeySequence(new KeyStroke[]{keyStroke});
    }

    public static final KeySequence getInstance(KeyStroke[] keyStrokeArray) {
        return new KeySequence(keyStrokeArray);
    }

    public static final KeySequence getInstance(List list) {
        return new KeySequence(list.toArray(new KeyStroke[list.size()]));
    }

    public static final KeySequence getInstance(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException();
        }
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEY_STROKE_DELIMITERS);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(KeyStroke.getInstance(stringTokenizer.nextToken()));
            }
            KeyStroke[] keyStrokeArray = arrayList.toArray(new KeyStroke[arrayList.size()]);
            return new KeySequence(keyStrokeArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Could not construct key sequence with these key strokes: " + arrayList);
        }
        catch (NullPointerException nullPointerException) {
            throw new ParseException("Could not construct key sequence with these key strokes: " + arrayList);
        }
    }

    protected KeySequence(KeyStroke[] keyStrokeArray) {
        super(keyStrokeArray);
        int n = 0;
        while (n < this.triggers.length - 1) {
            KeyStroke keyStroke = (KeyStroke)this.triggers[n];
            if (!keyStroke.isComplete()) {
                throw new IllegalArgumentException();
            }
            ++n;
        }
    }

    public final int compareTo(Object object) {
        KeySequence keySequence = (KeySequence)object;
        return Util.compare(this.triggers, keySequence.triggers);
    }

    @Override
    public final String format() {
        return KeyFormatterFactory.getDefault().format(this);
    }

    public final KeyStroke[] getKeyStrokes() {
        int n = this.triggers.length;
        KeyStroke[] keyStrokeArray = new KeyStroke[n];
        System.arraycopy(this.triggers, 0, keyStrokeArray, 0, n);
        return keyStrokeArray;
    }

    @Override
    public final TriggerSequence[] getPrefixes() {
        int n = this.triggers.length;
        TriggerSequence[] triggerSequenceArray = new TriggerSequence[n];
        triggerSequenceArray[0] = KeySequence.getInstance();
        int n2 = 0;
        while (n2 < n - 1) {
            KeyStroke[] keyStrokeArray = new KeyStroke[n2 + 1];
            System.arraycopy(this.triggers, 0, keyStrokeArray, 0, n2 + 1);
            triggerSequenceArray[n2 + 1] = KeySequence.getInstance(keyStrokeArray);
            ++n2;
        }
        return triggerSequenceArray;
    }

    public final boolean isComplete() {
        int n = this.triggers.length;
        int n2 = 0;
        while (n2 < n) {
            if (!((KeyStroke)this.triggers[n2]).isComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final String toString() {
        return KeyFormatterFactory.getFormalKeyFormatter().format(this);
    }
}

