/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.common.NamedHandleObject;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.ISchemeListener;
import org.eclipse.jface.bindings.SchemeEvent;
import org.eclipse.jface.util.Util;

public final class Scheme
extends NamedHandleObject
implements Comparable {
    private Set listeners = null;
    private String parentId = null;

    Scheme(String string) {
        super(string);
    }

    public final void addSchemeListener(ISchemeListener iSchemeListener) {
        if (iSchemeListener == null) {
            throw new NullPointerException("Can't add a null scheme listener.");
        }
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(iSchemeListener);
    }

    public final int compareTo(Object object) {
        Scheme scheme = (Scheme)object;
        int n = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)scheme.id));
        if (n == 0 && (n = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)scheme.name))) == 0 && (n = Util.compare((Comparable)((Object)this.parentId), (Comparable)((Object)scheme.parentId))) == 0 && (n = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)scheme.description))) == 0) {
            n = Util.compare(this.defined, scheme.defined);
        }
        return n;
    }

    public final void define(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("The name of a scheme cannot be null");
        }
        boolean bl = !this.defined;
        this.defined = true;
        boolean bl2 = !Util.equals(this.name, string);
        this.name = string;
        boolean bl3 = !Util.equals(this.description, string2);
        this.description = string2;
        boolean bl4 = !Util.equals(this.parentId, string3);
        this.parentId = string3;
        this.fireSchemeChanged(new SchemeEvent(this, bl, bl2, bl3, bl4));
    }

    private final void fireSchemeChanged(SchemeEvent schemeEvent) {
        if (schemeEvent == null) {
            throw new NullPointerException("Cannot send a null event to listeners.");
        }
        if (this.listeners == null) {
            return;
        }
        for (ISchemeListener iSchemeListener : this.listeners) {
            iSchemeListener.schemeChanged(schemeEvent);
        }
    }

    public final String getParentId() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get the parent identifier from an undefined scheme. " + this.id);
        }
        return this.parentId;
    }

    public final void removeSchemeListener(ISchemeListener iSchemeListener) {
        if (iSchemeListener == null) {
            throw new NullPointerException("Cannot remove a null listener.");
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(iSchemeListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Scheme(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.parentId);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final void undefine() {
        this.string = null;
        boolean bl = this.defined;
        this.defined = false;
        boolean bl2 = this.name != null;
        this.name = null;
        boolean bl3 = this.description != null;
        this.description = null;
        boolean bl4 = this.parentId != null;
        this.parentId = null;
        this.fireSchemeChanged(new SchemeEvent(this, bl, bl2, bl3, bl4));
    }
}

