/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.util.Util;

final class CachedBindingSet {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = CachedBindingSet.class.getName().hashCode();
    private final Map activeContextTree;
    private Map bindingsByTrigger = null;
    private Map conflictsByTrigger = null;
    private transient int hashCode;
    private transient boolean hashCodeComputed = false;
    private final String[] locales;
    private final String[] platforms;
    private Map prefixTable = null;
    private final String[] schemeIds;
    private Map triggersByCommandId = null;

    CachedBindingSet(Map map, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (stringArray == null) {
            throw new NullPointerException("The locales cannot be null.");
        }
        if (stringArray.length == 0) {
            throw new NullPointerException("The locales cannot be empty.");
        }
        if (stringArray2 == null) {
            throw new NullPointerException("The platforms cannot be null.");
        }
        if (stringArray2.length == 0) {
            throw new NullPointerException("The platforms cannot be empty.");
        }
        this.activeContextTree = map;
        this.locales = stringArray;
        this.platforms = stringArray2;
        this.schemeIds = stringArray3;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof CachedBindingSet)) {
            return false;
        }
        CachedBindingSet cachedBindingSet = (CachedBindingSet)object;
        if (!Util.equals(this.activeContextTree, cachedBindingSet.activeContextTree)) {
            return false;
        }
        if (!Util.equals(this.locales, cachedBindingSet.locales)) {
            return false;
        }
        if (!Util.equals(this.platforms, cachedBindingSet.platforms)) {
            return false;
        }
        return Util.equals(this.schemeIds, cachedBindingSet.schemeIds);
    }

    final Map getBindingsByTrigger() {
        return this.bindingsByTrigger;
    }

    final Map getConflictsByTrigger() {
        return this.conflictsByTrigger;
    }

    final Map getPrefixTable() {
        return this.prefixTable;
    }

    final Map getTriggersByCommandId() {
        return this.triggersByCommandId;
    }

    public final int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.activeContextTree);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.locales);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.platforms);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.schemeIds);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    final void setBindingsByTrigger(Map map) {
        if (map == null) {
            throw new NullPointerException("Cannot set a null binding resolution");
        }
        this.bindingsByTrigger = map;
    }

    final void setConflictsByTrigger(Map map) {
        if (map == null) {
            throw new NullPointerException("Cannot set a null binding conflicts");
        }
        this.conflictsByTrigger = map;
    }

    final void setPrefixTable(Map map) {
        if (map == null) {
            this.prefixTable = Collections.EMPTY_MAP;
            if (BindingManager.DEBUG) {
                Tracing.printTrace((String)"BINDINGS", (String)"Cannot set a null prefix table, set to EMPTY_MAP");
            }
            return;
        }
        this.prefixTable = map;
    }

    final void setTriggersByCommandId(Map map) {
        if (map == null) {
            throw new NullPointerException("Cannot set a null binding resolution");
        }
        this.triggersByCommandId = map;
    }
}

