/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.HandleObjectManager;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.CachedBindingSet;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.ISchemeListener;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.SchemeEvent;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.Util;

public final class BindingManager
extends HandleObjectManager
implements IContextManagerListener,
ISchemeListener {
    public static boolean DEBUG = false;
    private static final TriggerSequence[] EMPTY_TRIGGER_SEQUENCE = new TriggerSequence[0];
    private static final String LOCALE_SEPARATOR = "_";
    private Map currentConflicts = null;
    private Map activeBindings = null;
    private Map activeBindingsByParameterizedCommand = null;
    private Set triggerConflicts = new HashSet();
    private Scheme activeScheme = null;
    private String[] activeSchemeIds = null;
    private int bindingCount = 0;
    private Set bindingErrors = new HashSet();
    private Binding[] bindings = null;
    private Map cachedBindings = new HashMap();
    private final CommandManager commandManager;
    private final ContextManager contextManager;
    private String locale = Locale.getDefault().toString();
    private String[] locales = BindingManager.expand(this.locale, "_");
    private String platform = Util.getWS();
    private String[] platforms = BindingManager.expand(this.platform, "");
    private Map prefixTable = null;

    private static final void addReverseLookup(Map map, Object object, Object object2) {
        if (map == null) {
            return;
        }
        Object v = map.get(object);
        if (v != null) {
            Collection collection = (Collection)v;
            collection.add(object2);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object2);
            map.put(object, arrayList);
        }
    }

    private static final String[] expand(String string, String string2) {
        if (string == null || string2 == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        if ((string = string.trim()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreElements()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(((String)stringTokenizer.nextElement()).trim());
                arrayList.add(stringBuffer.toString());
            }
        }
        Collections.reverse(arrayList);
        arrayList.add("");
        arrayList.add(null);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public BindingManager(ContextManager contextManager, CommandManager commandManager) {
        if (contextManager == null) {
            throw new NullPointerException("A binding manager requires a context manager");
        }
        if (commandManager == null) {
            throw new NullPointerException("A binding manager requires a command manager");
        }
        this.contextManager = contextManager;
        contextManager.addContextManagerListener((IContextManagerListener)this);
        this.commandManager = commandManager;
    }

    public final void addBinding(Binding binding) {
        if (binding == null) {
            throw new NullPointerException("Cannot add a null binding");
        }
        if (this.bindings == null) {
            this.bindings = new Binding[1];
        } else if (this.bindingCount >= this.bindings.length) {
            Binding[] bindingArray = this.bindings;
            this.bindings = new Binding[bindingArray.length * 2];
            System.arraycopy(bindingArray, 0, this.bindings, 0, bindingArray.length);
        }
        this.bindings[this.bindingCount++] = binding;
        this.clearCache();
    }

    public final void addBindingManagerListener(IBindingManagerListener iBindingManagerListener) {
        this.addListenerObject(iBindingManagerListener);
    }

    private final Map buildPrefixTable(Map map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            TriggerSequence[] triggerSequenceArray;
            int n;
            TriggerSequence triggerSequence = (TriggerSequence)entry.getKey();
            if (!hashMap.containsKey(triggerSequence)) {
                hashMap.put(triggerSequence, null);
            }
            if ((n = (triggerSequenceArray = triggerSequence.getPrefixes()).length) == 0) continue;
            Binding binding = (Binding)entry.getValue();
            int n2 = 0;
            while (n2 < n) {
                TriggerSequence triggerSequence2 = triggerSequenceArray[n2];
                Object v = hashMap.get(triggerSequence2);
                if (hashMap.containsKey(triggerSequence2) && v instanceof Map) {
                    ((Map)v).put(triggerSequence, binding);
                } else {
                    HashMap<TriggerSequence, Binding> hashMap2 = new HashMap<TriggerSequence, Binding>();
                    hashMap.put(triggerSequence2, hashMap2);
                    hashMap2.put(triggerSequence, binding);
                }
                ++n2;
            }
        }
        return hashMap;
    }

    private final void clearCache() {
        if (DEBUG) {
            Tracing.printTrace((String)"BINDINGS", (String)"Clearing cache");
        }
        this.cachedBindings.clear();
        this.clearSolution();
    }

    private final void clearSolution() {
        this.setActiveBindings(null, null, null, null);
    }

    private final int compareSchemes(String string, String string2) {
        if (!string2.equals(string)) {
            int n = 0;
            while (n < this.activeSchemeIds.length) {
                String string3 = this.activeSchemeIds[n];
                if (string2.equals(string3)) {
                    return 1;
                }
                if (string.equals(string3)) {
                    return -1;
                }
                ++n;
            }
        }
        return 0;
    }

    private final void computeBindings(Map map, Map map2, Map map3, Map map4) {
        Object object;
        Object object2;
        String string;
        Object object3;
        Binding[] bindingArray = this.removeDeletions(this.bindings);
        HashMap<TriggerSequence, Object> hashMap = new HashMap<TriggerSequence, Object>();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            object3 = binding.getContextId();
            if ((map == null || map.containsKey(object3)) && this.localeMatches(binding) && this.platformMatches(binding)) {
                string = binding.getSchemeId();
                boolean bl = false;
                if (this.activeSchemeIds != null) {
                    int n3 = 0;
                    while (n3 < this.activeSchemeIds.length) {
                        if (Util.equals(string, this.activeSchemeIds[n3])) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (bl) {
                    TriggerSequence triggerSequence = binding.getTriggerSequence();
                    object2 = hashMap.get(triggerSequence);
                    if (object2 instanceof Binding) {
                        hashMap.remove(triggerSequence);
                        object = new ArrayList<Object>();
                        object.add(object2);
                        object.add(binding);
                        hashMap.put(triggerSequence, object);
                    } else if (object2 instanceof Collection) {
                        object = (ArrayList<Object>)object2;
                        object.add(binding);
                    } else {
                        hashMap.put(triggerSequence, binding);
                    }
                }
            }
            ++n2;
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.jface", 0, "Keybinding conflicts occurred.  They may interfere with normal accelerator operation.", null);
        for (Map.Entry entry : hashMap.entrySet()) {
            object3 = (TriggerSequence)entry.getKey();
            string = entry.getValue();
            if (map == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (string instanceof Binding) {
                    arrayList.add(string);
                    map2.put(object3, arrayList);
                    BindingManager.addReverseLookup(map3, ((Binding)((Object)string)).getParameterizedCommand(), object3);
                    continue;
                }
                if (!(string instanceof Collection)) continue;
                arrayList.addAll((Collection)((Object)string));
                map2.put(object3, arrayList);
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    BindingManager.addReverseLookup(map3, ((Binding)object2.next()).getParameterizedCommand(), object3);
                }
                continue;
            }
            if (string instanceof Binding) {
                Binding binding = (Binding)((Object)string);
                map2.put(object3, binding);
                BindingManager.addReverseLookup(map3, binding.getParameterizedCommand(), object3);
                continue;
            }
            if (!(string instanceof Collection)) continue;
            Binding binding = this.resolveConflicts((Collection)((Object)string), map);
            if (binding == null) {
                map4.put(object3, string);
                if (this.triggerConflicts.add(object3)) {
                    object2 = new StringWriter();
                    object = new BufferedWriter((Writer)object2);
                    try {
                        ((Writer)object).write("A conflict occurred for ");
                        ((Writer)object).write(object3.toString());
                        ((BufferedWriter)object).write(58);
                        Iterator iterator = ((Collection)((Object)string)).iterator();
                        while (iterator.hasNext()) {
                            ((BufferedWriter)object).newLine();
                            ((Writer)object).write(iterator.next().toString());
                        }
                        ((BufferedWriter)object).flush();
                    }
                    catch (IOException iOException) {}
                    multiStatus.add((IStatus)new Status(2, "org.eclipse.jface", ((StringWriter)object2).toString()));
                }
                if (!DEBUG) continue;
                Tracing.printTrace((String)"BINDINGS", (String)("A conflict occurred for " + object3));
                Tracing.printTrace((String)"BINDINGS", (String)("    " + string));
                continue;
            }
            map2.put(object3, binding);
            BindingManager.addReverseLookup(map3, binding.getParameterizedCommand(), object3);
        }
        if (multiStatus.getSeverity() != 0) {
            Policy.getLog().log((IStatus)multiStatus);
        }
    }

    public final void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
        if (contextManagerEvent.isActiveContextsChanged()) {
            this.recomputeBindings();
        }
    }

    private final int countStrokes(Trigger[] triggerArray) {
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < triggerArray.length) {
            Trigger trigger = triggerArray[n2];
            if (trigger instanceof KeyStroke) {
                IKeyLookup iKeyLookup;
                KeyStroke keyStroke = (KeyStroke)trigger;
                int n3 = keyStroke.getModifierKeys();
                if ((n3 & (iKeyLookup = KeyLookupFactory.getDefault()).getAlt()) != 0) {
                    n += 8;
                }
                if ((n3 & iKeyLookup.getCtrl()) != 0) {
                    n += 2;
                }
                if ((n3 & iKeyLookup.getShift()) != 0) {
                    n += 4;
                }
                if ((n3 & iKeyLookup.getCommand()) != 0) {
                    n += 2;
                }
            } else {
                n += 99;
            }
            ++n2;
        }
        return n;
    }

    private final Map createContextTreeFor(Set set) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block2: for (String string : set) {
            while (string != null) {
                if (hashMap.containsKey(string)) continue block2;
                Context context = this.contextManager.getContext(string);
                try {
                    String string2 = context.getParentId();
                    hashMap.put(string, string2);
                    string = string2;
                }
                catch (NotDefinedException notDefinedException) {
                    continue block2;
                }
            }
        }
        return hashMap;
    }

    private final Map createFilteredContextTreeFor(Set set) {
        boolean bl = false;
        boolean bl2 = false;
        for (String string : set) {
            if ("org.eclipse.ui.contexts.dialog".equals(string)) {
                bl = true;
                continue;
            }
            if (!"org.eclipse.ui.contexts.window".equals(string)) continue;
            bl2 = true;
        }
        Iterator iterator = set.iterator();
        block3: while (iterator.hasNext()) {
            String string;
            string = (String)iterator.next();
            Context context = this.contextManager.getContext(string);
            try {
                String string2 = context.getParentId();
                while (string2 != null) {
                    if ("org.eclipse.ui.contexts.dialog".equals(string2)) {
                        if (bl) continue block3;
                        iterator.remove();
                        continue block3;
                    }
                    if ("org.eclipse.ui.contexts.window".equals(string2)) {
                        if (bl2) continue block3;
                        iterator.remove();
                        continue block3;
                    }
                    if ("org.eclipse.ui.contexts.dialogAndWindow".equals(string2)) {
                        if (bl2 || bl) continue block3;
                        iterator.remove();
                        continue block3;
                    }
                    context = this.contextManager.getContext(string2);
                    string2 = context.getParentId();
                }
            }
            catch (NotDefinedException notDefinedException) {
                iterator.remove();
                if (context != null && this.bindingErrors.contains(context.getId())) continue;
                if (context != null) {
                    this.bindingErrors.add(context.getId());
                }
                Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 0, "Undefined context while filtering dialog/window contexts", (Throwable)notDefinedException));
            }
        }
        return this.createContextTreeFor(set);
    }

    private final void fireBindingManagerChanged(BindingManagerEvent bindingManagerEvent) {
        if (bindingManagerEvent == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IBindingManagerListener iBindingManagerListener = (IBindingManagerListener)objectArray[n];
            iBindingManagerListener.bindingManagerChanged(bindingManagerEvent);
            ++n;
        }
    }

    private final Map getActiveBindings() {
        if (this.activeBindings == null) {
            this.recomputeBindings();
        }
        return this.activeBindings;
    }

    private final Map getActiveBindingsByParameterizedCommand() {
        if (this.activeBindingsByParameterizedCommand == null) {
            this.recomputeBindings();
        }
        return this.activeBindingsByParameterizedCommand;
    }

    public final Map getActiveBindingsDisregardingContext() {
        HashMap hashMap;
        if (this.bindings == null) {
            return Collections.EMPTY_MAP;
        }
        CachedBindingSet cachedBindingSet = new CachedBindingSet(null, this.locales, this.platforms, this.activeSchemeIds);
        CachedBindingSet cachedBindingSet2 = (CachedBindingSet)this.cachedBindings.get(cachedBindingSet);
        if (cachedBindingSet2 == null) {
            cachedBindingSet2 = cachedBindingSet;
            this.cachedBindings.put(cachedBindingSet2, cachedBindingSet2);
        }
        if ((hashMap = cachedBindingSet2.getBindingsByTrigger()) != null) {
            if (DEBUG) {
                Tracing.printTrace((String)"BINDINGS", (String)"Cache hit");
            }
            return Collections.unmodifiableMap(hashMap);
        }
        if (DEBUG) {
            Tracing.printTrace((String)"BINDINGS", (String)"Cache miss");
        }
        hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        this.computeBindings(null, hashMap, hashMap2, hashMap3);
        cachedBindingSet2.setBindingsByTrigger(hashMap);
        cachedBindingSet2.setTriggersByCommandId(hashMap2);
        cachedBindingSet2.setConflictsByTrigger(hashMap3);
        return Collections.unmodifiableMap(hashMap);
    }

    private final Map getActiveBindingsDisregardingContextByParameterizedCommand() {
        HashMap hashMap;
        if (this.bindings == null) {
            return Collections.EMPTY_MAP;
        }
        CachedBindingSet cachedBindingSet = new CachedBindingSet(null, this.locales, this.platforms, this.activeSchemeIds);
        CachedBindingSet cachedBindingSet2 = (CachedBindingSet)this.cachedBindings.get(cachedBindingSet);
        if (cachedBindingSet2 == null) {
            cachedBindingSet2 = cachedBindingSet;
            this.cachedBindings.put(cachedBindingSet2, cachedBindingSet2);
        }
        if ((hashMap = cachedBindingSet2.getTriggersByCommandId()) != null) {
            if (DEBUG) {
                Tracing.printTrace((String)"BINDINGS", (String)"Cache hit");
            }
            return Collections.unmodifiableMap(hashMap);
        }
        if (DEBUG) {
            Tracing.printTrace((String)"BINDINGS", (String)"Cache miss");
        }
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        hashMap = new HashMap();
        this.computeBindings(null, hashMap2, hashMap, hashMap3);
        cachedBindingSet2.setBindingsByTrigger(hashMap2);
        cachedBindingSet2.setTriggersByCommandId(hashMap);
        cachedBindingSet2.setConflictsByTrigger(hashMap3);
        return Collections.unmodifiableMap(hashMap);
    }

    public final Collection getActiveBindingsDisregardingContextFlat() {
        Collection collection = this.getActiveBindingsDisregardingContext().values();
        ArrayList arrayList = new ArrayList();
        for (Collection collection2 : collection) {
            if (collection2 == null || collection2.isEmpty()) continue;
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    public final TriggerSequence[] getActiveBindingsDisregardingContextFor(ParameterizedCommand parameterizedCommand) {
        Object v = this.getActiveBindingsDisregardingContextByParameterizedCommand().get(parameterizedCommand);
        if (v instanceof Collection) {
            Collection collection = (Collection)v;
            return collection.toArray(new TriggerSequence[collection.size()]);
        }
        return EMPTY_TRIGGER_SEQUENCE;
    }

    public final TriggerSequence[] getActiveBindingsFor(ParameterizedCommand parameterizedCommand) {
        Object v = this.getActiveBindingsByParameterizedCommand().get(parameterizedCommand);
        if (v instanceof Collection) {
            Collection collection = (Collection)v;
            return collection.toArray(new TriggerSequence[collection.size()]);
        }
        return EMPTY_TRIGGER_SEQUENCE;
    }

    public final TriggerSequence[] getActiveBindingsFor(String string) {
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(this.commandManager.getCommand(string), null);
        return this.getActiveBindingsFor(parameterizedCommand);
    }

    private final Binding[] getActiveBindingsFor1(ParameterizedCommand parameterizedCommand) {
        TriggerSequence[] triggerSequenceArray = this.getActiveBindingsFor(parameterizedCommand);
        if (triggerSequenceArray.length == 0) {
            return null;
        }
        Map map = this.getActiveBindings();
        if (map != null) {
            Binding[] bindingArray = new Binding[triggerSequenceArray.length];
            int n = 0;
            while (n < triggerSequenceArray.length) {
                Binding binding;
                TriggerSequence triggerSequence = triggerSequenceArray[n];
                Object v = map.get(triggerSequence);
                bindingArray[n] = binding = (Binding)v;
                ++n;
            }
            return bindingArray;
        }
        return null;
    }

    public final Scheme getActiveScheme() {
        return this.activeScheme;
    }

    public final TriggerSequence getBestActiveBindingFor(String string) {
        return this.getBestActiveBindingFor(new ParameterizedCommand(this.commandManager.getCommand(string), null));
    }

    public final TriggerSequence getBestActiveBindingFor(ParameterizedCommand parameterizedCommand) {
        Binding[] bindingArray = this.getActiveBindingsFor1(parameterizedCommand);
        if (bindingArray == null || bindingArray.length == 0) {
            return null;
        }
        Binding binding = bindingArray[0];
        int n = 1;
        while (n < bindingArray.length) {
            String string;
            Binding binding2 = bindingArray[n];
            String string2 = binding.getSchemeId();
            int n2 = this.compareSchemes(string2, string = binding2.getSchemeId());
            if (n2 > 0) {
                binding = binding2;
            }
            if (n2 == 0) {
                String string3 = binding.getLocale();
                String string4 = binding2.getLocale();
                if (string3 == null && string4 != null) {
                    binding = binding2;
                }
                if (Util.equals(string3, string4)) {
                    String string5 = binding.getPlatform();
                    String string6 = binding2.getPlatform();
                    if (string5 == null && string6 != null) {
                        binding = binding2;
                    }
                    if (Util.equals(string5, string6)) {
                        Trigger[] triggerArray;
                        TriggerSequence triggerSequence = binding.getTriggerSequence();
                        TriggerSequence triggerSequence2 = binding2.getTriggerSequence();
                        Trigger[] triggerArray2 = triggerSequence.getTriggers();
                        n2 = triggerArray2.length - (triggerArray = triggerSequence2.getTriggers()).length;
                        if (n2 > 0) {
                            binding = binding2;
                        }
                        if (n2 == 0) {
                            n2 = this.countStrokes(triggerArray2) - this.countStrokes(triggerArray);
                            if (n2 > 0) {
                                binding = binding2;
                            }
                            if (n2 == 0 && (n2 = triggerSequence.format().length() - triggerSequence2.format().length()) > 0) {
                                binding = binding2;
                            }
                        }
                    }
                }
            }
            ++n;
        }
        return binding.getTriggerSequence();
    }

    public final String getBestActiveBindingFormattedFor(String string) {
        TriggerSequence triggerSequence = this.getBestActiveBindingFor(string);
        if (triggerSequence != null) {
            return triggerSequence.format();
        }
        return null;
    }

    public final Binding[] getBindings() {
        if (this.bindings == null) {
            return null;
        }
        Binding[] bindingArray = new Binding[this.bindingCount];
        System.arraycopy(this.bindings, 0, bindingArray, 0, this.bindingCount);
        return bindingArray;
    }

    public final Scheme[] getDefinedSchemes() {
        return this.definedHandleObjects.toArray(new Scheme[this.definedHandleObjects.size()]);
    }

    public final String getLocale() {
        return this.locale;
    }

    public final Map getPartialMatches(TriggerSequence triggerSequence) {
        Map map = (Map)this.getPrefixTable().get(triggerSequence);
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return map;
    }

    public final Binding getPerfectMatch(TriggerSequence triggerSequence) {
        return (Binding)this.getActiveBindings().get(triggerSequence);
    }

    public final String getPlatform() {
        return this.platform;
    }

    private final Map getPrefixTable() {
        if (this.prefixTable == null) {
            this.recomputeBindings();
        }
        return this.prefixTable;
    }

    public final Scheme getScheme(String string) {
        this.checkId(string);
        Scheme scheme = (Scheme)this.handleObjectsById.get(string);
        if (scheme == null) {
            scheme = new Scheme(string);
            this.handleObjectsById.put(string, scheme);
            scheme.addSchemeListener(this);
        }
        return scheme;
    }

    private final String[] getSchemeIds(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string != null) {
            arrayList.add(string);
            try {
                string = this.getScheme(string).getParentId();
            }
            catch (NotDefinedException notDefinedException) {
                Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 0, "Failed ascending scheme parents", (Throwable)notDefinedException));
                return new String[0];
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final boolean isPartialMatch(TriggerSequence triggerSequence) {
        return this.getPrefixTable().get(triggerSequence) != null;
    }

    public final boolean isPerfectMatch(TriggerSequence triggerSequence) {
        return this.getActiveBindings().containsKey(triggerSequence);
    }

    private final boolean localeMatches(Binding binding) {
        boolean bl = false;
        String string = binding.getLocale();
        if (string == null) {
            return true;
        }
        int n = 0;
        while (n < this.locales.length) {
            if (Util.equals(this.locales[n], string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private final boolean platformMatches(Binding binding) {
        boolean bl = false;
        String string = binding.getPlatform();
        if (string == null) {
            return true;
        }
        int n = 0;
        while (n < this.platforms.length) {
            if (Util.equals(this.platforms[n], string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private final void recomputeBindings() {
        HashMap hashMap;
        if (this.bindings == null) {
            this.setActiveBindings(Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
            return;
        }
        HashSet hashSet = new HashSet(this.contextManager.getActiveContextIds());
        Map map = this.createFilteredContextTreeFor(hashSet);
        CachedBindingSet cachedBindingSet = new CachedBindingSet(map, this.locales, this.platforms, this.activeSchemeIds);
        CachedBindingSet cachedBindingSet2 = (CachedBindingSet)this.cachedBindings.get(cachedBindingSet);
        if (cachedBindingSet2 == null) {
            cachedBindingSet2 = cachedBindingSet;
            this.cachedBindings.put(cachedBindingSet2, cachedBindingSet2);
        }
        if ((hashMap = cachedBindingSet2.getBindingsByTrigger()) != null) {
            if (DEBUG) {
                Tracing.printTrace((String)"BINDINGS", (String)"Cache hit");
            }
            this.setActiveBindings(hashMap, cachedBindingSet2.getTriggersByCommandId(), cachedBindingSet2.getPrefixTable(), cachedBindingSet2.getConflictsByTrigger());
            return;
        }
        if (DEBUG) {
            Tracing.printTrace((String)"BINDINGS", (String)"Cache miss");
        }
        hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        this.computeBindings(map, hashMap, hashMap2, hashMap3);
        cachedBindingSet2.setBindingsByTrigger(hashMap);
        cachedBindingSet2.setTriggersByCommandId(hashMap2);
        cachedBindingSet2.setConflictsByTrigger(hashMap3);
        this.setActiveBindings(hashMap, hashMap2, this.buildPrefixTable(hashMap), hashMap3);
        cachedBindingSet2.setPrefixTable(this.prefixTable);
    }

    public final void removeBinding(Binding binding) {
        if (this.bindings == null || this.bindings.length < 1) {
            return;
        }
        Binding[] bindingArray = new Binding[this.bindings.length];
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < this.bindingCount) {
            Binding binding2 = this.bindings[n2];
            if (binding2 == binding) {
                bl = true;
            } else {
                bindingArray[n++] = binding2;
            }
            ++n2;
        }
        if (bl) {
            this.bindings = bindingArray;
            this.bindingCount = n;
            this.clearCache();
        }
    }

    public final void removeBindingManagerListener(IBindingManagerListener iBindingManagerListener) {
        this.removeListenerObject(iBindingManagerListener);
    }

    public final void removeBindings(TriggerSequence triggerSequence, String string, String string2, String string3, String string4, String string5, int n) {
        if (this.bindings == null || this.bindingCount < 1) {
            return;
        }
        Binding[] bindingArray = new Binding[this.bindings.length];
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.bindingCount) {
            Binding binding = this.bindings[n3];
            boolean bl2 = true;
            bl2 &= Util.equals(triggerSequence, binding.getTriggerSequence());
            bl2 &= Util.equals(string, binding.getSchemeId());
            bl2 &= Util.equals(string2, binding.getContextId());
            bl2 &= Util.equals(string3, binding.getLocale());
            bl2 &= Util.equals(string4, binding.getPlatform());
            if (bl2 &= n == binding.getType()) {
                bl = true;
            } else {
                bindingArray[n2++] = binding;
            }
            ++n3;
        }
        if (bl) {
            this.bindings = bindingArray;
            this.bindingCount = n2;
            this.clearCache();
        }
    }

    private final Binding[] removeDeletions(Binding[] bindingArray) {
        Object object;
        TriggerSequence triggerSequence;
        Binding binding;
        HashMap<TriggerSequence, Object> hashMap = new HashMap<TriggerSequence, Object>();
        Binding[] bindingArray2 = new Binding[this.bindingCount];
        System.arraycopy(bindingArray, 0, bindingArray2, 0, this.bindingCount);
        int n = 0;
        int n2 = 0;
        while (n2 < this.bindingCount) {
            binding = bindingArray2[n2];
            if (binding.getParameterizedCommand() == null && this.localeMatches(binding) && this.platformMatches(binding)) {
                Object object2;
                triggerSequence = binding.getTriggerSequence();
                object = hashMap.get(triggerSequence);
                if (object instanceof Binding) {
                    object2 = new ArrayList<Object>(2);
                    object2.add(object);
                    object2.add(binding);
                    hashMap.put(triggerSequence, object2);
                } else if (object instanceof Collection) {
                    object2 = (Collection)object;
                    object2.add(binding);
                } else {
                    hashMap.put(triggerSequence, binding);
                }
                bindingArray2[n2] = null;
                ++n;
            }
            ++n2;
        }
        if (DEBUG) {
            Tracing.printTrace((String)"BINDINGS", (String)("There are " + hashMap.size() + " deletion markers"));
        }
        n2 = 0;
        while (n2 < this.bindingCount) {
            block12: {
                block13: {
                    binding = bindingArray2[n2];
                    if (binding == null) break block12;
                    triggerSequence = hashMap.get(binding.getTriggerSequence());
                    if (!(triggerSequence instanceof Binding)) break block13;
                    if (!((Binding)((Object)triggerSequence)).deletes(binding)) break block12;
                    bindingArray2[n2] = null;
                    ++n;
                    break block12;
                }
                if (triggerSequence instanceof Collection) {
                    object = (Collection)((Object)triggerSequence);
                    for (Object e : object) {
                        if (!(e instanceof Binding) || !((Binding)e).deletes(binding)) continue;
                        bindingArray2[n2] = null;
                        ++n;
                        break;
                    }
                }
            }
            ++n2;
        }
        Binding[] bindingArray3 = new Binding[this.bindingCount - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.bindingCount) {
            object = bindingArray2[n4];
            if (object != null) {
                bindingArray3[n3++] = object;
            }
            ++n4;
        }
        return bindingArray3;
    }

    private final Binding resolveConflicts(Collection collection, Map map) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        Binding binding = (Binding)iterator.next();
        while (iterator.hasNext()) {
            String string;
            Binding binding2 = (Binding)iterator.next();
            String string2 = binding2.getSchemeId();
            String string3 = binding.getSchemeId();
            int n = this.compareSchemes(string3, string2);
            if (n > 0) {
                binding = binding2;
                bl = false;
            }
            if (n != 0) continue;
            String string4 = binding2.getContextId();
            if (!string4.equals(string = binding.getContextId())) {
                boolean bl2 = false;
                String string5 = string4;
                while (string5 != null) {
                    if (string5.equals(string)) {
                        binding = binding2;
                        bl = false;
                        bl2 = true;
                        break;
                    }
                    string5 = (String)map.get(string5);
                }
                string5 = string;
                while (string5 != null) {
                    if (string5.equals(string4)) {
                        bl2 = true;
                        break;
                    }
                    string5 = (String)map.get(string5);
                }
                if (bl2) continue;
            }
            if (binding2.getType() > binding.getType()) {
                binding = binding2;
                bl = false;
                continue;
            }
            if (binding.getType() > binding2.getType()) continue;
            bl = true;
        }
        if (bl) {
            return null;
        }
        return binding;
    }

    @Override
    public final void schemeChanged(SchemeEvent schemeEvent) {
        if (schemeEvent.isDefinedChanged()) {
            Scheme scheme = schemeEvent.getScheme();
            boolean bl = scheme.isDefined();
            boolean bl2 = false;
            if (bl) {
                this.definedHandleObjects.add(scheme);
            } else {
                this.definedHandleObjects.remove(scheme);
                if (this.activeScheme == scheme) {
                    this.activeScheme = null;
                    this.activeSchemeIds = null;
                    bl2 = true;
                    this.clearSolution();
                }
            }
            if (this.isListenerAttached()) {
                this.fireBindingManagerChanged(new BindingManagerEvent(this, false, null, bl2, scheme, bl, false, false));
            }
        }
    }

    private final void setActiveBindings(Map map, Map map2, Map map3, Map map4) {
        this.activeBindings = map;
        Map map5 = this.activeBindingsByParameterizedCommand;
        this.activeBindingsByParameterizedCommand = map2;
        this.prefixTable = map3;
        this.currentConflicts = map4;
        this.fireBindingManagerChanged(new BindingManagerEvent(this, true, map5, false, null, false, false, false));
    }

    public Map getCurrentConflicts() {
        if (this.currentConflicts == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.currentConflicts);
    }

    public Collection getConflictsFor(TriggerSequence triggerSequence) {
        return (Collection)this.getCurrentConflicts().get(triggerSequence);
    }

    public final void setActiveScheme(Scheme scheme) throws NotDefinedException {
        if (scheme == null) {
            throw new NullPointerException("Cannot activate a null scheme");
        }
        if (scheme == null || !scheme.isDefined()) {
            throw new NotDefinedException("Cannot activate an undefined scheme. " + scheme.getId());
        }
        if (Util.equals(this.activeScheme, scheme)) {
            return;
        }
        this.activeScheme = scheme;
        this.activeSchemeIds = this.getSchemeIds(this.activeScheme.getId());
        this.clearSolution();
        this.fireBindingManagerChanged(new BindingManagerEvent(this, false, null, true, null, false, false, false));
    }

    public final void setBindings(Binding[] bindingArray) {
        if (bindingArray != null) {
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            int n = 0;
            while (n < bindingArray.length) {
                Binding binding = bindingArray[n];
                String string = binding.getPlatform();
                if (string == null) {
                    arrayList.add(binding);
                } else if (string.equals(this.platform)) {
                    arrayList.add(binding);
                }
                ++n;
            }
            bindingArray = arrayList.toArray(new Binding[arrayList.size()]);
        }
        if (Arrays.equals(this.bindings, bindingArray)) {
            return;
        }
        if (bindingArray == null || bindingArray.length == 0) {
            this.bindings = null;
            this.bindingCount = 0;
        } else {
            this.bindings = bindingArray;
            this.bindingCount = bindingArray.length;
        }
        this.clearCache();
    }

    public final void setLocale(String string) {
        if (string == null) {
            throw new NullPointerException("The locale cannot be null");
        }
        if (!Util.equals(this.locale, string)) {
            this.locale = string;
            this.locales = BindingManager.expand(string, LOCALE_SEPARATOR);
            this.clearSolution();
            this.fireBindingManagerChanged(new BindingManagerEvent(this, false, null, false, null, false, true, false));
        }
    }

    public final void setPlatform(String string) {
        if (string == null) {
            throw new NullPointerException("The platform cannot be null");
        }
        if (!Util.equals(this.platform, string)) {
            this.platform = string;
            this.platforms = BindingManager.expand(string, "");
            this.clearSolution();
            this.fireBindingManagerChanged(new BindingManagerEvent(this, false, null, false, null, false, false, true));
        }
    }
}

