/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.util.Util;

public abstract class Binding {
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = Binding.class.getName().hashCode();
    public static final int SYSTEM = 0;
    public static final int USER = 1;
    private final ParameterizedCommand command;
    private final String contextId;
    private transient int hashCode = -1;
    private final String locale;
    private final String platform;
    private final String schemeId;
    protected transient String string = null;
    private final int type;

    protected Binding(ParameterizedCommand parameterizedCommand, String string, String string2, String string3, String string4, String string5, int n) {
        if (string == null) {
            throw new NullPointerException("The scheme cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("The context cannot be null");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The type must be SYSTEM or USER");
        }
        this.command = parameterizedCommand;
        this.schemeId = string.intern();
        this.contextId = string2.intern();
        this.locale = string3 == null ? null : string3.intern();
        this.platform = string4 == null ? null : string4.intern();
        this.type = n;
    }

    final boolean deletes(Binding binding) {
        boolean bl = true;
        bl &= Util.equals(this.getContextId(), binding.getContextId());
        bl &= Util.equals(this.getTriggerSequence(), binding.getTriggerSequence());
        if (this.getLocale() != null) {
            bl &= !Util.equals(this.getLocale(), binding.getLocale());
        }
        if (this.getPlatform() != null) {
            bl &= !Util.equals(this.getPlatform(), binding.getPlatform());
        }
        bl &= binding.getType() == 0;
        return bl &= Util.equals(this.getParameterizedCommand(), null);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)object;
        if (!Util.equals(this.getParameterizedCommand(), binding.getParameterizedCommand())) {
            return false;
        }
        if (!Util.equals(this.getContextId(), binding.getContextId())) {
            return false;
        }
        if (!Util.equals(this.getTriggerSequence(), binding.getTriggerSequence())) {
            return false;
        }
        if (!Util.equals(this.getLocale(), binding.getLocale())) {
            return false;
        }
        if (!Util.equals(this.getPlatform(), binding.getPlatform())) {
            return false;
        }
        if (!Util.equals(this.getSchemeId(), binding.getSchemeId())) {
            return false;
        }
        return this.getType() == binding.getType();
    }

    public final ParameterizedCommand getParameterizedCommand() {
        return this.command;
    }

    public final String getContextId() {
        return this.contextId;
    }

    public final String getLocale() {
        return this.locale;
    }

    public final String getPlatform() {
        return this.platform;
    }

    public final String getSchemeId() {
        return this.schemeId;
    }

    public abstract TriggerSequence getTriggerSequence();

    public final int getType() {
        return this.type;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getParameterizedCommand());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getContextId());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getTriggerSequence());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getLocale());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getPlatform());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getSchemeId());
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.getType());
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            try {
                bufferedWriter.write("Binding(");
                bufferedWriter.write(this.getTriggerSequence().toString());
                bufferedWriter.write(44);
                bufferedWriter.newLine();
                bufferedWriter.write(9);
                bufferedWriter.write(this.command == null ? "" : this.command.toString());
                bufferedWriter.write(44);
                bufferedWriter.newLine();
                bufferedWriter.write(9);
                bufferedWriter.write(this.schemeId);
                bufferedWriter.write(44);
                bufferedWriter.newLine();
                bufferedWriter.write(9);
                bufferedWriter.write(this.contextId);
                bufferedWriter.write(44);
                bufferedWriter.write(this.locale == null ? "" : this.locale);
                bufferedWriter.write(44);
                bufferedWriter.write(this.platform == null ? "" : this.platform);
                bufferedWriter.write(44);
                bufferedWriter.write(this.type == 0 ? "system" : "user");
                bufferedWriter.write(41);
                bufferedWriter.flush();
            }
            catch (IOException iOException) {}
            this.string = stringWriter.toString();
        }
        return this.string;
    }
}

