/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarManager
extends ContributionManager
implements IToolBarManager {
    private int itemStyle = 0;
    private ToolBar toolBar = null;
    private MenuManager contextMenuManager = null;

    public ToolBarManager() {
    }

    public ToolBarManager(int n) {
        this.itemStyle = n;
    }

    public ToolBarManager(ToolBar toolBar) {
        this();
        this.toolBar = toolBar;
    }

    public ToolBar createControl(Composite composite) {
        if (!this.toolBarExist() && composite != null) {
            this.toolBar = new ToolBar(composite, this.itemStyle);
            this.toolBar.setMenu(this.getContextMenuControl());
            this.update(true);
            this.toolBar.getAccessible().addAccessibleListener(this.getAccessibleListener());
        }
        return this.toolBar;
    }

    private AccessibleListener getAccessibleListener() {
        return new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string;
                ToolItem toolItem;
                if (accessibleEvent.childID != -1 && (toolItem = ToolBarManager.this.toolBar.getItem(accessibleEvent.childID)) != null && (string = toolItem.getToolTipText()) != null) {
                    accessibleEvent.result = string;
                }
            }
        };
    }

    public void dispose() {
        if (this.toolBarExist()) {
            this.toolBar.dispose();
        }
        this.toolBar = null;
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].dispose();
            ++n;
        }
        if (this.getContextMenuManager() != null) {
            this.getContextMenuManager().dispose();
            this.setContextMenuManager(null);
        }
    }

    public ToolBar getControl() {
        return this.toolBar;
    }

    protected void relayout(ToolBar toolBar, int n, int n2) {
        if (n != n2 && n2 != 0) {
            Point point = toolBar.getSize();
            toolBar.pack(true);
            Point point2 = toolBar.getSize();
            if (point.equals((Object)point2)) {
                return;
            }
            toolBar.getParent().layout();
            if (toolBar.getParent() instanceof CoolBar) {
                CoolBar coolBar = (CoolBar)toolBar.getParent();
                CoolItem[] coolItemArray = coolBar.getItems();
                int n3 = 0;
                while (n3 < coolItemArray.length) {
                    if (coolItemArray[n3].getControl() == toolBar) {
                        Point point3 = coolItemArray[n3].getSize();
                        coolItemArray[n3].setSize(point3.x + (point2.x - point.x), point3.y + (point2.y - point.y));
                        return;
                    }
                    ++n3;
                }
            }
        }
    }

    private boolean toolBarExist() {
        return this.toolBar != null && !this.toolBar.isDisposed();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(boolean bl) {
        if ((this.isDirty() || bl) && this.toolBarExist()) {
            Object object;
            int n = this.toolBar.getItemCount();
            IContributionItem[] iContributionItemArray = this.getItems();
            ArrayList<Object> arrayList = new ArrayList<Object>(iContributionItemArray.length);
            Object object2 = null;
            int n2 = 0;
            while (n2 < iContributionItemArray.length) {
                object = iContributionItemArray[n2];
                if (this.isChildVisible((IContributionItem)object)) {
                    if (object.isSeparator()) {
                        object2 = object;
                    } else {
                        if (object2 != null) {
                            if (arrayList.size() > 0) {
                                arrayList.add(object2);
                            }
                            object2 = null;
                        }
                        arrayList.add(object);
                    }
                }
                ++n2;
            }
            ToolItem[] toolItemArray = this.toolBar.getItems();
            object = new ArrayList(toolItemArray.length);
            int n3 = 0;
            while (n3 < toolItemArray.length) {
                Object object3;
                if (toolItemArray[n3] != null && ((object3 = toolItemArray[n3].getData()) == null || !arrayList.contains(object3) || object3 instanceof IContributionItem && ((IContributionItem)object3).isDynamic())) {
                    ((ArrayList)object).add(toolItemArray[n3]);
                }
                ++n3;
            }
            n3 = arrayList.size() - (toolItemArray.length - ((ArrayList)object).size()) >= 3 ? 1 : 0;
            try {
                Object object3;
                void iContributionItem;
                if (n3 != 0) {
                    this.toolBar.setRedraw(false);
                }
                int n4 = ((ArrayList)object).size();
                while (--iContributionItem >= 0) {
                    object3 = (ToolItem)((ArrayList)object).get((int)iContributionItem);
                    if (object3.isDisposed()) continue;
                    Control n5 = object3.getControl();
                    if (n5 != null) {
                        object3.setControl(null);
                        n5.dispose();
                    }
                    object3.dispose();
                }
                toolItemArray = this.toolBar.getItems();
                int n5 = 0;
                int n6 = 0;
                for (IContributionItem n11 : arrayList) {
                    object3 = n5 < toolItemArray.length ? (IContributionItem)toolItemArray[n5].getData() : null;
                    if (object3 != null && n11.equals(object3)) {
                        ++n5;
                        ++n6;
                        continue;
                    }
                    if (object3 != null && object3.isSeparator() && n11.isSeparator()) {
                        toolItemArray[n5].setData((Object)n11);
                        ++n5;
                        ++n6;
                        continue;
                    }
                    int toolItem = this.toolBar.getItemCount();
                    n11.fill(this.toolBar, n6);
                    int control = this.toolBar.getItemCount() - toolItem;
                    int n7 = 0;
                    while (n7 < control) {
                        ToolItem toolItem2 = this.toolBar.getItem(n6++);
                        toolItem2.setData((Object)n11);
                        ++n7;
                    }
                }
                int n8 = toolItemArray.length;
                while (--n8 >= n5) {
                    ToolItem toolItem = toolItemArray[n8];
                    if (toolItem.isDisposed()) continue;
                    Control control = toolItem.getControl();
                    if (control != null) {
                        toolItem.setControl(null);
                        control.dispose();
                    }
                    toolItem.dispose();
                }
                this.setDirty(false);
            }
            finally {
                if (n3 != 0) {
                    this.toolBar.setRedraw(true);
                }
            }
            int n9 = this.toolBar.getItemCount();
            if (bl) {
                n = n9 + 1;
            }
            this.relayout(this.toolBar, n, n9);
        }
    }

    private Menu getContextMenuControl() {
        if (this.contextMenuManager != null && this.toolBar != null) {
            Menu menu = this.contextMenuManager.getMenu();
            if (menu == null || menu.isDisposed()) {
                menu = this.contextMenuManager.createContextMenu((Control)this.toolBar);
            }
            return menu;
        }
        return null;
    }

    public MenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public void setContextMenuManager(MenuManager menuManager) {
        this.contextMenuManager = menuManager;
        if (this.toolBar != null) {
            this.toolBar.setMenu(this.getContextMenuControl());
        }
    }

    private boolean isChildVisible(IContributionItem iContributionItem) {
        IContributionManagerOverrides iContributionManagerOverrides = this.getOverrides();
        Boolean bl = iContributionManagerOverrides == null ? null : this.getOverrides().getVisible(iContributionItem);
        if (bl != null) {
            return bl;
        }
        return iContributionItem.isVisible();
    }
}

