/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarContributionItem
extends ContributionItem
implements IToolBarContributionItem {
    public static final int SHOW_ALL_ITEMS = -1;
    private MenuManager chevronMenuManager = null;
    private CoolItem coolItem = null;
    private int currentHeight = -1;
    private int currentWidth = -1;
    private boolean disposed = false;
    private int minimumItemsToShow = -1;
    private ToolBarManager toolBarManager = null;
    private boolean useChevron = true;

    public ToolBarContributionItem() {
        this(new ToolBarManager(), null);
    }

    public ToolBarContributionItem(IToolBarManager iToolBarManager) {
        this(iToolBarManager, null);
    }

    public ToolBarContributionItem(IToolBarManager iToolBarManager, String string) {
        super(string);
        Assert.isTrue((boolean)(iToolBarManager instanceof ToolBarManager));
        this.toolBarManager = (ToolBarManager)iToolBarManager;
    }

    private final boolean checkDisposed() {
        if (this.disposed) {
            if (Policy.TRACE_TOOLBAR) {
                System.out.println("Method invocation on a disposed tool bar contribution item.");
                new Exception().printStackTrace(System.out);
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
            this.toolBarManager = null;
        }
        if (this.coolItem != null && !this.coolItem.isDisposed()) {
            this.coolItem.dispose();
            this.coolItem = null;
        }
        this.disposed = true;
    }

    @Override
    public void fill(CoolBar coolBar, int n) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.coolItem == null && coolBar != null) {
            ToolBar toolBar = this.toolBarManager.getControl();
            ToolBar toolBar2 = this.toolBarManager.createControl((Composite)coolBar);
            if (toolBar != null && toolBar.equals(toolBar2)) {
                this.toolBarManager.update(true);
            }
            if (toolBar2.getItemCount() < 1) {
                return;
            }
            int n2 = 4;
            this.coolItem = n >= 0 ? new CoolItem(coolBar, n2, n) : new CoolItem(coolBar, n2);
            this.coolItem.setData((Object)this);
            this.coolItem.setControl((Control)toolBar2);
            if (toolBar != toolBar2) {
                toolBar2.addListener(35, new Listener(){

                    public void handleEvent(Event event) {
                        if (ToolBarContributionItem.this.toolBarManager.getContextMenuManager() == null) {
                            ToolBarContributionItem.this.handleContextMenu(event);
                        }
                    }
                });
            }
            if (this.getUseChevron()) {
                this.coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        if (selectionEvent.detail == 4) {
                            ToolBarContributionItem.this.handleChevron(selectionEvent);
                        }
                    }
                });
            }
            this.coolItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ToolBarContributionItem.this.handleWidgetDispose(disposeEvent);
                }
            });
            this.updateSize(true);
        }
    }

    private int[] getAdjustedWrapIndices(int[] nArray) {
        int[] nArray2;
        if (nArray.length == 0) {
            nArray2 = new int[1];
        } else if (nArray[0] != 0) {
            nArray2 = new int[nArray.length + 1];
            nArray2[0] = 0;
            int n = 0;
            while (n < nArray.length) {
                nArray2[n + 1] = nArray[n];
                ++n;
            }
        } else {
            nArray2 = nArray;
        }
        return nArray2;
    }

    @Override
    public int getCurrentHeight() {
        if (this.checkDisposed()) {
            return -1;
        }
        return this.currentHeight;
    }

    @Override
    public int getCurrentWidth() {
        if (this.checkDisposed()) {
            return -1;
        }
        return this.currentWidth;
    }

    @Override
    public int getMinimumItemsToShow() {
        if (this.checkDisposed()) {
            return -1;
        }
        return this.minimumItemsToShow;
    }

    @Override
    public IToolBarManager getToolBarManager() {
        if (this.checkDisposed()) {
            return null;
        }
        return this.toolBarManager;
    }

    @Override
    public boolean getUseChevron() {
        if (this.checkDisposed()) {
            return false;
        }
        return this.useChevron;
    }

    private void handleChevron(SelectionEvent selectionEvent) {
        CoolItem coolItem = (CoolItem)selectionEvent.widget;
        Control control = coolItem.getControl();
        if (!(control instanceof ToolBar)) {
            return;
        }
        CoolBar coolBar = coolItem.getParent();
        ToolBar toolBar = (ToolBar)control;
        Rectangle rectangle2 = toolBar.getBounds();
        ToolItem[] toolItemArray = toolBar.getItems();
        ArrayList<ToolItem> arrayList = new ArrayList<ToolItem>();
        int n = 0;
        while (n < toolItemArray.length) {
            Rectangle rectangle3 = toolItemArray[n].getBounds();
            if (rectangle3.x + rectangle3.width > rectangle2.width || rectangle3.y + rectangle3.height > rectangle2.height) {
                arrayList.add(toolItemArray[n]);
            }
            ++n;
        }
        if (this.chevronMenuManager != null) {
            this.chevronMenuManager.dispose();
        }
        this.chevronMenuManager = new MenuManager();
        for (ToolItem toolItem : arrayList) {
            IContributionItem iContributionItem;
            IContributionItem iContributionItem2 = (IContributionItem)toolItem.getData();
            if (iContributionItem2 instanceof ActionContributionItem) {
                iContributionItem = new ActionContributionItem(((ActionContributionItem)iContributionItem2).getAction());
                this.chevronMenuManager.add(iContributionItem);
                continue;
            }
            if (iContributionItem2 instanceof SubContributionItem) {
                iContributionItem = ((SubContributionItem)iContributionItem2).getInnerItem();
                if (!(iContributionItem instanceof ActionContributionItem)) continue;
                ActionContributionItem actionContributionItem = new ActionContributionItem(((ActionContributionItem)iContributionItem).getAction());
                this.chevronMenuManager.add(actionContributionItem);
                continue;
            }
            if (!iContributionItem2.isSeparator()) continue;
            this.chevronMenuManager.add(new Separator());
        }
        Menu menu = this.chevronMenuManager.createContextMenu((Control)coolBar);
        Point point = coolBar.toDisplay(selectionEvent.x, selectionEvent.y);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    private void handleContextMenu(Event event) {
        ToolBar toolBar = this.toolBarManager.getControl();
        Menu menu = toolBar.getParent().getMenu();
        if (menu != null && !menu.isDisposed()) {
            toolBar.setMenu(menu);
            menu.addListener(23, new Listener(){

                public void handleEvent(Event event) {
                    ToolBar toolBar = ToolBarContributionItem.this.toolBarManager.getControl();
                    if (toolBar != null) {
                        toolBar.setMenu(null);
                        Menu menu = toolBar.getParent().getMenu();
                        if (menu != null) {
                            menu.removeListener(23, (Listener)this);
                        }
                    }
                }
            });
        }
    }

    private void handleWidgetDispose(DisposeEvent disposeEvent) {
        this.coolItem = null;
    }

    @Override
    public boolean isVisible() {
        if (this.checkDisposed()) {
            return false;
        }
        boolean bl = false;
        if (this.toolBarManager != null) {
            IContributionItem[] iContributionItemArray = this.toolBarManager.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IContributionItem iContributionItem = iContributionItemArray[n];
                if (!iContributionItem.isGroupMarker() && !iContributionItem.isSeparator()) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl || super.isVisible();
    }

    @Override
    public void saveWidgetState() {
        if (this.checkDisposed()) {
            return;
        }
        if (this.coolItem == null) {
            return;
        }
        CoolBar coolBar = this.coolItem.getParent();
        boolean bl = false;
        int n = coolBar.getItemCount() - 1;
        int n2 = coolBar.indexOf(this.coolItem);
        int[] nArray = this.getAdjustedWrapIndices(coolBar.getWrapIndices());
        int n3 = nArray.length - 1;
        while (n3 >= 0) {
            if (nArray[n3] <= n2) {
                int n4 = n3 + 1;
                int n5 = n4 > nArray.length - 1 ? n + 1 : nArray[n4];
                if (n2 != n5 - 1) break;
                bl = true;
                break;
            }
            --n3;
        }
        n3 = bl ? this.coolItem.getPreferredSize().x : this.coolItem.getSize().x;
        this.setCurrentWidth(n3);
        this.setCurrentHeight(this.coolItem.getSize().y);
    }

    @Override
    public void setCurrentHeight(int n) {
        if (this.checkDisposed()) {
            return;
        }
        this.currentHeight = n;
    }

    @Override
    public void setCurrentWidth(int n) {
        if (this.checkDisposed()) {
            return;
        }
        this.currentWidth = n;
    }

    @Override
    public void setMinimumItemsToShow(int n) {
        if (this.checkDisposed()) {
            return;
        }
        this.minimumItemsToShow = n;
    }

    @Override
    public void setUseChevron(boolean bl) {
        if (this.checkDisposed()) {
            return;
        }
        this.useChevron = bl;
    }

    @Override
    public void update(String string) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.coolItem != null) {
            IToolBarManager iToolBarManager = this.getToolBarManager();
            if (iToolBarManager != null) {
                iToolBarManager.update(true);
            }
            if (string == null || string.equals("size")) {
                this.updateSize(true);
            }
        }
    }

    private void updateSize(boolean bl) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.coolItem == null || this.coolItem.isDisposed()) {
            return;
        }
        boolean bl2 = false;
        CoolBar coolBar = this.coolItem.getParent();
        try {
            ToolBar toolBar;
            if (coolBar != null && coolBar.getLocked()) {
                coolBar.setLocked(false);
                bl2 = true;
            }
            if ((toolBar = (ToolBar)this.coolItem.getControl()) == null || toolBar.isDisposed() || toolBar.getItemCount() <= 0) {
                this.coolItem.setData(null);
                Control control = this.coolItem.getControl();
                if (control != null && !control.isDisposed()) {
                    control.dispose();
                    this.coolItem.setControl(null);
                }
                if (!this.coolItem.isDisposed()) {
                    this.coolItem.dispose();
                }
            } else {
                Point point = toolBar.computeSize(-1, -1);
                Point point2 = this.coolItem.computeSize(point.x, point.y);
                this.coolItem.setPreferredSize(point2);
                if (this.getMinimumItemsToShow() != -1) {
                    int n = toolBar.getItems()[0].getWidth();
                    int n2 = n * this.getMinimumItemsToShow();
                    this.coolItem.setMinimumSize(n2, point.y);
                } else {
                    this.coolItem.setMinimumSize(point.x, point.y);
                }
                if (bl) {
                    this.coolItem.setSize(point2);
                }
            }
        }
        finally {
            if (bl2 && coolBar != null) {
                coolBar.setLocked(true);
            }
        }
    }
}

