/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;

public class SubMenuManager
extends SubContributionManager
implements IMenuManager {
    private Map mapMenuToWrapper;
    private ListenerList menuListeners = new ListenerList();
    private IMenuListener menuListener;

    public SubMenuManager(IMenuManager iMenuManager) {
        super(iMenuManager);
    }

    @Override
    public void addMenuListener(IMenuListener iMenuListener) {
        this.menuListeners.add((Object)iMenuListener);
        if (this.menuListener == null) {
            this.menuListener = new IMenuListener(){

                @Override
                public void menuAboutToShow(IMenuManager iMenuManager) {
                    Object[] objectArray = SubMenuManager.this.menuListeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        ((IMenuListener)objectArray[n]).menuAboutToShow(SubMenuManager.this);
                        ++n;
                    }
                }
            };
        }
        this.getParentMenuManager().addMenuListener(this.menuListener);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void disposeManager() {
        if (this.menuListener != null) {
            this.getParentMenuManager().removeMenuListener(this.menuListener);
            this.menuListener = null;
            this.menuListeners.clear();
        }
        if (this.mapMenuToWrapper != null) {
            for (SubMenuManager subMenuManager : this.mapMenuToWrapper.values()) {
                subMenuManager.disposeManager();
            }
            this.mapMenuToWrapper.clear();
            this.mapMenuToWrapper = null;
        }
        super.disposeManager();
    }

    @Override
    public void fill(Composite composite) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(composite);
        }
    }

    @Override
    public void fill(CoolBar coolBar, int n) {
    }

    @Override
    public void fill(Menu menu, int n) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(menu, n);
        }
    }

    @Override
    public void fill(ToolBar toolBar, int n) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(toolBar, n);
        }
    }

    @Override
    public IContributionItem find(String string) {
        IContributionItem iContributionItem = this.getParentMenuManager().find(string);
        if (iContributionItem instanceof SubContributionItem) {
            iContributionItem = this.unwrap(iContributionItem);
        }
        if (iContributionItem instanceof IMenuManager) {
            IMenuManager iMenuManager = (IMenuManager)iContributionItem;
            iContributionItem = this.getWrapper(iMenuManager);
        }
        return iContributionItem;
    }

    @Override
    public IMenuManager findMenuUsingPath(String string) {
        IContributionItem iContributionItem = this.findUsingPath(string);
        if (iContributionItem instanceof IMenuManager) {
            return (IMenuManager)iContributionItem;
        }
        return null;
    }

    @Override
    public IContributionItem findUsingPath(String string) {
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(47);
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        IContributionItem iContributionItem = this.find(string2);
        if (string3 != null && iContributionItem instanceof IMenuManager) {
            IMenuManager iMenuManager = (IMenuManager)iContributionItem;
            iContributionItem = iMenuManager.findUsingPath(string3);
        }
        return iContributionItem;
    }

    @Override
    public String getId() {
        return this.getParentMenuManager().getId();
    }

    protected final IMenuManager getParentMenuManager() {
        return (IMenuManager)this.getParent();
    }

    @Override
    public boolean getRemoveAllWhenShown() {
        return false;
    }

    protected IMenuManager getWrapper(IMenuManager iMenuManager) {
        SubMenuManager subMenuManager;
        if (this.mapMenuToWrapper == null) {
            this.mapMenuToWrapper = new HashMap(4);
        }
        if ((subMenuManager = (SubMenuManager)this.mapMenuToWrapper.get(iMenuManager)) == null) {
            subMenuManager = this.wrapMenu(iMenuManager);
            this.mapMenuToWrapper.put(iMenuManager, subMenuManager);
        }
        return subMenuManager;
    }

    @Override
    public boolean isDynamic() {
        return this.getParentMenuManager().isDynamic();
    }

    @Override
    public boolean isEnabled() {
        return this.isVisible() && this.getParentMenuManager().isEnabled();
    }

    @Override
    public boolean isGroupMarker() {
        return this.getParentMenuManager().isGroupMarker();
    }

    @Override
    public boolean isSeparator() {
        return this.getParentMenuManager().isSeparator();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (this.mapMenuToWrapper != null) {
            for (SubMenuManager subMenuManager : this.mapMenuToWrapper.values()) {
                subMenuManager.removeAll();
            }
            this.mapMenuToWrapper.clear();
            this.mapMenuToWrapper = null;
        }
    }

    @Override
    public void removeMenuListener(IMenuListener iMenuListener) {
        this.menuListeners.remove((Object)iMenuListener);
    }

    @Override
    public void saveWidgetState() {
    }

    @Override
    public void setParent(IContributionManager iContributionManager) {
    }

    @Override
    public void setRemoveAllWhenShown(boolean bl) {
        Assert.isTrue((boolean)false, (String)"Should not be called on submenu manager");
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.mapMenuToWrapper != null) {
            for (SubMenuManager subMenuManager : this.mapMenuToWrapper.values()) {
                subMenuManager.setVisible(bl);
            }
        }
    }

    @Override
    public void update() {
        this.getParentMenuManager().update();
    }

    @Override
    public void update(boolean bl) {
        this.getParentMenuManager().update(bl);
    }

    @Override
    public void update(String string) {
        this.getParentMenuManager().update(string);
    }

    @Override
    public void updateAll(boolean bl) {
        this.getParentMenuManager().updateAll(bl);
    }

    protected SubMenuManager wrapMenu(IMenuManager iMenuManager) {
        SubMenuManager subMenuManager = new SubMenuManager(iMenuManager);
        subMenuManager.setVisible(this.isVisible());
        return subMenuManager;
    }
}

