/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.SubContributionItem;

public abstract class SubContributionManager
implements IContributionManager {
    private IContributionManager parentMgr;
    private Map mapItemToWrapper = new HashMap();
    private boolean visible = false;

    public SubContributionManager(IContributionManager iContributionManager) {
        this.parentMgr = iContributionManager;
    }

    @Override
    public void add(IAction iAction) {
        this.add(new ActionContributionItem(iAction));
    }

    @Override
    public void add(IContributionItem iContributionItem) {
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.add(subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    @Override
    public void appendToGroup(String string, IAction iAction) {
        this.appendToGroup(string, new ActionContributionItem(iAction));
    }

    @Override
    public void appendToGroup(String string, IContributionItem iContributionItem) {
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.appendToGroup(string, subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    public void disposeManager() {
        for (IContributionItem iContributionItem : this.mapItemToWrapper.values()) {
            iContributionItem.dispose();
        }
        this.removeAll();
    }

    @Override
    public IContributionItem find(String string) {
        IContributionItem iContributionItem = this.parentMgr.find(string);
        iContributionItem = this.unwrap(iContributionItem);
        return iContributionItem;
    }

    @Override
    public IContributionItem[] getItems() {
        IContributionItem[] iContributionItemArray = new IContributionItem[this.mapItemToWrapper.size()];
        this.mapItemToWrapper.keySet().toArray(iContributionItemArray);
        return iContributionItemArray;
    }

    public IContributionManager getParent() {
        return this.parentMgr;
    }

    @Override
    public IContributionManagerOverrides getOverrides() {
        return this.parentMgr.getOverrides();
    }

    @Override
    public void insertAfter(String string, IAction iAction) {
        this.insertAfter(string, new ActionContributionItem(iAction));
    }

    @Override
    public void insertAfter(String string, IContributionItem iContributionItem) {
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.insertAfter(string, subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    @Override
    public void insertBefore(String string, IAction iAction) {
        this.insertBefore(string, new ActionContributionItem(iAction));
    }

    @Override
    public void insertBefore(String string, IContributionItem iContributionItem) {
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.insertBefore(string, subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    @Override
    public boolean isDirty() {
        return this.parentMgr.isDirty();
    }

    @Override
    public boolean isEmpty() {
        return this.parentMgr.isEmpty();
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void itemAdded(IContributionItem iContributionItem, SubContributionItem subContributionItem) {
        iContributionItem.setParent(this);
        this.mapItemToWrapper.put(iContributionItem, subContributionItem);
    }

    protected void itemRemoved(IContributionItem iContributionItem) {
        this.mapItemToWrapper.remove(iContributionItem);
        iContributionItem.setParent(null);
    }

    public Enumeration items() {
        final Iterator iterator = this.mapItemToWrapper.values().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    @Override
    public void markDirty() {
        this.parentMgr.markDirty();
    }

    @Override
    public void prependToGroup(String string, IAction iAction) {
        this.prependToGroup(string, new ActionContributionItem(iAction));
    }

    @Override
    public void prependToGroup(String string, IContributionItem iContributionItem) {
        SubContributionItem subContributionItem = this.wrap(iContributionItem);
        subContributionItem.setVisible(this.visible);
        this.parentMgr.prependToGroup(string, subContributionItem);
        this.itemAdded(iContributionItem, subContributionItem);
    }

    @Override
    public IContributionItem remove(String string) {
        IContributionItem iContributionItem = this.parentMgr.remove(string);
        if (iContributionItem != null) {
            IContributionItem iContributionItem2 = this.unwrap(iContributionItem);
            this.itemRemoved(iContributionItem2);
        }
        return iContributionItem;
    }

    @Override
    public IContributionItem remove(IContributionItem iContributionItem) {
        SubContributionItem subContributionItem = (SubContributionItem)this.mapItemToWrapper.get(iContributionItem);
        if (subContributionItem == null) {
            return null;
        }
        IContributionItem iContributionItem2 = this.parentMgr.remove(subContributionItem);
        if (iContributionItem2 == null) {
            return null;
        }
        this.itemRemoved(iContributionItem);
        return iContributionItem;
    }

    @Override
    public void removeAll() {
        Object[] objectArray = this.mapItemToWrapper.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            IContributionItem iContributionItem = (IContributionItem)objectArray[n];
            this.remove(iContributionItem);
            ++n;
        }
        this.mapItemToWrapper.clear();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        if (this.mapItemToWrapper.size() > 0) {
            for (IContributionItem iContributionItem : this.mapItemToWrapper.values()) {
                iContributionItem.setVisible(bl);
            }
            this.parentMgr.markDirty();
        }
    }

    protected SubContributionItem wrap(IContributionItem iContributionItem) {
        return new SubContributionItem(iContributionItem);
    }

    protected IContributionItem unwrap(IContributionItem iContributionItem) {
        if (iContributionItem instanceof SubContributionItem) {
            return ((SubContributionItem)iContributionItem).getInnerItem();
        }
        return iContributionItem;
    }
}

