/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLine;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatusLineManager
extends ContributionManager
implements IStatusLineManager {
    public static final String BEGIN_GROUP = "BEGIN_GROUP";
    public static final String MIDDLE_GROUP = "MIDDLE_GROUP";
    public static final String END_GROUP = "END_GROUP";
    private Composite statusLine = null;

    public StatusLineManager() {
        this.add(new GroupMarker(BEGIN_GROUP));
        this.add(new GroupMarker(MIDDLE_GROUP));
        this.add(new GroupMarker(END_GROUP));
    }

    public Control createControl(Composite composite) {
        return this.createControl(composite, 0);
    }

    public Control createControl(Composite composite, int n) {
        if (!this.statusLineExist() && composite != null) {
            this.statusLine = new StatusLine(composite, n);
            this.update(false);
        }
        return this.statusLine;
    }

    public void dispose() {
        if (this.statusLineExist()) {
            this.statusLine.dispose();
        }
        this.statusLine = null;
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].dispose();
            ++n;
        }
    }

    public Control getControl() {
        return this.statusLine;
    }

    protected IProgressMonitor getProgressMonitorDelegate() {
        return (IProgressMonitor)this.getControl();
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        final IProgressMonitor iProgressMonitor = this.statusLineExist() ? this.getProgressMonitorDelegate() : new NullProgressMonitor();
        return new IProgressMonitorWithBlocking(){

            public void beginTask(String string, int n) {
                iProgressMonitor.beginTask(string, n);
            }

            public void done() {
                iProgressMonitor.done();
            }

            public void internalWorked(double d) {
                iProgressMonitor.internalWorked(d);
            }

            public boolean isCanceled() {
                return iProgressMonitor.isCanceled();
            }

            public void setCanceled(boolean bl) {
                if (StatusLineManager.this.statusLineExist()) {
                    iProgressMonitor.setCanceled(bl);
                }
            }

            public void setTaskName(String string) {
                iProgressMonitor.setTaskName(string);
            }

            public void subTask(String string) {
                iProgressMonitor.subTask(string);
            }

            public void worked(int n) {
                iProgressMonitor.worked(n);
            }

            public void clearBlocked() {
            }

            public void setBlocked(IStatus iStatus) {
            }
        };
    }

    @Override
    public boolean isCancelEnabled() {
        return this.statusLineExist() && ((StatusLine)this.statusLine).isCancelEnabled();
    }

    @Override
    public void setCancelEnabled(boolean bl) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setCancelEnabled(bl);
        }
    }

    @Override
    public void setErrorMessage(String string) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setErrorMessage(string);
        }
    }

    @Override
    public void setErrorMessage(Image image, String string) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setErrorMessage(image, string);
        }
    }

    @Override
    public void setMessage(String string) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setMessage(string);
        }
    }

    @Override
    public void setMessage(Image image, String string) {
        if (this.statusLineExist()) {
            ((StatusLine)this.statusLine).setMessage(image, string);
        }
    }

    private boolean statusLineExist() {
        return this.statusLine != null && !this.statusLine.isDisposed();
    }

    @Override
    public void update(boolean bl) {
        if ((this.isDirty() || bl) && this.statusLineExist()) {
            IContributionItem[] iContributionItemArray;
            this.statusLine.setRedraw(false);
            Control[] controlArray = this.statusLine.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                iContributionItemArray = controlArray[n];
                Object object = iContributionItemArray.getData();
                if (object instanceof IContributionItem) {
                    iContributionItemArray.dispose();
                }
                ++n;
            }
            n = this.statusLine.getChildren().length;
            iContributionItemArray = this.getItems();
            int n2 = 0;
            while (n2 < iContributionItemArray.length) {
                IContributionItem iContributionItem = iContributionItemArray[n2];
                if (iContributionItem.isVisible()) {
                    iContributionItem.fill(this.statusLine);
                    Control[] controlArray2 = this.statusLine.getChildren();
                    int n3 = n;
                    while (n3 < controlArray2.length) {
                        controlArray2[n3].setData((Object)iContributionItem);
                        ++n3;
                    }
                    n = controlArray2.length;
                }
                ++n2;
            }
            this.setDirty(false);
            this.statusLine.layout();
            this.statusLine.setRedraw(true);
        }
    }
}

