/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class StatusLineContributionItem
extends ContributionItem {
    private static final int DEFAULT_CHAR_WIDTH = 40;
    public static final int CALC_TRUE_WIDTH = -1;
    private int charWidth;
    private CLabel label;
    private Composite statusLine = null;
    private String text = "";
    private int widthHint = -1;
    private int heightHint = -1;

    public StatusLineContributionItem(String string) {
        this(string, 40);
    }

    public StatusLineContributionItem(String string, int n) {
        super(string);
        this.charWidth = n;
        this.setVisible(false);
    }

    @Override
    public void fill(Composite composite) {
        Object object;
        this.statusLine = composite;
        Label label = new Label(composite, 2);
        this.label = new CLabel(this.statusLine, 32);
        this.label.setText(this.text);
        if (this.charWidth == -1) {
            object = this.label.computeSize(-1, -1);
            this.widthHint = object.x;
            this.heightHint = object.y;
        } else if (this.widthHint < 0) {
            object = new GC((Drawable)this.statusLine);
            object.setFont(this.statusLine.getFont());
            FontMetrics fontMetrics = object.getFontMetrics();
            this.widthHint = fontMetrics.getAverageCharWidth() * this.charWidth;
            this.heightHint = fontMetrics.getHeight();
            object.dispose();
        }
        object = new StatusLineLayoutData();
        object.widthHint = this.widthHint;
        this.label.setLayoutData(object);
        object = new StatusLineLayoutData();
        object.heightHint = this.heightHint;
        label.setLayoutData(object);
    }

    public Point getDisplayLocation() {
        if (this.label != null && this.statusLine != null) {
            return this.statusLine.toDisplay(this.label.getLocation());
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        Assert.isNotNull((Object)string);
        this.text = LegacyActionTools.escapeMnemonics(string);
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.text);
        }
        if (this.text.length() == 0) {
            if (this.isVisible()) {
                this.setVisible(false);
                IContributionManager iContributionManager = this.getParent();
                if (iContributionManager != null) {
                    iContributionManager.update(true);
                }
            }
        } else if (!this.isVisible() || this.charWidth == -1) {
            this.setVisible(true);
            IContributionManager iContributionManager = this.getParent();
            if (iContributionManager != null) {
                iContributionManager.update(true);
            }
        }
    }
}

