/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class StatusLine
extends Composite
implements IProgressMonitor {
    public static final int GAP = 3;
    public static final int DELAY_PROGRESS = 500;
    protected boolean fProgressIsVisible = false;
    protected boolean fCancelButtonIsVisible = false;
    protected boolean fCancelEnabled = false;
    protected String fTaskName;
    protected volatile boolean fIsCanceled;
    protected long fStartTime;
    private Cursor fStopButtonCursor;
    protected String fMessageText;
    protected Image fMessageImage;
    protected String fErrorText;
    protected Image fErrorImage;
    protected CLabel fMessageLabel;
    protected Composite fProgressBarComposite;
    protected ProgressIndicator fProgressBar;
    protected ToolBar fToolBar;
    protected ToolItem fCancelButton;
    protected static ImageDescriptor fgStopImage = ImageDescriptor.createFromFile(StatusLine.class, "images/stop.gif");
    private MenuItem copyMenuItem;

    static {
        JFaceResources.getImageRegistry().put("org.eclipse.jface.parts.StatusLine.stopImage", fgStopImage);
    }

    public StatusLine(Composite composite, int n) {
        super(composite, n);
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 23;
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                StatusLine.this.handleDispose();
            }
        });
        this.setLayout(new StatusLineLayout());
        this.fMessageLabel = new CLabel((Composite)this, 0);
        Menu menu = new Menu((Control)this.fMessageLabel);
        this.fMessageLabel.setMenu(menu);
        this.copyMenuItem = new MenuItem(menu, 8);
        this.copyMenuItem.setText(JFaceResources.getString("copy"));
        this.copyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = StatusLine.this.fMessageLabel.getText();
                if (string != null && string.length() > 0) {
                    string = LegacyActionTools.removeMnemonics(string);
                    Clipboard clipboard = new Clipboard(selectionEvent.display);
                    clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                    clipboard.dispose();
                }
            }
        });
        this.fProgressIsVisible = false;
        this.fCancelEnabled = false;
        this.fToolBar = new ToolBar((Composite)this, 0x800000);
        this.fCancelButton = new ToolItem(this.fToolBar, 8);
        this.fCancelButton.setImage(fgStopImage.createImage());
        this.fCancelButton.setToolTipText(JFaceResources.getString("Cancel_Current_Operation"));
        this.fCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StatusLine.this.setCanceled(true);
            }
        });
        this.fCancelButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Image image = StatusLine.this.fCancelButton.getImage();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
        this.fProgressBarComposite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fProgressBarComposite.setLayout((Layout)gridLayout);
        this.fProgressBar = new ProgressIndicator(this.fProgressBarComposite);
        this.fProgressBar.setLayoutData(new GridData(1536));
        this.fStopButtonCursor = new Cursor((Device)this.getDisplay(), 0);
    }

    public void beginTask(String string, int n) {
        long l;
        this.fStartTime = l = System.currentTimeMillis();
        final boolean bl = n == -1 || n == 0;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StatusLine.this.startTask(l, bl);
            }
        };
        if (this.fProgressBar == null) {
            return;
        }
        this.fProgressBar.getDisplay().timerExec(500, runnable);
        if (!bl) {
            this.fProgressBar.beginTask(n);
        }
        this.fTaskName = string == null ? "" : string;
        this.setMessage(this.fTaskName);
    }

    public void done() {
        this.fStartTime = 0L;
        if (this.fProgressBar != null) {
            this.fProgressBar.sendRemainingWork();
            this.fProgressBar.done();
        }
        this.setMessage(null);
        this.hideProgress();
    }

    public IProgressMonitor getProgressMonitor() {
        return this;
    }

    protected void handleDispose() {
        if (this.fStopButtonCursor != null) {
            this.fStopButtonCursor.dispose();
            this.fStopButtonCursor = null;
        }
        if (this.fProgressBar != null) {
            this.fProgressBar.dispose();
            this.fProgressBar = null;
        }
    }

    protected void hideProgress() {
        if (this.fProgressIsVisible && !this.isDisposed()) {
            this.fProgressIsVisible = false;
            this.fCancelEnabled = false;
            this.fCancelButtonIsVisible = false;
            if (this.fToolBar != null && !this.fToolBar.isDisposed()) {
                this.fToolBar.setVisible(false);
            }
            if (this.fProgressBarComposite != null && !this.fProgressBarComposite.isDisposed()) {
                this.fProgressBarComposite.setVisible(false);
            }
            this.layout();
        }
    }

    public void internalWorked(double d) {
        if (!this.fProgressIsVisible && System.currentTimeMillis() - this.fStartTime > 500L) {
            this.showProgress();
        }
        if (this.fProgressBar != null) {
            this.fProgressBar.worked(d);
        }
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public boolean isCancelEnabled() {
        return this.fCancelEnabled;
    }

    public void setCanceled(boolean bl) {
        this.fIsCanceled = bl;
        if (this.fCancelButton != null) {
            this.fCancelButton.setEnabled(!bl);
        }
    }

    public void setCancelEnabled(boolean bl) {
        this.fCancelEnabled = bl;
        if (this.fProgressIsVisible && !this.fCancelButtonIsVisible && bl) {
            this.showButton();
            this.layout();
        }
        if (this.fCancelButton != null && !this.fCancelButton.isDisposed()) {
            this.fCancelButton.setEnabled(bl);
        }
    }

    public void setErrorMessage(String string) {
        this.setErrorMessage(null, string);
    }

    public void setErrorMessage(Image image, String string) {
        this.fErrorText = this.trim(string);
        this.fErrorImage = image;
        this.updateMessageLabel();
    }

    public void setFont(Font font) {
        super.setFont(font);
        Control[] controlArray = this.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setFont(font);
            ++n;
        }
    }

    public void setMessage(String string) {
        this.setMessage(null, string);
    }

    public void setMessage(Image image, String string) {
        this.fMessageText = this.trim(string);
        this.fMessageImage = image;
        this.updateMessageLabel();
    }

    public void setTaskName(String string) {
        this.fTaskName = string == null ? "" : string;
    }

    protected void showButton() {
        if (this.fToolBar != null && !this.fToolBar.isDisposed()) {
            this.fToolBar.setVisible(true);
            this.fToolBar.setEnabled(true);
            this.fToolBar.setCursor(this.fStopButtonCursor);
            this.fCancelButtonIsVisible = true;
        }
    }

    protected void showProgress() {
        if (!this.fProgressIsVisible && !this.isDisposed()) {
            this.fProgressIsVisible = true;
            if (this.fCancelEnabled) {
                this.showButton();
            }
            if (this.fProgressBarComposite != null && !this.fProgressBarComposite.isDisposed()) {
                this.fProgressBarComposite.setVisible(true);
            }
            this.layout();
        }
    }

    void startTask(long l, boolean bl) {
        if (!this.fProgressIsVisible && this.fStartTime == l) {
            this.showProgress();
            if (bl && this.fProgressBar != null && !this.fProgressBar.isDisposed()) {
                this.fProgressBar.beginAnimatedTask();
            }
        }
    }

    public void subTask(String string) {
        String string2 = string == null ? "" : string;
        String string3 = this.fTaskName == null || this.fTaskName.length() == 0 ? string2 : JFaceResources.format("Set_SubTask", new Object[]{this.fTaskName, string2});
        this.setMessage(string3);
    }

    String trim(String string) {
        if (string == null) {
            return null;
        }
        string = LegacyActionTools.escapeMnemonics(string);
        int n = string.indexOf(13);
        int n2 = string.indexOf(10);
        if (n == -1 && n2 == -1) {
            return string;
        }
        int n3 = n == -1 ? n2 : (n2 == -1 ? n : Math.min(n, n2));
        return string.substring(0, n3);
    }

    protected void updateMessageLabel() {
        if (this.fMessageLabel != null && !this.fMessageLabel.isDisposed()) {
            Display display = this.fMessageLabel.getDisplay();
            if (this.fErrorText != null && this.fErrorText.length() > 0 || this.fErrorImage != null) {
                this.fMessageLabel.setForeground(JFaceColors.getErrorText(display));
                this.fMessageLabel.setText(this.fErrorText);
                this.fMessageLabel.setImage(this.fErrorImage);
            } else {
                this.fMessageLabel.setForeground(display.getSystemColor(21));
                this.fMessageLabel.setText(this.fMessageText == null ? "" : this.fMessageText);
                this.fMessageLabel.setImage(this.fMessageImage);
            }
            if (this.copyMenuItem != null && !this.copyMenuItem.isDisposed()) {
                String string = this.fMessageLabel.getText();
                this.copyMenuItem.setEnabled(string != null && string.length() > 0);
            }
        }
    }

    public void worked(int n) {
        this.internalWorked(n);
    }

    public class StatusLineLayout
    extends Layout {
        private final StatusLineLayoutData DEFAULT_DATA = new StatusLineLayoutData();

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Control[] controlArray = composite.getChildren();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < controlArray.length) {
                boolean bl2 = true;
                Control control = controlArray[n6];
                if (control == StatusLine.this.fProgressBarComposite && !StatusLine.this.fProgressIsVisible) {
                    bl2 = false;
                } else if (control == StatusLine.this.fToolBar && !StatusLine.this.fCancelButtonIsVisible) {
                    bl2 = false;
                }
                StatusLineLayoutData statusLineLayoutData = (StatusLineLayoutData)control.getLayoutData();
                if (statusLineLayoutData == null) {
                    statusLineLayoutData = this.DEFAULT_DATA;
                }
                Point point = control.computeSize(statusLineLayoutData.widthHint, statusLineLayoutData.heightHint, bl);
                if (bl2) {
                    n3 += point.x;
                    ++n5;
                }
                n4 = Math.max(n4, point.y);
                ++n6;
            }
            if (n5 > 0) {
                n3 += (n5 - 1) * 3;
            }
            if (n3 <= 0) {
                n3 = n4 * 4;
            }
            return new Point(n3, n4);
        }

        public void layout(Composite composite, boolean bl) {
            int n;
            if (composite == null) {
                return;
            }
            StatusLine.this.fMessageLabel.moveAbove(null);
            StatusLine.this.fToolBar.moveBelow((Control)StatusLine.this.fMessageLabel);
            StatusLine.this.fProgressBarComposite.moveBelow((Control)StatusLine.this.fToolBar);
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n2 = controlArray.length;
            int[] nArray = new int[n2];
            int n3 = rectangle.height;
            int n4 = -3;
            int n5 = 0;
            while (n5 < n2) {
                Control control = controlArray[n5];
                if ((control != StatusLine.this.fProgressBarComposite || StatusLine.this.fProgressIsVisible) && (control != StatusLine.this.fToolBar || StatusLine.this.fCancelButtonIsVisible)) {
                    StatusLineLayoutData statusLineLayoutData = (StatusLineLayoutData)control.getLayoutData();
                    if (statusLineLayoutData == null) {
                        statusLineLayoutData = this.DEFAULT_DATA;
                    }
                    nArray[n5] = n = control.computeSize((int)statusLineLayoutData.widthHint, (int)n3, (boolean)bl).x;
                    n4 += n + 3;
                }
                ++n5;
            }
            n5 = rectangle.width - n4;
            nArray[0] = nArray[0] + n5;
            int n6 = rectangle.width / 3;
            if (nArray[0] < n6) {
                n5 = nArray[0] - n6;
                nArray[0] = n6;
            } else {
                n5 = 0;
            }
            int n7 = n2 - 1;
            while (n7 >= 0 && n5 < 0) {
                n = Math.min(nArray[n7], -n5);
                int n8 = n7--;
                nArray[n8] = nArray[n8] - n;
                n5 += n + 3;
            }
            n7 = rectangle.x;
            n = rectangle.y;
            int n9 = 0;
            while (n9 < n2) {
                Control control = controlArray[n9];
                if (control == StatusLine.this.fProgressBarComposite && !StatusLine.this.fProgressIsVisible || control == StatusLine.this.fToolBar && !StatusLine.this.fCancelButtonIsVisible) {
                    control.setBounds(n7 + rectangle.width, n, nArray[n9], n3);
                } else {
                    control.setBounds(n7, n, nArray[n9], n3);
                    if (nArray[n9] > 0) {
                        n7 += nArray[n9] + 3;
                    }
                }
                ++n9;
            }
        }
    }
}

