/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class MenuManager
extends ContributionManager
implements IMenuManager {
    private static final String MANAGER_KEY = "org.eclipse.jface.action.MenuManager.managerKey";
    private String id;
    private ListenerList listeners = new ListenerList();
    private Menu menu = null;
    private MenuItem menuItem;
    private String menuText;
    private ImageDescriptor image;
    private LocalResourceManager imageManager;
    private IContributionManagerOverrides overrides;
    private IContributionManager parent;
    private boolean removeAllWhenShown = false;
    protected boolean visible = true;
    private String definitionId = null;

    public MenuManager() {
        this(null, null, null);
    }

    public MenuManager(String string) {
        this(string, null, null);
    }

    public MenuManager(String string, String string2) {
        this(string, null, string2);
    }

    public MenuManager(String string, ImageDescriptor imageDescriptor, String string2) {
        this.menuText = string;
        this.image = imageDescriptor;
        this.id = string2;
    }

    @Override
    public void addMenuListener(IMenuListener iMenuListener) {
        this.listeners.add((Object)iMenuListener);
    }

    public Menu createContextMenu(Control control) {
        if (!this.menuExist()) {
            this.menu = new Menu(control);
            this.menu.setData(MANAGER_KEY, (Object)this);
            this.initializeMenu();
        }
        return this.menu;
    }

    public Menu createMenuBar(Decorations decorations) {
        if (!this.menuExist()) {
            this.menu = new Menu(decorations, 2);
            this.menu.setData(MANAGER_KEY, (Object)this);
            this.update(false);
        }
        return this.menu;
    }

    public Menu createMenuBar(Shell shell) {
        return this.createMenuBar((Decorations)shell);
    }

    @Override
    public void dispose() {
        if (this.menuExist()) {
            this.menu.dispose();
        }
        this.menu = null;
        if (this.menuItem != null) {
            this.menuItem.dispose();
            this.menuItem = null;
        }
        this.disposeOldImages();
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].dispose();
            ++n;
        }
        this.markDirty();
    }

    @Override
    public void fill(Composite composite) {
    }

    @Override
    public void fill(CoolBar coolBar, int n) {
    }

    @Override
    public void fill(Menu menu, int n) {
        if (this.menuItem == null || this.menuItem.isDisposed()) {
            this.menuItem = n >= 0 ? new MenuItem(menu, 64, n) : new MenuItem(menu, 64);
            String string = this.getMenuText();
            if (string != null) {
                this.menuItem.setText(string);
            }
            if (this.image != null) {
                LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources());
                this.menuItem.setImage(localResourceManager.createImage(this.image));
                this.disposeOldImages();
                this.imageManager = localResourceManager;
            }
            if (!this.menuExist()) {
                this.menu = new Menu(menu);
                this.menu.setData(MANAGER_KEY, (Object)this);
            }
            this.menuItem.setMenu(this.menu);
            this.initializeMenu();
            this.setDirty(true);
        }
    }

    @Override
    public void fill(ToolBar toolBar, int n) {
    }

    @Override
    public IMenuManager findMenuUsingPath(String string) {
        IContributionItem iContributionItem = this.findUsingPath(string);
        if (iContributionItem instanceof IMenuManager) {
            return (IMenuManager)iContributionItem;
        }
        return null;
    }

    @Override
    public IContributionItem findUsingPath(String string) {
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(47);
        if (n == -1) {
            return super.find(string);
        }
        string2 = string.substring(0, n);
        string3 = string.substring(n + 1);
        IContributionItem iContributionItem = super.find(string2);
        if (iContributionItem instanceof IMenuManager) {
            IMenuManager iMenuManager = (IMenuManager)iContributionItem;
            return iMenuManager.findUsingPath(string3);
        }
        return null;
    }

    private void fireAboutToShow(IMenuManager iMenuManager) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IMenuListener)objectArray[n]).menuAboutToShow(iMenuManager);
            ++n;
        }
    }

    private void fireAboutToHide(IMenuManager iMenuManager) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IMenuListener2) {
                IMenuListener2 iMenuListener2 = (IMenuListener2)object;
                iMenuListener2.menuAboutToHide(iMenuManager);
            }
            ++n;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public String getMenuText() {
        if (this.definitionId == null) {
            return this.menuText;
        }
        ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
        if (iCallback != null) {
            String string = iCallback.getAcceleratorText(this.definitionId);
            if (string == null) {
                return this.menuText;
            }
            return String.valueOf(this.menuText) + "\t" + string;
        }
        return this.menuText;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    @Override
    public IContributionManagerOverrides getOverrides() {
        if (this.overrides == null) {
            this.overrides = this.parent == null ? new IContributionManagerOverrides(){

                @Override
                public Integer getAccelerator(IContributionItem iContributionItem) {
                    return null;
                }

                @Override
                public String getAcceleratorText(IContributionItem iContributionItem) {
                    return null;
                }

                @Override
                public Boolean getEnabled(IContributionItem iContributionItem) {
                    return null;
                }

                @Override
                public String getText(IContributionItem iContributionItem) {
                    return null;
                }

                @Override
                public Boolean getVisible(IContributionItem iContributionItem) {
                    return null;
                }
            } : this.parent.getOverrides();
            super.setOverrides(this.overrides);
        }
        return this.overrides;
    }

    public IContributionManager getParent() {
        return this.parent;
    }

    @Override
    public boolean getRemoveAllWhenShown() {
        return this.removeAllWhenShown;
    }

    private void handleAboutToShow() {
        if (this.removeAllWhenShown) {
            this.removeAll();
        }
        this.fireAboutToShow(this);
        this.update(false, false);
    }

    private void handleAboutToHide() {
        this.fireAboutToHide(this);
    }

    private void initializeMenu() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent menuEvent) {
                MenuManager.this.handleAboutToHide();
            }

            public void menuShown(MenuEvent menuEvent) {
                MenuManager.this.handleAboutToShow();
            }
        });
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isGroupMarker() {
        return false;
    }

    @Override
    public boolean isSeparator() {
        return false;
    }

    public boolean isSubstituteFor(IContributionItem iContributionItem) {
        return this.equals(iContributionItem);
    }

    @Override
    public boolean isVisible() {
        if (!this.visible) {
            return false;
        }
        if (this.removeAllWhenShown) {
            return true;
        }
        IContributionItem[] iContributionItemArray = this.getItems();
        boolean bl = false;
        int n = 0;
        while (n < iContributionItemArray.length) {
            if (this.isChildVisible(iContributionItemArray[n]) && !iContributionItemArray[n].isSeparator()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    @Override
    public void markDirty() {
        super.markDirty();
        IContributionManager iContributionManager = this.getParent();
        if (iContributionManager != null) {
            iContributionManager.markDirty();
        }
    }

    protected boolean menuExist() {
        return this.menu != null && !this.menu.isDisposed();
    }

    @Override
    public void removeMenuListener(IMenuListener iMenuListener) {
        this.listeners.remove((Object)iMenuListener);
    }

    @Override
    public void saveWidgetState() {
    }

    @Override
    public void setOverrides(IContributionManagerOverrides iContributionManagerOverrides) {
        this.overrides = iContributionManagerOverrides;
        super.setOverrides(this.overrides);
    }

    @Override
    public void setParent(IContributionManager iContributionManager) {
        this.parent = iContributionManager;
    }

    @Override
    public void setRemoveAllWhenShown(boolean bl) {
        this.removeAllWhenShown = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setActionDefinitionId(String string) {
        this.definitionId = string;
    }

    @Override
    public void update() {
        this.updateMenuItem();
    }

    @Override
    public void update(boolean bl) {
        this.update(bl, false);
    }

    protected Item[] getMenuItems() {
        if (this.menu != null) {
            return this.menu.getItems();
        }
        return null;
    }

    protected Item getMenuItem(int n) {
        if (this.menu != null) {
            return this.menu.getItem(n);
        }
        return null;
    }

    protected int getMenuItemCount() {
        if (this.menu != null) {
            return this.menu.getItemCount();
        }
        return 0;
    }

    protected void doItemFill(IContributionItem iContributionItem, int n) {
        iContributionItem.fill(this.menu, n);
    }

    protected void update(boolean bl, boolean bl2) {
        if (this.isDirty() || bl) {
            if (this.menuExist()) {
                IContributionItem[] iContributionItemArray = this.getItems();
                ArrayList<IContributionItem> arrayList = new ArrayList<IContributionItem>(iContributionItemArray.length);
                IContributionItem iContributionItem = null;
                int n = 0;
                while (n < iContributionItemArray.length) {
                    IContributionItem iContributionItem2 = iContributionItemArray[n];
                    if (this.isChildVisible(iContributionItem2)) {
                        if (iContributionItem2.isSeparator()) {
                            iContributionItem = iContributionItem2;
                        } else {
                            if (iContributionItem != null) {
                                if (arrayList.size() > 0) {
                                    arrayList.add(iContributionItem);
                                }
                                iContributionItem = null;
                            }
                            arrayList.add(iContributionItem2);
                        }
                    }
                    ++n;
                }
                Item[] itemArray = this.getMenuItems();
                int n2 = 0;
                while (n2 < itemArray.length) {
                    Object object = itemArray[n2].getData();
                    if (object == null || !arrayList.contains(object)) {
                        itemArray[n2].dispose();
                    } else if (object instanceof IContributionItem && ((IContributionItem)object).isDynamic() && ((IContributionItem)object).isDirty()) {
                        itemArray[n2].dispose();
                    }
                    ++n2;
                }
                itemArray = this.getMenuItems();
                n2 = 0;
                int n3 = 0;
                for (IContributionItem iContributionItem3 : arrayList) {
                    IContributionItem iContributionItem4 = n2 < itemArray.length ? (IContributionItem)itemArray[n2].getData() : null;
                    if (iContributionItem4 != null && iContributionItem3.equals(iContributionItem4)) {
                        ++n2;
                        ++n3;
                    } else if (iContributionItem4 != null && iContributionItem4.isSeparator() && iContributionItem3.isSeparator()) {
                        itemArray[n2].setData((Object)iContributionItem3);
                        ++n2;
                        ++n3;
                    } else {
                        int n4 = this.getMenuItemCount();
                        this.doItemFill(iContributionItem3, n3);
                        int n5 = this.getMenuItemCount() - n4;
                        int n6 = 0;
                        while (n6 < n5) {
                            Item item = this.getMenuItem(n3++);
                            item.setData((Object)iContributionItem3);
                            ++n6;
                        }
                    }
                    if (!bl2) continue;
                    IContributionItem iContributionItem5 = iContributionItem3;
                    if (iContributionItem5 instanceof SubContributionItem) {
                        iContributionItem5 = ((SubContributionItem)iContributionItem5).getInnerItem();
                    }
                    if (!(iContributionItem5 instanceof IMenuManager)) continue;
                    ((IMenuManager)iContributionItem5).updateAll(bl);
                }
                while (n2 < itemArray.length) {
                    itemArray[n2].dispose();
                    ++n2;
                }
                this.setDirty(false);
            }
        } else if (bl2) {
            IContributionItem[] iContributionItemArray = this.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IMenuManager iMenuManager;
                IContributionItem iContributionItem = iContributionItemArray[n];
                if (iContributionItem instanceof IMenuManager && this.isChildVisible(iMenuManager = (IMenuManager)iContributionItem)) {
                    iMenuManager.updateAll(bl);
                }
                ++n;
            }
        }
        this.updateMenuItem();
    }

    @Override
    public void update(String string) {
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].update(string);
            ++n;
        }
        if (this.menu != null && !this.menu.isDisposed() && this.menu.getParentItem() != null) {
            if ("text".equals(string)) {
                String string2 = this.getOverrides().getText(this);
                if (string2 == null) {
                    string2 = this.getMenuText();
                }
                if (string2 != null) {
                    char c;
                    int n2;
                    ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                    if (iCallback != null && (n2 = string2.indexOf(38)) >= 0 && n2 < string2.length() - 1 && iCallback.isAcceleratorInUse(0x10000 | (c = Character.toUpperCase(string2.charAt(n2 + 1)))) && this.isTopLevelMenu()) {
                        string2 = n2 == 0 ? string2.substring(1) : String.valueOf(string2.substring(0, n2)) + string2.substring(n2 + 1);
                    }
                    this.menu.getParentItem().setText(string2);
                }
            } else if ("image".equals(string) && this.image != null) {
                LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources());
                this.menu.getParentItem().setImage(localResourceManager.createImage(this.image));
                this.disposeOldImages();
                this.imageManager = localResourceManager;
            }
        }
    }

    private boolean isTopLevelMenu() {
        if (this.menu != null && !this.menu.isDisposed() && this.menuItem != null && !this.menuItem.isDisposed()) {
            Menu menu = this.menuItem.getParent();
            return menu != null && (menu.getStyle() & 2) == 2;
        }
        return false;
    }

    private void disposeOldImages() {
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }

    @Override
    public void updateAll(boolean bl) {
        this.update(bl, true);
    }

    private void updateMenuItem() {
        if (this.menuItem != null && !this.menuItem.isDisposed() && this.menuExist()) {
            boolean bl;
            boolean bl2 = bl = this.removeAllWhenShown || this.menu.getItemCount() > 0;
            if (this.menuItem.getEnabled() != bl) {
                Menu menu = this.menu;
                while (menu.getParentMenu() != null) {
                    menu = menu.getParentMenu();
                }
                if ((menu.getStyle() & 2) == 0) {
                    this.menuItem.setEnabled(bl);
                }
            }
        }
    }

    private boolean isChildVisible(IContributionItem iContributionItem) {
        Boolean bl = this.getOverrides().getVisible(iContributionItem);
        if (bl != null) {
            return bl;
        }
        return iContributionItem.isVisible();
    }
}

