/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Event;

public final class ExternalActionManager {
    private static ExternalActionManager instance;
    private ICallback callback;

    public static ExternalActionManager getInstance() {
        if (instance == null) {
            instance = new ExternalActionManager();
        }
        return instance;
    }

    private ExternalActionManager() {
    }

    public ICallback getCallback() {
        return this.callback;
    }

    public void setCallback(ICallback iCallback) {
        this.callback = iCallback;
    }

    public static class CommandCallback
    implements IBindingManagerListener,
    IBindingManagerCallback,
    IExecuteCallback {
        private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(ExternalActionManager.class.getName());
        private final IActiveChecker activeChecker;
        private final IExecuteApplicable applicabilityChecker;
        private final BindingManager bindingManager;
        private boolean bindingManagerListenerAttached = false;
        private final CommandManager commandManager;
        private final Set loggedCommandIds = new HashSet();
        private final Map registeredListeners = new HashMap();

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager) {
            this(bindingManager, commandManager, new IActiveChecker(){

                @Override
                public boolean isActive(String string) {
                    return true;
                }
            }, new IExecuteApplicable(){

                @Override
                public boolean isApplicable(IAction iAction) {
                    return true;
                }
            });
        }

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager, IActiveChecker iActiveChecker) {
            this(bindingManager, commandManager, iActiveChecker, new IExecuteApplicable(){

                @Override
                public boolean isApplicable(IAction iAction) {
                    return true;
                }
            });
        }

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager, IActiveChecker iActiveChecker, IExecuteApplicable iExecuteApplicable) {
            if (bindingManager == null) {
                throw new NullPointerException("The callback needs a binding manager");
            }
            if (commandManager == null) {
                throw new NullPointerException("The callback needs a command manager");
            }
            if (iActiveChecker == null) {
                throw new NullPointerException("The callback needs an active callback");
            }
            if (iExecuteApplicable == null) {
                throw new NullPointerException("The callback needs an applicable callback");
            }
            this.activeChecker = iActiveChecker;
            this.bindingManager = bindingManager;
            this.commandManager = commandManager;
            this.applicabilityChecker = iExecuteApplicable;
        }

        @Override
        public final void addPropertyChangeListener(String string, IPropertyChangeListener iPropertyChangeListener) {
            Object v = this.registeredListeners.get(string);
            if (v instanceof ListenerList) {
                ((ListenerList)v).add((Object)iPropertyChangeListener);
            } else if (v != null) {
                ListenerList listenerList = new ListenerList(1);
                listenerList.add(v);
                listenerList.add((Object)iPropertyChangeListener);
                this.registeredListeners.put(string, listenerList);
            } else {
                this.registeredListeners.put(string, iPropertyChangeListener);
            }
            if (!this.bindingManagerListenerAttached) {
                this.bindingManager.addBindingManagerListener(this);
                this.bindingManagerListenerAttached = true;
            }
        }

        @Override
        public final void bindingManagerChanged(BindingManagerEvent bindingManagerEvent) {
            if (bindingManagerEvent.isActiveBindingsChanged()) {
                for (Map.Entry entry : this.registeredListeners.entrySet()) {
                    Object[] objectArray;
                    String string = (String)entry.getKey();
                    Command command = this.commandManager.getCommand(string);
                    ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
                    if (!bindingManagerEvent.isActiveBindingsChangedFor(parameterizedCommand)) continue;
                    Object v = entry.getValue();
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(bindingManagerEvent.getManager(), "text", null, null);
                    if (v instanceof ListenerList) {
                        objectArray = ((ListenerList)v).getListeners();
                        int n = 0;
                        while (n < objectArray.length) {
                            IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
                            iPropertyChangeListener.propertyChange(propertyChangeEvent);
                            ++n;
                        }
                        continue;
                    }
                    objectArray = (Object[])v;
                    objectArray.propertyChange(propertyChangeEvent);
                }
            }
        }

        @Override
        public final Integer getAccelerator(String string) {
            Trigger trigger;
            Trigger[] triggerArray;
            TriggerSequence triggerSequence = this.bindingManager.getBestActiveBindingFor(string);
            if (triggerSequence != null && (triggerArray = triggerSequence.getTriggers()).length == 1 && (trigger = triggerArray[0]) instanceof KeyStroke) {
                KeyStroke keyStroke = (KeyStroke)trigger;
                int n = SWTKeySupport.convertKeyStrokeToAccelerator(keyStroke);
                return new Integer(n);
            }
            return null;
        }

        @Override
        public final String getAcceleratorText(String string) {
            TriggerSequence triggerSequence = this.bindingManager.getBestActiveBindingFor(string);
            if (triggerSequence == null) {
                return null;
            }
            return triggerSequence.format();
        }

        @Override
        public final TriggerSequence[] getActiveBindingsFor(String string) {
            return this.bindingManager.getActiveBindingsFor(string);
        }

        @Override
        public final boolean isAcceleratorInUse(int n) {
            KeySequence keySequence = KeySequence.getInstance(SWTKeySupport.convertAcceleratorToKeyStroke(n));
            return this.bindingManager.isPerfectMatch(keySequence) || this.bindingManager.isPartialMatch(keySequence);
        }

        @Override
        public final boolean isActive(final String string) {
            if (string != null) {
                final Command command = this.commandManager.getCommand(string);
                if (!command.isDefined() && !this.loggedCommandIds.contains(string)) {
                    String string2 = MessageFormat.format(Util.translateString(RESOURCE_BUNDLE, "undefinedCommand.WarningMessage", null), command.getId());
                    Status status = new Status(4, "org.eclipse.jface", 0, string2, (Throwable)new Exception());
                    Policy.getLog().log((IStatus)status);
                    this.loggedCommandIds.add(string);
                    command.addCommandListener(new ICommandListener(){

                        public final void commandChanged(CommandEvent commandEvent) {
                            if (command.isDefined()) {
                                command.removeCommandListener((ICommandListener)this);
                                CommandCallback.this.loggedCommandIds.remove(string);
                            }
                        }
                    });
                    return true;
                }
                return this.activeChecker.isActive(string);
            }
            return true;
        }

        @Override
        public final void removePropertyChangeListener(String string, IPropertyChangeListener iPropertyChangeListener) {
            Object v = this.registeredListeners.get(string);
            if (v == iPropertyChangeListener) {
                this.registeredListeners.remove(string);
                if (this.registeredListeners.isEmpty()) {
                    this.bindingManager.removeBindingManagerListener(this);
                    this.bindingManagerListenerAttached = false;
                }
            } else if (v instanceof ListenerList) {
                ListenerList listenerList = (ListenerList)v;
                listenerList.remove((Object)iPropertyChangeListener);
                if (listenerList.size() == 1) {
                    this.registeredListeners.put(string, listenerList.getListeners()[0]);
                }
            }
        }

        @Override
        public void preExecute(IAction iAction, Event event) {
            String string = iAction.getActionDefinitionId();
            if (string == null || !this.applicabilityChecker.isApplicable(iAction)) {
                return;
            }
            Command command = this.commandManager.getCommand(string);
            ExecutionEvent executionEvent = new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)event, null);
            this.commandManager.firePreExecute(string, executionEvent);
        }

        @Override
        public void postExecuteSuccess(IAction iAction, Object object) {
            String string = iAction.getActionDefinitionId();
            if (string == null || !this.applicabilityChecker.isApplicable(iAction)) {
                return;
            }
            this.commandManager.firePostExecuteSuccess(string, object);
        }

        @Override
        public void postExecuteFailure(IAction iAction, ExecutionException executionException) {
            String string = iAction.getActionDefinitionId();
            if (string == null || !this.applicabilityChecker.isApplicable(iAction)) {
                return;
            }
            this.commandManager.firePostExecuteFailure(string, executionException);
        }

        @Override
        public void notDefined(IAction iAction, NotDefinedException notDefinedException) {
            String string = iAction.getActionDefinitionId();
            if (string == null || !this.applicabilityChecker.isApplicable(iAction)) {
                return;
            }
            this.commandManager.fireNotDefined(string, notDefinedException);
        }

        @Override
        public void notEnabled(IAction iAction, NotEnabledException notEnabledException) {
            String string = iAction.getActionDefinitionId();
            if (string == null || !this.applicabilityChecker.isApplicable(iAction)) {
                return;
            }
            this.commandManager.fireNotEnabled(string, notEnabledException);
        }
    }

    public static interface IActiveChecker {
        public boolean isActive(String var1);
    }

    public static interface IBindingManagerCallback
    extends ICallback {
        public TriggerSequence[] getActiveBindingsFor(String var1);
    }

    public static interface ICallback {
        public void addPropertyChangeListener(String var1, IPropertyChangeListener var2);

        public Integer getAccelerator(String var1);

        public String getAcceleratorText(String var1);

        public boolean isAcceleratorInUse(int var1);

        public boolean isActive(String var1);

        public void removePropertyChangeListener(String var1, IPropertyChangeListener var2);
    }

    public static interface IExecuteApplicable {
        public boolean isApplicable(IAction var1);
    }

    public static interface IExecuteCallback {
        public void notEnabled(IAction var1, NotEnabledException var2);

        public void notDefined(IAction var1, NotDefinedException var2);

        public void preExecute(IAction var1, Event var2);

        public void postExecuteSuccess(IAction var1, Object var2);

        public void postExecuteFailure(IAction var1, ExecutionException var2);
    }
}

