/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Menu;

public class CoolBarManager
extends ContributionManager
implements ICoolBarManager {
    public static final String USER_SEPARATOR = "UserSeparator";
    private ArrayList cbItemsCreationOrder = new ArrayList();
    private MenuManager contextMenuManager = null;
    private CoolBar coolBar = null;
    private int itemStyle = 0;

    public CoolBarManager() {
    }

    public CoolBarManager(CoolBar coolBar) {
        this();
        Assert.isNotNull((Object)coolBar);
        this.coolBar = coolBar;
        this.itemStyle = coolBar.getStyle();
    }

    public CoolBarManager(int n) {
        this.itemStyle = n;
    }

    @Override
    public void add(IToolBarManager iToolBarManager) {
        Assert.isNotNull((Object)iToolBarManager);
        super.add(new ToolBarContributionItem(iToolBarManager));
    }

    private ArrayList adjustContributionList(ArrayList arrayList) {
        if (arrayList.size() != 0) {
            IContributionItem iContributionItem = (IContributionItem)arrayList.get(0);
            if (iContributionItem.isSeparator()) {
                arrayList.remove(0);
            }
            ListIterator listIterator = arrayList.listIterator();
            block0: while (listIterator.hasNext()) {
                iContributionItem = (IContributionItem)listIterator.next();
                if (!iContributionItem.isSeparator()) continue;
                while (listIterator.hasNext()) {
                    iContributionItem = (IContributionItem)listIterator.next();
                    if (!iContributionItem.isSeparator()) continue block0;
                    listIterator.remove();
                }
            }
            if (arrayList.size() != 0 && (iContributionItem = (IContributionItem)arrayList.get(arrayList.size() - 1)).isSeparator()) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        return arrayList;
    }

    @Override
    protected boolean allowItem(IContributionItem iContributionItem) {
        if (iContributionItem == null) {
            return true;
        }
        String string = iContributionItem.getId();
        if (string == null) {
            return true;
        }
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            String string2;
            IContributionItem iContributionItem2 = iContributionItemArray[n];
            if (iContributionItem2 != null && string.equals(string2 = iContributionItem2.getId())) {
                if (Policy.TRACE_TOOLBAR) {
                    System.out.println("Trying to add a duplicate item.");
                    new Exception().printStackTrace(System.out);
                    System.out.println("DONE --------------------------");
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    private void collapseSeparators(ListIterator listIterator) {
        while (listIterator.hasNext()) {
            IContributionItem iContributionItem = (IContributionItem)listIterator.next();
            if (iContributionItem.isSeparator()) continue;
            listIterator.previous();
            return;
        }
    }

    private boolean coolBarExist() {
        return this.coolBar != null && !this.coolBar.isDisposed();
    }

    public CoolBar createControl(Composite composite) {
        Assert.isNotNull((Object)composite);
        if (!this.coolBarExist()) {
            this.coolBar = new CoolBar(composite, this.itemStyle);
            this.coolBar.setMenu(this.getContextMenuControl());
            this.coolBar.setLocked(false);
            this.update(false);
        }
        return this.coolBar;
    }

    public void dispose() {
        if (this.coolBarExist()) {
            this.coolBar.dispose();
            this.coolBar = null;
        }
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            iContributionItemArray[n].dispose();
            ++n;
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
            this.contextMenuManager = null;
        }
    }

    private void dispose(CoolItem coolItem) {
        if (coolItem != null && !coolItem.isDisposed()) {
            coolItem.setData(null);
            Control control = coolItem.getControl();
            if (control != null && !control.isDisposed()) {
                coolItem.setControl(null);
                control.dispose();
            }
            coolItem.dispose();
        }
    }

    private CoolItem findCoolItem(IContributionItem iContributionItem) {
        CoolItem[] coolItemArray = this.coolBar == null ? null : this.coolBar.getItems();
        return this.findCoolItem(coolItemArray, iContributionItem);
    }

    private CoolItem findCoolItem(CoolItem[] coolItemArray, IContributionItem iContributionItem) {
        if (coolItemArray == null) {
            return null;
        }
        int n = 0;
        while (n < coolItemArray.length) {
            CoolItem coolItem = coolItemArray[n];
            IContributionItem iContributionItem2 = (IContributionItem)coolItem.getData();
            if (iContributionItem2 != null && iContributionItem2.equals(iContributionItem)) {
                return coolItem;
            }
            ++n;
        }
        return null;
    }

    private int[] getAdjustedWrapIndices(int[] nArray) {
        int[] nArray2;
        if (nArray.length == 0) {
            nArray2 = new int[1];
        } else if (nArray[0] != 0) {
            nArray2 = new int[nArray.length + 1];
            nArray2[0] = 0;
            int n = 0;
            while (n < nArray.length) {
                nArray2[n + 1] = nArray[n];
                ++n;
            }
        } else {
            nArray2 = nArray;
        }
        return nArray2;
    }

    private Menu getContextMenuControl() {
        if (this.contextMenuManager != null && this.coolBar != null) {
            Menu menu = this.contextMenuManager.getMenu();
            if (menu == null || menu.isDisposed()) {
                menu = this.contextMenuManager.createContextMenu((Control)this.coolBar);
            }
            return menu;
        }
        return null;
    }

    @Override
    public IMenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public CoolBar getControl() {
        return this.coolBar;
    }

    private ArrayList getItemList() {
        IContributionItem[] iContributionItemArray = this.getItems();
        ArrayList<IContributionItem> arrayList = new ArrayList<IContributionItem>(iContributionItemArray.length);
        int n = 0;
        while (n < iContributionItemArray.length) {
            arrayList.add(iContributionItemArray[n]);
            ++n;
        }
        return arrayList;
    }

    @Override
    public boolean getLockLayout() {
        if (!this.coolBarExist()) {
            return false;
        }
        return this.coolBar.getLocked();
    }

    private int getNumRows(IContributionItem[] iContributionItemArray) {
        int n = 1;
        boolean bl = false;
        int n2 = 0;
        while (n2 < iContributionItemArray.length) {
            if (iContributionItemArray[n2].isSeparator()) {
                bl = true;
            }
            if (bl && this.isChildVisible(iContributionItemArray[n2]) && !iContributionItemArray[n2].isGroupMarker() && !iContributionItemArray[n2].isSeparator()) {
                ++n;
                bl = false;
            }
            ++n2;
        }
        return n;
    }

    @Override
    public int getStyle() {
        return this.itemStyle;
    }

    @Override
    protected void itemAdded(IContributionItem iContributionItem) {
        Assert.isNotNull((Object)iContributionItem);
        super.itemAdded(iContributionItem);
        int n = this.indexOf(iContributionItem);
        boolean bl = false;
        int n2 = this.cbItemsCreationOrder.size();
        int n3 = 0;
        while (n3 < n2) {
            IContributionItem iContributionItem2 = (IContributionItem)this.cbItemsCreationOrder.get(n3);
            if (iContributionItem2.getId() != null && iContributionItem2.getId().equals(iContributionItem.getId())) {
                this.cbItemsCreationOrder.set(n3, iContributionItem);
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl) {
            this.cbItemsCreationOrder.add(Math.min(Math.max(n, 0), this.cbItemsCreationOrder.size()), iContributionItem);
        }
    }

    @Override
    protected void itemRemoved(IContributionItem iContributionItem) {
        Assert.isNotNull((Object)iContributionItem);
        super.itemRemoved(iContributionItem);
        CoolItem coolItem = this.findCoolItem(iContributionItem);
        if (coolItem != null) {
            coolItem.setData(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void nextRow(ListIterator var1_1, boolean var2_2) {
        var3_3 = null;
        if (!var2_2 && var1_1.hasPrevious()) {
            var3_3 = (IContributionItem)var1_1.previous();
            var1_1.next();
        }
        if (var3_3 == null || !var3_3.isSeparator()) ** GOTO lbl13
        this.collapseSeparators(var1_1);
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = (IContributionItem)var1_1.next();
            if (!var4_4.isSeparator()) continue;
            this.collapseSeparators(var1_1);
            return;
lbl13:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl14:
        // 1 sources

    }

    /*
     * Exception decompiling
     */
    public void refresh() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void relocate(IContributionItem iContributionItem, int n, ArrayList arrayList, HashMap hashMap) {
        if (!(hashMap.get(iContributionItem) instanceof Integer)) {
            return;
        }
        int n2 = (Integer)hashMap.get(iContributionItem);
        int n3 = arrayList.indexOf(iContributionItem);
        int n4 = arrayList.size();
        ListIterator listIterator = arrayList.listIterator();
        this.collapseSeparators(listIterator);
        int n5 = -1;
        while (listIterator.hasNext()) {
            if (++n5 == n2) {
                int n6 = 0;
                n4 = listIterator.nextIndex();
                while (listIterator.hasNext()) {
                    IContributionItem iContributionItem2 = (IContributionItem)listIterator.next();
                    Integer n7 = (Integer)hashMap.get(iContributionItem2);
                    if (iContributionItem2.isSeparator()) break;
                    if (n7 != null && n7 == n2) {
                        if (n6 >= n) break;
                        ++n6;
                    }
                    ++n4;
                }
                if (n3 != n4) break;
                return;
            }
            this.nextRow(listIterator, true);
        }
        arrayList.remove(iContributionItem);
        if (n3 < n4) {
            --n4;
        }
        if (n5 != n2) {
            arrayList.add(new Separator(USER_SEPARATOR));
            n4 = arrayList.size();
        }
        n4 = Math.min(n4, arrayList.size());
        arrayList.add(n4, iContributionItem);
    }

    public void resetItemOrder() {
        IContributionItem[] iContributionItemArray = this.cbItemsCreationOrder.listIterator();
        while (iContributionItemArray.hasNext()) {
            IContributionItem iContributionItem = (IContributionItem)iContributionItemArray.next();
            if (iContributionItem.getId() == null || !iContributionItem.getId().equals(USER_SEPARATOR)) continue;
            iContributionItemArray.remove();
        }
        iContributionItemArray = new IContributionItem[this.cbItemsCreationOrder.size()];
        this.cbItemsCreationOrder.toArray(iContributionItemArray);
        this.setItems(iContributionItemArray);
    }

    @Override
    public void setContextMenuManager(IMenuManager iMenuManager) {
        this.contextMenuManager = (MenuManager)iMenuManager;
        if (this.coolBar != null) {
            this.coolBar.setMenu(this.getContextMenuControl());
        }
    }

    public void setItems(IContributionItem[] iContributionItemArray) {
        if (this.coolBar != null) {
            CoolItem[] coolItemArray = this.coolBar.getItems();
            int n = 0;
            while (n < coolItemArray.length) {
                this.dispose(coolItemArray[n]);
                ++n;
            }
        }
        this.internalSetItems(iContributionItemArray);
        this.update(true);
    }

    @Override
    public void setLockLayout(boolean bl) {
        if (!this.coolBarExist()) {
            return;
        }
        this.coolBar.setLocked(bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(boolean bl) {
        if (!this.isDirty() && !bl || !this.coolBarExist()) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            int n;
            void var8_12;
            Object object;
            void iContributionItem;
            Object object2;
            this.coolBar.setRedraw(false);
            this.refresh();
            if (this.coolBar.getLocked()) {
                this.coolBar.setLocked(false);
                bl2 = true;
            }
            IContributionItem[] iContributionItemArray = this.getItems();
            ArrayList<Object> arrayList = new ArrayList<Object>(iContributionItemArray.length);
            int n2 = 0;
            while (n2 < iContributionItemArray.length) {
                object2 = iContributionItemArray[n2];
                if (this.isChildVisible((IContributionItem)object2)) {
                    arrayList.add(object2);
                }
                ++n2;
            }
            CoolItem[] coolItemArray = this.coolBar.getItems();
            object2 = new ArrayList(coolItemArray.length);
            boolean n3 = false;
            while (iContributionItem < coolItemArray.length) {
                object = coolItemArray[iContributionItem].getData();
                if (object == null || !arrayList.contains(object) || object instanceof IContributionItem && ((IContributionItem)object).isDynamic()) {
                    ((ArrayList)object2).add(coolItemArray[iContributionItem]);
                }
                ++iContributionItem;
            }
            int n4 = ((ArrayList)object2).size() - 1;
            while (var8_12 >= 0) {
                object = (CoolItem)((ArrayList)object2).get((int)var8_12);
                if (!object.isDisposed()) {
                    Control control = object.getControl();
                    if (control != null) {
                        object.setControl(null);
                        control.dispose();
                    }
                    object.dispose();
                }
                --var8_12;
            }
            coolItemArray = this.coolBar.getItems();
            int n5 = 0;
            int n6 = 0;
            for (IContributionItem iContributionItem2 : arrayList) {
                IToolBarManager iToolBarManager;
                object = n5 < coolItemArray.length ? (IContributionItem)coolItemArray[n5].getData() : null;
                if (object != null) {
                    if (iContributionItem2.equals(object)) {
                        ++n5;
                        ++n6;
                        iContributionItem2.update();
                        continue;
                    }
                    if (object.isSeparator() && iContributionItem2.isSeparator()) {
                        coolItemArray[n5].setData((Object)iContributionItem2);
                        ++n5;
                        ++n6;
                        iContributionItem2.update();
                        continue;
                    }
                }
                n = this.coolBar.getItemCount();
                if (iContributionItem2 instanceof ToolBarContributionItem && (iToolBarManager = ((ToolBarContributionItem)iContributionItem2).getToolBarManager()) instanceof IToolBarManager2) {
                    ((IToolBarManager2)iToolBarManager).setOverrides(this.getOverrides());
                }
                iContributionItem2.fill(this.coolBar, n6);
                int iContributionItem3 = this.coolBar.getItemCount() - n;
                int n7 = 0;
                while (n7 < iContributionItem3) {
                    this.coolBar.getItem(n6++).setData((Object)iContributionItem2);
                    ++n7;
                }
                bl3 = true;
            }
            n = coolItemArray.length - 1;
            while (n >= n5) {
                CoolItem coolItem = coolItemArray[n];
                if (!coolItem.isDisposed()) {
                    Control control = coolItem.getControl();
                    if (control != null) {
                        coolItem.setControl(null);
                        control.dispose();
                    }
                    coolItem.dispose();
                    bl3 = true;
                }
                --n;
            }
            this.updateWrapIndices();
            n = 0;
            while (n < iContributionItemArray.length) {
                IContributionItem iContributionItem4 = iContributionItemArray[n];
                iContributionItem4.update("size");
                ++n;
            }
            if (bl2) {
                this.coolBar.setLocked(true);
            }
            if (bl3) {
                this.updateTabOrder();
            }
            this.setDirty(false);
        }
        finally {
            this.coolBar.setRedraw(true);
        }
    }

    void updateTabOrder() {
        CoolItem[] coolItemArray;
        if (this.coolBar != null && (coolItemArray = this.coolBar.getItems()) != null) {
            ArrayList<Control> arrayList = new ArrayList<Control>(coolItemArray.length);
            int n = 0;
            while (n < coolItemArray.length) {
                if (coolItemArray[n].getControl() != null && !coolItemArray[n].getControl().isDisposed()) {
                    arrayList.add(coolItemArray[n].getControl());
                }
                ++n;
            }
            Control[] controlArray = new Control[]{};
            if ((controlArray = arrayList.toArray(controlArray)) != null) {
                this.coolBar.setTabList(controlArray);
            }
        }
    }

    private void updateWrapIndices() {
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = this.getNumRows(iContributionItemArray) - 1;
        int[] nArray = new int[n];
        boolean bl = false;
        int n2 = 0;
        CoolItem[] coolItemArray = this.coolBar == null ? null : this.coolBar.getItems();
        int n3 = 0;
        while (n3 < iContributionItemArray.length) {
            IContributionItem iContributionItem = iContributionItemArray[n3];
            CoolItem coolItem = this.findCoolItem(coolItemArray, iContributionItem);
            if (iContributionItem.isSeparator()) {
                bl = true;
            }
            if (!iContributionItem.isSeparator() && !iContributionItem.isGroupMarker() && this.isChildVisible(iContributionItem) && coolItem != null && bl) {
                nArray[n2] = this.coolBar.indexOf(coolItem);
                ++n2;
                bl = false;
            }
            ++n3;
        }
        int[] nArray2 = this.coolBar.getWrapIndices();
        boolean bl2 = false;
        if (nArray2.length == nArray.length) {
            int n4 = 0;
            while (n4 < nArray2.length) {
                if (nArray2[n4] != nArray[n4]) {
                    bl2 = true;
                    break;
                }
                ++n4;
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            this.coolBar.setWrapIndices(nArray);
        }
    }

    private boolean isChildVisible(IContributionItem iContributionItem) {
        IContributionManagerOverrides iContributionManagerOverrides = this.getOverrides();
        Boolean bl = iContributionManagerOverrides == null ? null : this.getOverrides().getVisible(iContributionItem);
        if (bl != null) {
            return bl;
        }
        return iContributionItem.isVisible();
    }
}

