/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.util.Policy;

public abstract class ContributionManager
implements IContributionManager {
    private List contributions = new ArrayList();
    private boolean isDirty = true;
    private int dynamicItems = 0;
    private IContributionManagerOverrides overrides;

    protected ContributionManager() {
    }

    @Override
    public void add(IAction iAction) {
        Assert.isNotNull((Object)iAction, (String)"Action must not be null");
        this.add(new ActionContributionItem(iAction));
    }

    @Override
    public void add(IContributionItem iContributionItem) {
        Assert.isNotNull((Object)iContributionItem, (String)"Item must not be null");
        if (this.allowItem(iContributionItem)) {
            this.contributions.add(iContributionItem);
            this.itemAdded(iContributionItem);
        }
    }

    private void addToGroup(String string, IContributionItem iContributionItem, boolean bl) {
        Iterator iterator = this.contributions.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2;
            IContributionItem iContributionItem2 = (IContributionItem)iterator.next();
            if (iContributionItem2.isGroupMarker() && (string2 = iContributionItem2.getId()) != null && string2.equalsIgnoreCase(string)) {
                ++n;
                if (bl) {
                    while (iterator.hasNext()) {
                        IContributionItem iContributionItem3 = (IContributionItem)iterator.next();
                        if (iContributionItem3.isGroupMarker()) break;
                        ++n;
                    }
                }
                if (this.allowItem(iContributionItem)) {
                    this.contributions.add(n, iContributionItem);
                    this.itemAdded(iContributionItem);
                }
                return;
            }
            ++n;
        }
        throw new IllegalArgumentException("Group not found: " + string);
    }

    @Override
    public void appendToGroup(String string, IAction iAction) {
        this.addToGroup(string, new ActionContributionItem(iAction), true);
    }

    @Override
    public void appendToGroup(String string, IContributionItem iContributionItem) {
        this.addToGroup(string, iContributionItem, true);
    }

    protected boolean allowItem(IContributionItem iContributionItem) {
        return true;
    }

    protected void dumpStatistics() {
        int n = 0;
        if (this.contributions != null) {
            n = this.contributions.size();
        }
        System.out.println(this.toString());
        System.out.println("   Number of elements: " + n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (((IContributionItem)this.contributions.get(n3)).isVisible()) {
                ++n2;
            }
            ++n3;
        }
        System.out.println("   Number of visible elements: " + n2);
        System.out.println("   Is dirty: " + this.isDirty());
    }

    @Override
    public IContributionItem find(String string) {
        for (IContributionItem iContributionItem : this.contributions) {
            String string2 = iContributionItem.getId();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return iContributionItem;
        }
        return null;
    }

    @Override
    public IContributionItem[] getItems() {
        IContributionItem[] iContributionItemArray = new IContributionItem[this.contributions.size()];
        this.contributions.toArray(iContributionItemArray);
        return iContributionItemArray;
    }

    public int getSize() {
        return this.contributions.size();
    }

    @Override
    public IContributionManagerOverrides getOverrides() {
        if (this.overrides == null) {
            this.overrides = new IContributionManagerOverrides(){

                @Override
                public Boolean getEnabled(IContributionItem iContributionItem) {
                    return null;
                }

                @Override
                public Integer getAccelerator(IContributionItem iContributionItem) {
                    return null;
                }

                @Override
                public String getAcceleratorText(IContributionItem iContributionItem) {
                    return null;
                }

                @Override
                public String getText(IContributionItem iContributionItem) {
                    return null;
                }

                @Override
                public Boolean getVisible(IContributionItem iContributionItem) {
                    return null;
                }
            };
        }
        return this.overrides;
    }

    protected boolean hasDynamicItems() {
        return this.dynamicItems > 0;
    }

    public int indexOf(String string) {
        int n = 0;
        while (n < this.contributions.size()) {
            IContributionItem iContributionItem = (IContributionItem)this.contributions.get(n);
            String string2 = iContributionItem.getId();
            if (string2 != null && string2.equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int indexOf(IContributionItem iContributionItem) {
        return this.contributions.indexOf(iContributionItem);
    }

    public void insert(int n, IContributionItem iContributionItem) {
        if (n > this.contributions.size()) {
            throw new IndexOutOfBoundsException("inserting " + iContributionItem.getId() + " at " + n);
        }
        if (this.allowItem(iContributionItem)) {
            this.contributions.add(n, iContributionItem);
            this.itemAdded(iContributionItem);
        }
    }

    @Override
    public void insertAfter(String string, IAction iAction) {
        this.insertAfter(string, new ActionContributionItem(iAction));
    }

    @Override
    public void insertAfter(String string, IContributionItem iContributionItem) {
        IContributionItem iContributionItem2 = this.find(string);
        if (iContributionItem2 == null) {
            throw new IllegalArgumentException("can't find ID" + string);
        }
        int n = this.contributions.indexOf(iContributionItem2);
        if (n >= 0 && this.allowItem(iContributionItem)) {
            this.contributions.add(n + 1, iContributionItem);
            this.itemAdded(iContributionItem);
        }
    }

    @Override
    public void insertBefore(String string, IAction iAction) {
        this.insertBefore(string, new ActionContributionItem(iAction));
    }

    @Override
    public void insertBefore(String string, IContributionItem iContributionItem) {
        IContributionItem iContributionItem2 = this.find(string);
        if (iContributionItem2 == null) {
            throw new IllegalArgumentException("can't find ID " + string);
        }
        int n = this.contributions.indexOf(iContributionItem2);
        if (n >= 0 && this.allowItem(iContributionItem)) {
            this.contributions.add(n, iContributionItem);
            this.itemAdded(iContributionItem);
        }
    }

    @Override
    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        if (this.hasDynamicItems()) {
            for (IContributionItem iContributionItem : this.contributions) {
                if (!iContributionItem.isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.contributions.isEmpty();
    }

    protected void itemAdded(IContributionItem iContributionItem) {
        iContributionItem.setParent(this);
        this.markDirty();
        if (iContributionItem.isDynamic()) {
            ++this.dynamicItems;
        }
    }

    protected void itemRemoved(IContributionItem iContributionItem) {
        iContributionItem.setParent(null);
        this.markDirty();
        if (iContributionItem.isDynamic()) {
            --this.dynamicItems;
        }
    }

    @Override
    public void markDirty() {
        this.setDirty(true);
    }

    @Override
    public void prependToGroup(String string, IAction iAction) {
        this.addToGroup(string, new ActionContributionItem(iAction), false);
    }

    @Override
    public void prependToGroup(String string, IContributionItem iContributionItem) {
        this.addToGroup(string, iContributionItem, false);
    }

    @Override
    public IContributionItem remove(String string) {
        IContributionItem iContributionItem = this.find(string);
        if (iContributionItem == null) {
            return null;
        }
        return this.remove(iContributionItem);
    }

    @Override
    public IContributionItem remove(IContributionItem iContributionItem) {
        if (this.contributions.remove(iContributionItem)) {
            this.itemRemoved(iContributionItem);
            return iContributionItem;
        }
        return null;
    }

    @Override
    public void removeAll() {
        IContributionItem[] iContributionItemArray = this.getItems();
        this.contributions.clear();
        int n = 0;
        while (n < iContributionItemArray.length) {
            IContributionItem iContributionItem = iContributionItemArray[n];
            this.itemRemoved(iContributionItem);
            ++n;
        }
        this.dynamicItems = 0;
        this.markDirty();
    }

    public boolean replaceItem(String string, IContributionItem iContributionItem) {
        if (string == null) {
            return false;
        }
        int n = this.indexOf(string);
        if (n < 0) {
            return false;
        }
        IContributionItem iContributionItem2 = (IContributionItem)this.contributions.get(n);
        this.itemRemoved(iContributionItem2);
        this.contributions.set(n, iContributionItem);
        this.itemAdded(iContributionItem);
        int n2 = this.contributions.size() - 1;
        while (n2 > n) {
            IContributionItem iContributionItem3 = (IContributionItem)this.contributions.get(n2);
            if (iContributionItem3 != null && string.equals(iContributionItem3.getId())) {
                if (Policy.TRACE_TOOLBAR) {
                    System.out.println("Removing duplicate on replace: " + string);
                }
                this.contributions.remove(n2);
                this.itemRemoved(iContributionItem3);
            }
            --n2;
        }
        return true;
    }

    protected void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public void setOverrides(IContributionManagerOverrides iContributionManagerOverrides) {
        this.overrides = iContributionManagerOverrides;
    }

    protected void internalSetItems(IContributionItem[] iContributionItemArray) {
        this.contributions.clear();
        int n = 0;
        while (n < iContributionItemArray.length) {
            if (this.allowItem(iContributionItemArray[n])) {
                this.contributions.add(iContributionItemArray[n]);
            }
            ++n;
        }
    }
}

