/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ActionContributionItem
extends ContributionItem {
    public static int MODE_FORCE_TEXT = 1;
    private static final String ellipsis = "...";
    private Boolean result = null;
    private static boolean USE_COLOR_ICONS = true;
    private int mode = 0;
    private IAction action;
    private final IPropertyChangeListener actionTextListener = new IPropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ActionContributionItem.this.update(propertyChangeEvent.getProperty());
        }
    };
    private LocalResourceManager imageManager;
    private Listener buttonListener;
    private Listener menuItemListener;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ActionContributionItem.this.actionPropertyChange(propertyChangeEvent);
        }
    };
    private Listener toolItemListener;
    private Widget widget = null;
    private Listener menuCreatorListener;
    private Menu holdMenu = null;
    private boolean menuCreatorCalled = false;

    public static boolean getUseColorIconsInToolbars() {
        return USE_COLOR_ICONS;
    }

    public static void setUseColorIconsInToolbars(boolean bl) {
        USE_COLOR_ICONS = bl;
    }

    public ActionContributionItem(IAction iAction) {
        super(iAction.getId());
        this.action = iAction;
    }

    private void actionPropertyChange(final PropertyChangeEvent propertyChangeEvent) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(propertyChangeEvent.getProperty());
            } else {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ActionContributionItem.this.update(propertyChangeEvent.getProperty());
                    }
                });
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActionContributionItem)) {
            return false;
        }
        return this.action.equals(((ActionContributionItem)object).action);
    }

    @Override
    public void fill(Composite composite) {
        if (this.widget == null && composite != null) {
            int n = 8;
            if (this.action != null) {
                if (this.action.getStyle() == 2) {
                    n = 2;
                }
                if (this.action.getStyle() == 8) {
                    n = 16;
                }
            }
            Button button = new Button(composite, n);
            button.setData((Object)this);
            button.addListener(12, this.getButtonListener());
            button.addListener(13, this.getButtonListener());
            if (this.action.getHelpListener() != null) {
                button.addHelpListener(this.action.getHelpListener());
            }
            this.widget = button;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String string = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                if (iCallback != null && string != null) {
                    iCallback.addPropertyChangeListener(string, this.actionTextListener);
                }
            }
        }
    }

    @Override
    public void fill(Menu menu, int n) {
        if (this.widget == null && menu != null) {
            Object object;
            int n2 = 8;
            if (this.action != null) {
                int n3 = this.action.getStyle();
                if (n3 == 2) {
                    n2 = 32;
                } else if (n3 == 8) {
                    n2 = 16;
                } else if (n3 == 4) {
                    n2 = 64;
                }
            }
            MenuItem menuItem = null;
            menuItem = n >= 0 ? new MenuItem(menu, n2, n) : new MenuItem(menu, n2);
            this.widget = menuItem;
            menuItem.setData((Object)this);
            menuItem.addListener(12, this.getMenuItemListener());
            menuItem.addListener(13, this.getMenuItemListener());
            if (this.action.getHelpListener() != null) {
                menuItem.addHelpListener(this.action.getHelpListener());
            }
            if (n2 == 64) {
                object = new Menu(menu);
                object.addListener(22, this.getMenuCreatorListener());
                object.addListener(23, this.getMenuCreatorListener());
                menuItem.setMenu(object);
            }
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                object = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                if (iCallback != null && object != null) {
                    iCallback.addPropertyChangeListener((String)object, this.actionTextListener);
                }
            }
        }
    }

    @Override
    public void fill(ToolBar toolBar, int n) {
        if (this.widget == null && toolBar != null) {
            int n2 = 8;
            if (this.action != null) {
                int n3 = this.action.getStyle();
                if (n3 == 2) {
                    n2 = 32;
                } else if (n3 == 8) {
                    n2 = 16;
                } else if (n3 == 4) {
                    n2 = 4;
                }
            }
            ToolItem toolItem = null;
            toolItem = n >= 0 ? new ToolItem(toolBar, n2, n) : new ToolItem(toolBar, n2);
            toolItem.setData((Object)this);
            toolItem.addListener(13, this.getToolItemListener());
            toolItem.addListener(12, this.getToolItemListener());
            this.widget = toolItem;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String string = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                if (iCallback != null && string != null) {
                    iCallback.addPropertyChangeListener(string, this.actionTextListener);
                }
            }
        }
    }

    public IAction getAction() {
        return this.action;
    }

    private Listener getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget widget = event.widget;
                            if (widget == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((Button)widget).getSelection());
                        }
                    }
                }
            };
        }
        return this.buttonListener;
    }

    private Listener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget widget = event.widget;
                            if (widget == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((MenuItem)widget).getSelection());
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    public int getMode() {
        return this.mode;
    }

    private Listener getToolItemListener() {
        if (this.toolItemListener == null) {
            this.toolItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ActionContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget widget = event.widget;
                            if (widget == null) break;
                            ActionContributionItem.this.handleWidgetSelection(event, ((ToolItem)widget).getSelection());
                        }
                    }
                }
            };
        }
        return this.toolItemListener;
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            Object object;
            if (this.action.getStyle() == 4 && this.menuCreatorCalled && (object = this.action.getMenuCreator()) != null) {
                object.dispose();
            }
            this.action.removePropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                object = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                if (iCallback != null && object != null) {
                    iCallback.removePropertyChangeListener((String)object, this.actionTextListener);
                }
            }
            this.widget = null;
            this.disposeOldImages();
        }
    }

    private void handleWidgetSelection(Event event, boolean bl) {
        Widget widget = event.widget;
        if (widget != null) {
            ExternalActionManager.ICallback iCallback;
            String string;
            Object object;
            int n = widget.getStyle();
            if ((n & 0x22) != 0) {
                if (this.action.getStyle() == 2) {
                    this.action.setChecked(bl);
                }
            } else if ((n & 0x10) != 0) {
                if (this.action.getStyle() == 8) {
                    this.action.setChecked(bl);
                }
            } else if ((n & 4) != 0 && event.detail == 4 && this.action.getStyle() == 4) {
                object = this.action.getMenuCreator();
                this.menuCreatorCalled = true;
                string = (ToolItem)widget;
                if (object != null && (iCallback = object.getMenu((Control)string.getParent())) != null) {
                    Rectangle rectangle = string.getBounds();
                    Point point = string.getParent().toDisplay(new Point(rectangle.x, rectangle.y + rectangle.height));
                    iCallback.setLocation(point.x, point.y);
                    iCallback.setVisible(true);
                    return;
                }
            }
            object = null;
            string = this.action.getActionDefinitionId();
            if (string != null && (iCallback = ExternalActionManager.getInstance().getCallback()) instanceof ExternalActionManager.IExecuteCallback) {
                object = (ExternalActionManager.IExecuteCallback)((Object)iCallback);
            }
            if (this.action.isEnabled()) {
                boolean bl2 = Policy.TRACE_ACTIONS;
                long l = 0L;
                if (bl2) {
                    l = System.currentTimeMillis();
                    System.out.println("Running action: " + this.action.getText());
                }
                IPropertyChangeListener iPropertyChangeListener = null;
                if (object != null) {
                    iPropertyChangeListener = new IPropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (propertyChangeEvent.getProperty().equals("result") && propertyChangeEvent.getNewValue() instanceof Boolean) {
                                ActionContributionItem.this.result = (Boolean)propertyChangeEvent.getNewValue();
                            }
                        }
                    };
                    this.action.addPropertyChangeListener(iPropertyChangeListener);
                    object.preExecute(this.action, event);
                }
                this.action.runWithEvent(event);
                if (object != null) {
                    if (this.result == null || this.result.equals(Boolean.TRUE)) {
                        object.postExecuteSuccess(this.action, Boolean.TRUE);
                    } else {
                        object.postExecuteFailure(this.action, new ExecutionException(String.valueOf(this.action.getText()) + " returned failure."));
                    }
                }
                if (iPropertyChangeListener != null) {
                    this.result = null;
                    this.action.removePropertyChangeListener(iPropertyChangeListener);
                }
                if (bl2) {
                    System.out.println(String.valueOf(System.currentTimeMillis() - l) + " ms to run action: " + this.action.getText());
                }
            } else if (object != null) {
                object.notEnabled(this.action, new NotEnabledException(String.valueOf(this.action.getText()) + " is not enabled."));
            }
        }
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    private boolean hasImages(IAction iAction) {
        return iAction.getImageDescriptor() != null || iAction.getHoverImageDescriptor() != null || iAction.getDisabledImageDescriptor() != null;
    }

    private boolean isCommandActive() {
        IAction iAction = this.getAction();
        if (iAction != null) {
            String string = iAction.getActionDefinitionId();
            ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
            if (iCallback != null) {
                return iCallback.isActive(string);
            }
        }
        return true;
    }

    @Override
    public boolean isDynamic() {
        if (this.widget instanceof MenuItem) {
            boolean bl;
            boolean bl2 = (this.widget.getStyle() & 0x20) != 0;
            boolean bl3 = this.getAction() != null && this.getAction().getStyle() == 2;
            boolean bl4 = (this.widget.getStyle() & 0x10) != 0;
            boolean bl5 = bl = this.getAction() != null && this.getAction().getStyle() == 8;
            return bl2 != bl3 || bl4 != bl;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.action != null && this.action.isEnabled();
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean bl = this.getParent().getOverrides().getEnabled(this);
        return bl == null ? true : bl;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.isCommandActive();
    }

    public void setMode(int n) {
        this.mode = n;
        this.update();
    }

    @Override
    public final void update() {
        this.update(null);
    }

    @Override
    public void update(String string) {
        if (this.widget != null) {
            boolean bl;
            boolean bl2 = string == null || string.equals("text");
            boolean bl3 = string == null || string.equals("image");
            boolean bl4 = string == null || string.equals("toolTipText");
            boolean bl5 = string == null || string.equals("enabled") || string.equals("enabled");
            boolean bl6 = bl = !(this.action.getStyle() != 2 && this.action.getStyle() != 8 || string != null && !string.equals("checked"));
            if (this.widget instanceof ToolItem) {
                String string2;
                boolean bl7;
                ToolItem toolItem = (ToolItem)this.widget;
                String string3 = this.action.getText();
                boolean bl8 = bl7 = string3 != null && ((this.getMode() & MODE_FORCE_TEXT) != 0 || !this.hasImages(this.action));
                if (bl7 && string3 != null) {
                    string3 = Action.removeAcceleratorText(string3);
                    string3 = Action.removeMnemonics(string3);
                }
                if (bl2) {
                    boolean bl9;
                    string2 = bl7 ? string3 : "";
                    boolean bl10 = bl9 = (toolItem.getParent().getStyle() & 0x20000) != 0;
                    if (bl9 || !toolItem.getText().equals(string2)) {
                        toolItem.setText(string2);
                    }
                }
                if (bl3) {
                    this.updateImages(!bl7);
                }
                if (bl4 || bl2) {
                    String string4;
                    string2 = this.action.getToolTipText();
                    if (string2 == null || string2.length() == 0) {
                        string2 = string3;
                    }
                    ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                    String string5 = this.action.getActionDefinitionId();
                    if (iCallback != null && string5 != null && string2 != null && (string4 = iCallback.getAcceleratorText(string5)) != null && string4.length() != 0) {
                        string2 = JFaceResources.format("Toolbar_Tooltip_Accelerator", new Object[]{string2, string4});
                    }
                    if (!bl7 || string2 != null && !string2.equals(string3)) {
                        toolItem.setToolTipText(string2);
                    } else {
                        toolItem.setToolTipText(null);
                    }
                }
                if (bl5) {
                    boolean bl11;
                    boolean bl12 = bl11 = this.action.isEnabled() && this.isEnabledAllowed();
                    if (toolItem.getEnabled() != bl11) {
                        toolItem.setEnabled(bl11);
                    }
                }
                if (bl) {
                    boolean bl13 = this.action.isChecked();
                    if (toolItem.getSelection() != bl13) {
                        toolItem.setSelection(bl13);
                    }
                }
                return;
            }
            if (this.widget instanceof MenuItem) {
                int n;
                MenuItem menuItem = (MenuItem)this.widget;
                if (bl2) {
                    Object object;
                    n = 0;
                    String string6 = null;
                    IAction iAction = this.getAction();
                    String string7 = null;
                    n = iAction.getAccelerator();
                    ExternalActionManager.ICallback iCallback = ExternalActionManager.getInstance().getCallback();
                    if (n != 0 && iCallback != null && iCallback.isAcceleratorInUse(n)) {
                        n = 0;
                    }
                    String string8 = iAction.getActionDefinitionId();
                    if (Util.isGtk() && iCallback instanceof ExternalActionManager.IBindingManagerCallback && string8 != null) {
                        object = (ExternalActionManager.IBindingManagerCallback)iCallback;
                        IKeyLookup iKeyLookup = KeyLookupFactory.getDefault();
                        TriggerSequence[] triggerSequenceArray = object.getActiveBindingsFor(string8);
                        int n2 = 0;
                        while (n2 < triggerSequenceArray.length) {
                            Trigger trigger;
                            TriggerSequence triggerSequence = triggerSequenceArray[n2];
                            Trigger[] triggerArray = triggerSequence.getTriggers();
                            if (triggerArray.length == 1 && (trigger = triggerArray[0]) instanceof KeyStroke) {
                                KeyStroke keyStroke = (KeyStroke)trigger;
                                int n3 = keyStroke.getNaturalKey();
                                if (keyStroke.getModifierKeys() == (iKeyLookup.getCtrl() | iKeyLookup.getShift()) && (n3 >= 48 && n3 <= 57 || n3 >= 65 && n3 <= 70 || n3 == 85)) {
                                    n = keyStroke.getModifierKeys() | n3;
                                    string6 = triggerSequence.format();
                                    break;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (n == 0 && iCallback != null && string8 != null) {
                        string6 = iCallback.getAcceleratorText(string8);
                    }
                    object = null;
                    if (this.getParent() != null) {
                        object = this.getParent().getOverrides();
                    }
                    if (object != null) {
                        string7 = this.getParent().getOverrides().getText(this);
                    }
                    menuItem.setAccelerator(n);
                    if (string7 == null) {
                        string7 = iAction.getText();
                    }
                    if (string7 != null && string6 == null && (string6 = LegacyActionTools.extractAcceleratorText(string7)) == null && n != 0) {
                        string6 = Action.convertAccelerator(n);
                    }
                    string7 = string7 == null ? "" : Action.removeAcceleratorText(string7);
                    if (string6 == null) {
                        menuItem.setText(string7);
                    } else {
                        menuItem.setText(String.valueOf(string7) + '\t' + string6);
                    }
                }
                if (bl3) {
                    this.updateImages(false);
                }
                if (bl5) {
                    int n4 = n = this.action.isEnabled() && this.isEnabledAllowed() ? 1 : 0;
                    if (menuItem.getEnabled() != n) {
                        menuItem.setEnabled(n != 0);
                    }
                }
                if (bl) {
                    n = this.action.isChecked();
                    if (menuItem.getSelection() != n) {
                        menuItem.setSelection(n != 0);
                    }
                }
                return;
            }
            if (this.widget instanceof Button) {
                Button button = (Button)this.widget;
                if (bl3) {
                    this.updateImages(false);
                }
                if (bl2) {
                    boolean bl14;
                    String string9 = this.action.getText();
                    boolean bl15 = bl14 = string9 != null && ((this.getMode() & MODE_FORCE_TEXT) != 0 || !this.hasImages(this.action));
                    if (bl14) {
                        string9 = Action.removeAcceleratorText(string9);
                    }
                    String string10 = bl14 ? string9 : "";
                    button.setText(string10);
                }
                if (bl4) {
                    button.setToolTipText(this.action.getToolTipText());
                }
                if (bl5) {
                    boolean bl16;
                    boolean bl17 = bl16 = this.action.isEnabled() && this.isEnabledAllowed();
                    if (button.getEnabled() != bl16) {
                        button.setEnabled(bl16);
                    }
                }
                if (bl) {
                    boolean bl18 = this.action.isChecked();
                    if (button.getSelection() != bl18) {
                        button.setSelection(bl18);
                    }
                }
                return;
            }
        }
    }

    private boolean updateImages(boolean bl) {
        ResourceManager resourceManager = JFaceResources.getResources();
        if (this.widget instanceof ToolItem) {
            if (USE_COLOR_ICONS) {
                ImageDescriptor imageDescriptor = this.action.getHoverImageDescriptor();
                if (imageDescriptor == null) {
                    imageDescriptor = this.action.getImageDescriptor();
                }
                ImageDescriptor imageDescriptor2 = this.action.getDisabledImageDescriptor();
                if (imageDescriptor == null && bl) {
                    imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                }
                LocalResourceManager localResourceManager = new LocalResourceManager(resourceManager);
                ((ToolItem)this.widget).setDisabledImage(imageDescriptor2 == null ? null : localResourceManager.createImageWithDefault(imageDescriptor2));
                ((ToolItem)this.widget).setImage(imageDescriptor == null ? null : localResourceManager.createImageWithDefault(imageDescriptor));
                this.disposeOldImages();
                this.imageManager = localResourceManager;
                return imageDescriptor != null;
            }
            ImageDescriptor imageDescriptor = this.action.getImageDescriptor();
            ImageDescriptor imageDescriptor3 = this.action.getHoverImageDescriptor();
            ImageDescriptor imageDescriptor4 = this.action.getDisabledImageDescriptor();
            if (imageDescriptor == null && imageDescriptor3 != null) {
                imageDescriptor = ImageDescriptor.createWithFlags(this.action.getHoverImageDescriptor(), 2);
            } else if (imageDescriptor3 == null && imageDescriptor != null) {
                imageDescriptor3 = imageDescriptor;
                imageDescriptor = ImageDescriptor.createWithFlags(this.action.getImageDescriptor(), 2);
            }
            if (imageDescriptor3 == null && imageDescriptor == null && bl) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            LocalResourceManager localResourceManager = new LocalResourceManager(resourceManager);
            ((ToolItem)this.widget).setDisabledImage(imageDescriptor4 == null ? null : localResourceManager.createImageWithDefault(imageDescriptor4));
            ((ToolItem)this.widget).setHotImage(imageDescriptor3 == null ? null : localResourceManager.createImageWithDefault(imageDescriptor3));
            ((ToolItem)this.widget).setImage(imageDescriptor == null ? null : localResourceManager.createImageWithDefault(imageDescriptor));
            this.disposeOldImages();
            this.imageManager = localResourceManager;
            return imageDescriptor != null;
        }
        if (this.widget instanceof Item || this.widget instanceof Button) {
            ImageDescriptor imageDescriptor = this.action.getHoverImageDescriptor();
            if (imageDescriptor == null) {
                imageDescriptor = this.action.getImageDescriptor();
            }
            if (imageDescriptor == null && bl) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            LocalResourceManager localResourceManager = new LocalResourceManager(resourceManager);
            if (this.widget instanceof Item) {
                ((Item)this.widget).setImage(imageDescriptor == null ? null : localResourceManager.createImageWithDefault(imageDescriptor));
            } else if (this.widget instanceof Button) {
                ((Button)this.widget).setImage(imageDescriptor == null ? null : localResourceManager.createImageWithDefault(imageDescriptor));
            }
            this.disposeOldImages();
            this.imageManager = localResourceManager;
            return imageDescriptor != null;
        }
        return false;
    }

    private void disposeOldImages() {
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }

    protected String shortenText(String string, ToolItem toolItem) {
        if (string == null) {
            return null;
        }
        GC gC = new GC((Drawable)toolItem.getParent());
        int n = toolItem.getImage().getBounds().width * 4;
        if (gC.textExtent((String)string).x < n) {
            gC.dispose();
            return string;
        }
        int n2 = string.length();
        while (n2 > 0) {
            String string2 = string.substring(0, n2);
            string2 = String.valueOf(string2) + ellipsis;
            if (gC.textExtent((String)string2).x < n) {
                gC.dispose();
                return string2;
            }
            --n2;
        }
        gC.dispose();
        return string;
    }

    @Override
    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        this.holdMenu = null;
    }

    private Listener getMenuCreatorListener() {
        if (this.menuCreatorListener == null) {
            this.menuCreatorListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 22: {
                            ActionContributionItem.this.handleShowProxy((Menu)event.widget);
                            break;
                        }
                        case 23: {
                            ActionContributionItem.this.handleHideProxy((Menu)event.widget);
                        }
                    }
                }
            };
        }
        return this.menuCreatorListener;
    }

    private void handleShowProxy(Menu menu) {
        menu.removeListener(22, this.getMenuCreatorListener());
        IMenuCreator iMenuCreator = this.action.getMenuCreator();
        this.menuCreatorCalled = true;
        if (iMenuCreator == null) {
            return;
        }
        this.holdMenu = iMenuCreator.getMenu(menu.getParentMenu());
        if (this.holdMenu == null) {
            return;
        }
        this.copyMenu(this.holdMenu, menu);
    }

    private void copyMenu(Menu menu, Menu menu2) {
        if (menu.isDisposed() || menu2.isDisposed()) {
            return;
        }
        menu.notifyListeners(22, null);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Widget widget;
                if (!event.widget.isDisposed() && !(widget = (Widget)event.widget.getData()).isDisposed()) {
                    int n = event.widget.getStyle();
                    if (event.type == 13 && (n & 0x32) != 0 && widget instanceof MenuItem) {
                        ((MenuItem)widget).setSelection(((MenuItem)event.widget).getSelection());
                    }
                    event.widget = widget;
                    widget.notifyListeners(event.type, event);
                }
            }
        };
        MenuItem[] menuItemArray = menu.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n];
            MenuItem menuItem2 = new MenuItem(menu2, menuItem.getStyle());
            menuItem2.setData((Object)menuItem);
            menuItem2.setAccelerator(menuItem.getAccelerator());
            menuItem2.setEnabled(menuItem.getEnabled());
            menuItem2.setImage(menuItem.getImage());
            menuItem2.setSelection(menuItem.getSelection());
            menuItem2.setText(menuItem.getText());
            menuItem2.addListener(13, listener);
            menuItem2.addListener(30, listener);
            menuItem2.addListener(28, listener);
            final Menu menu3 = menuItem.getMenu();
            if (menu3 != null) {
                final Menu menu4 = new Menu(menu2);
                menu4.setData((Object)menu3);
                menuItem2.setMenu(menu4);
                menu4.addListener(22, new Listener(){

                    public void handleEvent(Event event) {
                        event.widget.removeListener(22, (Listener)this);
                        if (event.type == 22) {
                            ActionContributionItem.this.copyMenu(menu3, menu4);
                        }
                    }
                });
                menu4.addListener(28, listener);
                menu4.addListener(23, listener);
            }
            ++n;
        }
    }

    private void handleHideProxy(final Menu menu) {
        menu.removeListener(23, this.getMenuCreatorListener());
        menu.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!menu.isDisposed()) {
                    MenuItem menuItem = menu.getParentItem();
                    menu.dispose();
                    menuItem.setMenu(ActionContributionItem.this.holdMenu);
                }
                if (ActionContributionItem.this.holdMenu != null && !ActionContributionItem.this.holdMenu.isDisposed()) {
                    ActionContributionItem.this.holdMenu.notifyListeners(23, null);
                }
                ActionContributionItem.this.holdMenu = null;
            }
        });
    }

    public Widget getWidget() {
        return this.widget;
    }
}

