/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import org.eclipse.jface.action.AbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

public abstract class Action
extends AbstractAction
implements IAction {
    private static final IMenuCreator VAL_DROP_DOWN_MENU = new IMenuCreator(){

        @Override
        public void dispose() {
        }

        @Override
        public Menu getMenu(Control control) {
            return null;
        }

        @Override
        public Menu getMenu(Menu menu) {
            return null;
        }
    };
    private static final String VAL_PUSH_BTN = "PUSH_BTN";
    private static final Integer VAL_RADIO_BTN_OFF = new Integer(0);
    private static final Integer VAL_RADIO_BTN_ON = new Integer(1);
    private static final Boolean VAL_TOGGLE_BTN_OFF = Boolean.FALSE;
    private static final Boolean VAL_TOGGLE_BTN_ON = Boolean.TRUE;
    private int accelerator = 0;
    private String actionDefinitionId;
    private String description;
    private ImageDescriptor disabledImage;
    private boolean enabled = true;
    private HelpListener helpListener;
    private ImageDescriptor hoverImage;
    private String id;
    private ImageDescriptor image;
    private String text;
    private String toolTipText;
    private Object value = null;

    public static String convertAccelerator(int n) {
        return LegacyActionTools.convertAccelerator(n);
    }

    public static int convertAccelerator(String string) {
        return LegacyActionTools.convertAccelerator(string);
    }

    public static int findKeyCode(String string) {
        return LegacyActionTools.findKeyCode(string);
    }

    public static String findKeyString(int n) {
        return LegacyActionTools.findKeyString(n);
    }

    public static int findModifier(String string) {
        return LegacyActionTools.findModifier(string);
    }

    public static String findModifierString(int n) {
        return LegacyActionTools.findModifierString(n);
    }

    public static String removeAcceleratorText(String string) {
        return LegacyActionTools.removeAcceleratorText(string);
    }

    public static String removeMnemonics(String string) {
        return LegacyActionTools.removeMnemonics(string);
    }

    protected Action() {
    }

    protected Action(String string) {
        this();
        this.setText(string);
    }

    protected Action(String string, ImageDescriptor imageDescriptor) {
        this(string);
        this.setImageDescriptor(imageDescriptor);
    }

    protected Action(String string, int n) {
        this(string);
        switch (n) {
            case 1: {
                this.value = VAL_PUSH_BTN;
                break;
            }
            case 2: {
                this.value = VAL_TOGGLE_BTN_OFF;
                break;
            }
            case 4: {
                this.value = VAL_DROP_DOWN_MENU;
                break;
            }
            case 8: {
                this.value = VAL_RADIO_BTN_OFF;
            }
        }
    }

    @Override
    public int getAccelerator() {
        return this.accelerator;
    }

    @Override
    public String getActionDefinitionId() {
        return this.actionDefinitionId;
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getToolTipText();
    }

    @Override
    public ImageDescriptor getDisabledImageDescriptor() {
        return this.disabledImage;
    }

    @Override
    public HelpListener getHelpListener() {
        return this.helpListener;
    }

    @Override
    public ImageDescriptor getHoverImageDescriptor() {
        return this.hoverImage;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    @Override
    public IMenuCreator getMenuCreator() {
        if (this.value == VAL_DROP_DOWN_MENU) {
            return null;
        }
        if (this.value instanceof IMenuCreator) {
            return (IMenuCreator)this.value;
        }
        return null;
    }

    @Override
    public int getStyle() {
        if (this.value == VAL_PUSH_BTN || this.value == null) {
            return 1;
        }
        if (this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_TOGGLE_BTN_OFF) {
            return 2;
        }
        if (this.value == VAL_RADIO_BTN_ON || this.value == VAL_RADIO_BTN_OFF) {
            return 8;
        }
        if (this.value instanceof IMenuCreator) {
            return 4;
        }
        return 1;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public boolean isChecked() {
        return this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_RADIO_BTN_ON;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isHandled() {
        return true;
    }

    public final void notifyResult(boolean bl) {
        this.firePropertyChange("result", null, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void run() {
    }

    @Override
    public void runWithEvent(Event event) {
        this.run();
    }

    @Override
    public void setAccelerator(int n) {
        this.accelerator = n;
    }

    @Override
    public void setActionDefinitionId(String string) {
        this.actionDefinitionId = string;
    }

    @Override
    public void setChecked(boolean bl) {
        Comparable<Boolean> comparable = null;
        if (this.value == null || this.value == VAL_TOGGLE_BTN_ON || this.value == VAL_TOGGLE_BTN_OFF) {
            comparable = bl ? VAL_TOGGLE_BTN_ON : VAL_TOGGLE_BTN_OFF;
        } else if (this.value == VAL_RADIO_BTN_ON || this.value == VAL_RADIO_BTN_OFF) {
            comparable = bl ? VAL_RADIO_BTN_ON : VAL_RADIO_BTN_OFF;
        } else {
            return;
        }
        if (comparable != this.value) {
            this.value = comparable;
            if (bl) {
                this.firePropertyChange("checked", Boolean.FALSE, Boolean.TRUE);
            } else {
                this.firePropertyChange("checked", Boolean.TRUE, Boolean.FALSE);
            }
        }
    }

    @Override
    public void setDescription(String string) {
        if (this.description == null && string != null || this.description != null && string == null || this.description != null && string != null && !string.equals(this.description)) {
            String string2 = this.description;
            this.description = string;
            this.firePropertyChange("description", string2, this.description);
        }
    }

    @Override
    public void setDisabledImageDescriptor(ImageDescriptor imageDescriptor) {
        if (this.disabledImage != imageDescriptor) {
            ImageDescriptor imageDescriptor2 = this.disabledImage;
            this.disabledImage = imageDescriptor;
            this.firePropertyChange("image", imageDescriptor2, imageDescriptor);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            Boolean bl2 = this.enabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.enabled = bl;
            this.firePropertyChange("enabled", bl2, bl3);
        }
    }

    @Override
    public void setHelpListener(HelpListener helpListener) {
        this.helpListener = helpListener;
    }

    @Override
    public void setHoverImageDescriptor(ImageDescriptor imageDescriptor) {
        if (this.hoverImage != imageDescriptor) {
            ImageDescriptor imageDescriptor2 = this.hoverImage;
            this.hoverImage = imageDescriptor;
            this.firePropertyChange("image", imageDescriptor2, imageDescriptor);
        }
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        if (this.image != imageDescriptor) {
            ImageDescriptor imageDescriptor2 = this.image;
            this.image = imageDescriptor;
            this.firePropertyChange("image", imageDescriptor2, imageDescriptor);
        }
    }

    @Override
    public void setMenuCreator(IMenuCreator iMenuCreator) {
        if (this.value == null) {
            this.value = iMenuCreator;
            return;
        }
        if (this.value instanceof IMenuCreator) {
            this.value = iMenuCreator == null ? VAL_DROP_DOWN_MENU : iMenuCreator;
        }
    }

    @Override
    public void setText(String string) {
        int n;
        String string2;
        String string3 = this.text;
        int n2 = this.accelerator;
        this.text = string;
        if (string != null && (string2 = LegacyActionTools.extractAcceleratorText(string)) != null && (n = LegacyActionTools.convertLocalizedAccelerator(string2)) > 0) {
            this.setAccelerator(n);
        }
        if (this.accelerator != n2 || (string3 == null ? this.text != null : !string3.equals(this.text))) {
            this.firePropertyChange("text", string3, this.text);
        }
    }

    @Override
    public void setToolTipText(String string) {
        String string2 = this.toolTipText;
        if (string2 == null ? string != null : !string2.equals(string)) {
            this.toolTipText = string;
            this.firePropertyChange("toolTipText", string2, string);
        }
    }
}

