/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.internal.io.win32;

import com.deltopia.internal.io.AbstractFileSystem;
import com.deltopia.internal.io.BaseFileSystem;
import com.deltopia.io.DefaultFileSystem;
import com.deltopia.io.IStorageListener;
import com.deltopia.io.StorageEvent;
import com.deltopia.util.logging.ToString;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystem
extends BaseFileSystem {
    private static final IPath[] EMPTY_PATH_CAUSES = new IPath[]{Path.EMPTY};
    private static final ExecutorService exec = Executors.newCachedThreadPool();
    private static final int FILE_NOTIFY_CHANGE_ATTRIBUTES = 4;
    private static final int FILE_NOTIFY_CHANGE_DIR_NAME = 2;
    private static final int FILE_NOTIFY_CHANGE_FILE_NAME = 1;
    private static final int FILE_NOTIFY_CHANGE_LAST_WRITE = 16;
    private static final int FILE_NOTIFY_CHANGE_SIZE = 8;
    private static final long INVALID_HANDLE_VALUE = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(FileSystem.class);
    private static final int MAX_THUMBNAIL_SIZE = 2048;
    private static final int NOTIFY_FILTER = 31;
    private static final int SIIGBF_RESIZETOFIT = 0;
    private static final int SIIGBF_THUMBNAILONLY = 8;
    private static final int SUPPORTED_ATTRIBUTES = 9568672;
    private static final int WAIT_FAILED = -1;
    private static final int WAIT_FOR_MULTIPLE_OBJECTS_TIMEOUT = 30000;
    private static final int WAIT_OBJECT_0 = 0;
    private static final int WAIT_TIMEOUT = 258;
    private final AtomicBoolean cmShow = new AtomicBoolean();
    private final List<StorageSubscription> subscriptions = new CopyOnWriteArrayList<StorageSubscription>();
    private Runnable waitForMultipleObjects;
    private int waitForMultipleObjectsCount;

    private static final EnumSet<AbstractFileSystem.Feature> createFeatures() {
        EnumSet<AbstractFileSystem.Feature[]> enumSet = EnumSet.of(AbstractFileSystem.Feature.COPY, new AbstractFileSystem.Feature[]{AbstractFileSystem.Feature.COMPARE_BB, AbstractFileSystem.Feature.GET_FILE_INFO, AbstractFileSystem.Feature.SET_FILE_INFO, AbstractFileSystem.Feature.READ_SYM_LINK, AbstractFileSystem.Feature.MOVE_TO_TRASH, AbstractFileSystem.Feature.DIR_LIST, AbstractFileSystem.Feature.SHOW_CONTEXT_MENU, AbstractFileSystem.Feature.GET_USER, AbstractFileSystem.Feature.GET_GROUP});
        if (FileSystem.isVistaOrAbove()) {
            enumSet.add((AbstractFileSystem.Feature[])AbstractFileSystem.Feature.CREATE_SYM_LINK);
        }
        return enumSet;
    }

    private static boolean isVistaOrAbove() {
        String string = System.getProperty("os.version");
        return string != null && string.compareTo("6") >= 0;
    }

    private static String stripPrefix(String string) {
        if (string.startsWith("\\??\\")) {
            string = string.startsWith("\\??\\UNC\\") ? "\\" + string.substring(7) : string.substring(4);
            return string;
        }
        return string;
    }

    public FileSystem() {
        super(FileSystem.createFeatures(), 9568672);
    }

    public void addStorageListenerImpl(File file, IStorageListener iStorageListener) {
        String string = file.getParent();
        StorageSubscription storageSubscription = this.getStorageSubscription(string);
        String string2 = file.getName();
        if (storageSubscription == null) {
            storageSubscription = this.addStorageSubscription(string);
            if (storageSubscription != null) {
                storageSubscription.addListener(string2, iStorageListener);
            }
        } else {
            storageSubscription.addListener(string2, iStorageListener);
        }
    }

    private StorageSubscription addStorageSubscription(String string) {
        long l = this.nFindFirstChangeNotification(string, false, 31);
        StorageSubscription storageSubscription = null;
        if (l != -1L) {
            storageSubscription = new StorageSubscription(string);
            storageSubscription.setHandle(l);
            this.subscriptions.add(storageSubscription);
            this.startWaitForMultipleObjects();
        }
        return storageSubscription;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public Menu attachContextMenu(Control control, Menu menu, Set<File> set) throws UnsupportedOperationException, IOException {
        Object object;
        Object object22222222222;
        long l;
        if (!this.isSupportedNative(AbstractFileSystem.Feature.SHOW_CONTEXT_MENU)) {
            throw new UnsupportedOperationException("attachContextMenu");
        }
        if (set == null) {
            throw new NullPointerException("paths");
        }
        if (set.size() <= 0) {
            throw new IllegalArgumentException("Empty paths");
        }
        if (control != null) {
            l = control.handle;
            if (l <= 0L) {
                throw new IllegalArgumentException("Invalid control handle " + control);
            }
        } else {
            l = 0L;
        }
        Object[] objectArray = new String[set.size()];
        File file = null;
        int n = 0;
        for (Object object22222222222 : set) {
            if (object22222222222 == null) {
                throw new NullPointerException("path on " + n);
            }
            File file2 = object22222222222.getParentFile();
            if (n == 0) {
                file = file2;
            } else if (file != null && !file.equals(file2) || file == null && file2 != null) {
                throw new IllegalArgumentException("Specified paths have different parents " + file + " <-> " + file2);
            }
            objectArray[n] = object22222222222.getAbsolutePath();
            ++n;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(new ToString().append(">>> Create shell context menu, control: " + control + ", menu: " + menu + ", for paths", objectArray).toString());
        }
        if (this.cmShow.getAndSet(true)) {
            throw new IllegalArgumentException("Context menu already created");
        }
        object22222222222 = null;
        Object object3 = new ContextMenu(menu);
        try {
            long l2 = this.nShellMenuAttach(l, ((ContextMenu)((Object)object3)).handle, (String[])objectArray, true, false);
            ((ContextMenu)object3).initNativeObject(l2);
            object = object22222222222 = object3;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.onNativeError(unsatisfiedLinkError, AbstractFileSystem.Feature.SHOW_CONTEXT_MENU);
            if (LOG.isInfoEnabled()) {
                LOG.info(new ToString().append("<<< Create context menu " + (object22222222222 == null ? "Failed" : "Succeeded") + ", control: " + control + ", menu: " + menu + ", for paths", objectArray).toString());
            }
            if (object22222222222 == null && object3 != null) {
                object3.dispose();
            }
        }
        catch (IOException iOException) {
            throw new IOException(new ToString().append("Create context menu failed because of '").append(iOException.getMessage()).append("'. Paths", set).toString());
            {
                catch (Throwable throwable) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info(new ToString().append("<<< Create context menu " + (object22222222222 == null ? "Failed" : "Succeeded") + ", control: " + control + ", menu: " + menu + ", for paths", objectArray).toString());
                    }
                    if (object22222222222 == null && object3 != null) {
                        object3.dispose();
                    }
                    throw throwable;
                }
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(new ToString().append("<<< Create context menu " + (object22222222222 == null ? "Failed" : "Succeeded") + ", control: " + control + ", menu: " + menu + ", for paths", objectArray).toString());
        }
        if (object22222222222 == null && object3 != null) {
            object3.dispose();
        }
        return object;
        return DefaultFileSystem.getInstance().attachContextMenu(control, menu, set);
    }

    public boolean deleteToTrash(File file) {
        return this.nMoveToTrash(file.getAbsolutePath());
    }

    private StorageSubscription getStorageSubscription(long l) {
        for (StorageSubscription storageSubscription : this.subscriptions) {
            if (storageSubscription.getHandle() != l) continue;
            return storageSubscription;
        }
        return null;
    }

    private StorageSubscription getStorageSubscription(String string) {
        for (StorageSubscription storageSubscription : this.subscriptions) {
            if (!storageSubscription.path.equalsIgnoreCase(string)) continue;
            return storageSubscription;
        }
        return null;
    }

    public Image getThumbnail(Device device, File file, int n, int n2) throws NullPointerException, IllegalArgumentException {
        long l;
        if (device == null) {
            throw new NullPointerException("display");
        }
        if (file == null) {
            throw new NullPointerException("path");
        }
        if (n <= 0 || n > 2048 || n2 <= 0 || n2 > 2048) {
            throw new IllegalArgumentException("Invalid max size: " + n + 'x' + n2);
        }
        try {
            l = this.nGetThumbnail(file.getAbsolutePath(), n, n2, 8);
        }
        catch (Exception exception) {
            LOG.warn("Cannot creates thumbnail of '" + file + "': " + exception);
            return null;
        }
        if (l == 0L) {
            LOG.info("Cannot creates thumbnail of '" + file + "'");
            return null;
        }
        Image image = Image.createFromHBitmap((Device)device, (long)l);
        if (LOG.isInfoEnabled()) {
            LOG.info("Creates thumbnail of '" + file + "': " + image);
        }
        return image;
    }

    private native boolean nFindCloseChangeNotification(long var1);

    private native long nFindFirstChangeNotification(String var1, boolean var2, int var3);

    private native boolean nFindNextChangeNotification(long var1);

    private final native long nGetThumbnail(String var1, int var2, int var3, int var4) throws IOException;

    private native boolean nMoveToTrash(String var1);

    private final native long nShellMenuAttach(long var1, long var3, String[] var5, boolean var6, boolean var7) throws IOException;

    private final native void nShellMenuDestroy(long var1) throws IOException;

    private native int nWaitForMultipleObjects(long[] var1, boolean var2, int var3);

    public String readSymbolicLink(String string) throws UnsupportedOperationException, IOException {
        String string2 = super.readSymbolicLink(string);
        return FileSystem.stripPrefix(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorageListenerImpl(File file, IStorageListener iStorageListener) {
        List<StorageSubscription> list = this.subscriptions;
        synchronized (list) {
            StorageSubscription storageSubscription = this.getStorageSubscription(file.getParent());
            if (storageSubscription != null && storageSubscription.removeListener(file.getName(), iStorageListener) <= 0) {
                this.removeStorageSubscription(storageSubscription);
            }
        }
    }

    private void removeStorageSubscription(StorageSubscription storageSubscription) {
        this.subscriptions.remove(storageSubscription);
    }

    private void startWaitForMultipleObjects() {
        exec.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FileSystem.this.waitForMultipleObjects();
                }
                finally {
                    if (!FileSystem.this.subscriptions.isEmpty()) {
                        FileSystem.this.startWaitForMultipleObjects();
                    }
                }
            }
        });
    }

    private void stopWaitForMultipleObjects() {
        try {
            for (StorageSubscription storageSubscription : this.subscriptions) {
                long l = storageSubscription.getHandle();
                if (l == 0L) continue;
                this.nFindCloseChangeNotification(l);
            }
        }
        finally {
            this.subscriptions.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void waitForMultipleObjects() {
        block3: while (true) {
            var1_1 = new long[this.subscriptions.size()];
            var2_2 = 0;
            for (StorageSubscription var3_4 : this.subscriptions) {
                var5_7 = var3_4.getHandle();
                if (var5_7 == -1L) continue;
                var1_1[var2_2++] = var5_7;
            }
            if (var2_2 == 0) {
                this.stopWaitForMultipleObjects();
                break;
            }
            var3_3 = this.nWaitForMultipleObjects(var1_1, false, 30000);
            if (var3_3 == -1 || this.subscriptions.isEmpty()) {
                this.stopWaitForMultipleObjects();
                break;
            }
            if (258 == var3_3 || var3_3 < 0 || 0 + var1_1.length <= var3_3) continue;
            var3_3 += 0;
            var4_6 = 0;
            while (true) {
                if (var4_6 < var1_1.length) ** break;
                continue block3;
                var5_7 = var1_1[var4_6];
                var7_8 = this.getStorageSubscription(var5_7);
                if (var7_8 == null) {
                    this.nFindCloseChangeNotification(var5_7);
                } else {
                    try {
                        var7_8.notifyListeners();
                    }
                    finally {
                        if (this.nFindNextChangeNotification(var5_7)) {
                            this.removeStorageSubscription(var7_8);
                        }
                    }
                }
                ++var4_6;
            }
            break;
        }
    }

    private final class ContextMenu
    extends Menu {
        private final AtomicLong nativeObject;

        private ContextMenu(Menu menu) {
            super(menu);
            this.nativeObject = new AtomicLong();
        }

        protected void checkSubclass() {
        }

        private void initNativeObject(long l) {
            if (!this.nativeObject.compareAndSet(0L, l)) {
                throw new IllegalStateException("Already set");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("+++ Create context menu: " + (Object)((Object)this));
            }
        }

        protected void releaseHandle() {
            this.releaseNative();
            super.releaseHandle();
        }

        private void releaseNative() {
            long l;
            if (LOG.isInfoEnabled()) {
                LOG.info("--- Dispose context menu: " + (Object)((Object)this));
            }
            if ((l = this.nativeObject.getAndSet(0L)) != 0L) {
                try {
                    FileSystem.this.nShellMenuDestroy(l);
                }
                catch (Throwable throwable) {
                    LOG.error("Failed to dispose native context menu object", throwable);
                }
            } else {
                LOG.info("Not created or Already disposed native context menu object");
            }
            FileSystem.this.cmShow.set(false);
        }

        public String toString() {
            return String.valueOf(super.toString()) + String.format(", nativeObject=0x%X", this.nativeObject.get());
        }
    }

    private static class StorageSubscription {
        private long handle;
        private final ConcurrentMap<String, List<IStorageListener>> name2listeners = new ConcurrentHashMap<String, List<IStorageListener>>();
        public final String path;

        public StorageSubscription(String string) {
            this.path = string;
        }

        public void addListener(String string, IStorageListener iStorageListener) {
            CopyOnWriteArrayList<IStorageListener> copyOnWriteArrayList;
            CopyOnWriteArrayList<IStorageListener> copyOnWriteArrayList2 = (CopyOnWriteArrayList<IStorageListener>)this.name2listeners.get(string);
            if (copyOnWriteArrayList2 == null && (copyOnWriteArrayList2 = (List)this.name2listeners.putIfAbsent(string, copyOnWriteArrayList = new CopyOnWriteArrayList<IStorageListener>())) == null) {
                copyOnWriteArrayList2 = copyOnWriteArrayList;
            }
            if (!copyOnWriteArrayList2.contains(iStorageListener)) {
                copyOnWriteArrayList2.add(iStorageListener);
            }
        }

        public long getHandle() {
            return this.handle;
        }

        public void notifyListeners() {
            for (String string : this.name2listeners.keySet()) {
                boolean bl = new File(this.path, string).exists();
                int n = bl ? 2 : 4;
                StorageEvent storageEvent = new StorageEvent((Object)this, n, (Object[])EMPTY_PATH_CAUSES);
                List list = (List)this.name2listeners.get(string);
                for (IStorageListener iStorageListener : list) {
                    iStorageListener.storageChanged(storageEvent);
                }
            }
        }

        public int removeListener(String string, IStorageListener iStorageListener) {
            List list = (List)this.name2listeners.get(string);
            if (list != null) {
                list.remove(iStorageListener);
                if (list.isEmpty()) {
                    this.name2listeners.remove(string);
                }
            }
            return this.name2listeners.size();
        }

        public void setHandle(long l) {
            this.handle = l;
        }
    }
}

