/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.ui;

import com.deltawalker.Delta;
import com.deltawalker.DocType;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.ITextDiffDoc;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.script.Role;
import com.deltawalker.text.TextDoc;
import com.deltawalker.text.internal.ui.DeltaSourceViewer;
import com.deltawalker.text.internal.ui.DiffSelection;
import com.deltawalker.text.internal.ui.EditTracker;
import com.deltawalker.text.internal.ui.MergeOverlayArrow;
import com.deltawalker.text.internal.ui.StyleRangeUtil;
import com.deltawalker.text.internal.ui.TextBirdsEye;
import com.deltawalker.text.internal.ui.TextContentArea;
import com.deltawalker.text.internal.ui.TextDashboardCenter;
import com.deltawalker.text.internal.ui.TextDiffModelListener;
import com.deltawalker.text.internal.ui.TextMargin;
import com.deltawalker.text.internal.ui.TextPrintOp;
import com.deltawalker.text.internal.ui.TextSash;
import com.deltawalker.text.internal.ui.TextViewerUtil;
import com.deltawalker.text.internal.ui.editor.TextEditor;
import com.deltawalker.text.ui.StyleRangeComparator;
import com.deltawalker.text.ui.TextDiffController;
import com.deltawalker.ui.ContentArea;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.DiffModelListener;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.IDeltaListener;
import com.deltawalker.ui.IDeltaNotifier;
import com.deltawalker.ui.IDiffViewContentProvider;
import com.deltawalker.ui.IEditIterator;
import com.deltawalker.ui.Margin;
import com.deltawalker.ui.Sash;
import com.deltawalker.ui.printing.HeaderFooterPrintOp;
import com.deltawalker.ui.printing.IPrintable;
import com.deltawalker.ui.printing.IPrinter;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.ui.Direction;
import com.deltopia.ui.swt.IFocusNotifier;
import com.deltopia.ui.swt.KeyUtil;
import com.deltopia.util.Const;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDiffView
extends DiffView
implements IEditIterator,
IPrintable {
    static final Logger LOG = LoggerFactory.getLogger((String)TextDiffView.class.getName());
    private static final boolean TRACE = false;
    private boolean canEditReadOnly;
    private TextDashboardCenter dbCenter;
    private boolean doInlineDeltas;
    private final EditTracker editTracker = new EditTracker();
    private final List<MergeOverlayArrow> mergeArrows = new ArrayList<MergeOverlayArrow>(2);
    private final IDeltaListener onDelta = new IDeltaListener(){

        public void deltasChanged() {
            if (TextDiffView.this.USE_MODEL_EVENTS) {
                TextDiffView.this.fireDeltasChanged();
            }
        }

        public void selectionChanged(boolean bl) {
            TextDiffView.this.fireDeltaSelectionChanged(bl);
            if (bl) {
                TextDiffView.this.revealDelta(TextDiffView.this.deltaModel().getSelected(), true);
            } else {
                TextDiffView.this.redrawDeltas(TextDiffView.this.getDeltas(), true);
                TextDiffView.this.redrawContentAreas();
            }
        }
    };
    final Listener onKey = new Listener(){

        public void handleEvent(Event event) {
            if (!KeyUtil.hasKey((Event)event, (int)SWT.MOD1) && !KeyUtil.hasKey((Event)event, (int)SWT.MOD2)) {
                return;
            }
            for (MergeOverlayArrow mergeOverlayArrow : TextDiffView.this.mergeArrows) {
                if (!event.doit) break;
                if (mergeOverlayArrow == event.widget || mergeOverlayArrow == null || mergeOverlayArrow.isDisposed() || !mergeOverlayArrow.isVisible()) continue;
                Event event2 = ControlUtil.translateEvent((Event)event, (Control)mergeOverlayArrow);
                mergeOverlayArrow.notifyListeners(event.type, event2);
                event.doit = event2.doit;
            }
        }
    };
    private int totalDeltaHeight = -1;
    private boolean USE_MODEL_EVENTS = true;

    public TextDiffView(Composite composite, int n) {
        this(composite, 0, n);
    }

    public TextDiffView(Composite composite, int n, int n2) {
        super(composite, n, n2);
        if (LOG.isInfoEnabled()) {
            LOG.info("C-tor: " + TextDiffView.class.getSimpleName());
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        for (Control control : this.contentAreas().values()) {
            ((IFocusNotifier)control).addFocusListener(focusListener);
        }
    }

    public TextBirdsEye birdsEye() {
        return (TextBirdsEye)super.birdsEye();
    }

    public void clearStyleBackground() {
        this.totalDeltaHeight = -1;
        for (Role role : this.roles()) {
            StyleRangeUtil.clearStyleBackground(this.styledText(role));
        }
    }

    private int computeRealScrollPosition(ITextViewer iTextViewer, int n) {
        List<DiffRange> list = this.getDeltas();
        if (!this.isSyncedVScrolling() || list.isEmpty()) {
            return n;
        }
        DeltaSourceViewer deltaSourceViewer = (DeltaSourceViewer)iTextViewer;
        int n2 = 0;
        int n3 = 0;
        for (DiffRange diffRange : list) {
            Position position = diffRange.position(deltaSourceViewer.role());
            int n4 = TextViewerUtil.positionHeight(iTextViewer, position);
            int n5 = this.getMaxDeltaHeight(diffRange);
            if (n < n3 + n5) {
                int n6;
                if (n4 <= 0 || n5 <= 0) {
                    n6 = 0;
                } else {
                    double d = n4 / n5;
                    n6 = (int)((double)(n - n3) * d);
                    assert (n6 >= 0);
                }
                return n2 + n6;
            }
            n2 += n4;
            n3 += n5;
        }
        return n2;
    }

    public int computeTotalDeltaHeight() {
        Object object;
        if (this.totalDeltaHeight == -1) {
            object = this.getDeltas();
            this.totalDeltaHeight = 0;
            Iterator<DiffRange> iterator = object.iterator();
            while (iterator.hasNext()) {
                DiffRange diffRange = iterator.next();
                this.totalDeltaHeight += this.getMaxDeltaHeight(diffRange);
            }
        }
        if (LOG.isDebugEnabled()) {
            object = Arrays.asList(new Exception().getStackTrace()).toString().replace(", ", Const.LINE_ENDING).substring(0, 300);
            LOG.debug("totalDeltaHeight=" + this.totalDeltaHeight + Const.LINE_ENDING + "computeTotalDeltaHeight: " + (String)object);
        }
        return this.totalDeltaHeight;
    }

    public int computeTotalDeltaHeight(Role role) {
        List<DiffRange> list = this.getDeltas();
        int n = 1;
        for (DiffRange diffRange : list) {
            n += TextViewerUtil.lineIndexRangeFromPosition((ITextViewer)this.viewer((Role)role), (Position)diffRange.position((Role)role)).y;
        }
        return n;
    }

    private int computeVirtualScrollPosition(ITextViewer iTextViewer, int n) {
        List<DiffRange> list = this.getDeltas();
        if (!this.isSyncedVScrolling() || list == null) {
            return n;
        }
        DeltaSourceViewer deltaSourceViewer = (DeltaSourceViewer)iTextViewer;
        int n2 = 0;
        int n3 = 0;
        for (DiffRange diffRange : list) {
            Position position = diffRange.position(deltaSourceViewer.role());
            int n4 = TextViewerUtil.positionHeight(iTextViewer, position);
            int n5 = this.getMaxDeltaHeight(diffRange);
            if (n < n3 + n4) {
                n -= n3;
                if (n4 <= 0 || n5 <= 0) {
                    n = 0;
                } else {
                    double d = n5 / n4;
                    n = (int)((double)n * d);
                }
                return n2 + n;
            }
            n2 += n5;
            n3 += n4;
        }
        return n2;
    }

    public TextContentArea contentArea(Role role) {
        return (TextContentArea)super.contentArea(role);
    }

    public TextDiffController controller() {
        return (TextDiffController)super.controller();
    }

    protected void createBirdsEye(Composite composite) {
        this.birdsEye = new TextBirdsEye(composite, this);
    }

    protected TextContentArea createContentArea(Composite composite, Role role) {
        return new TextContentArea(composite, 0, this, role);
    }

    protected void createControl() {
        super.createControl();
        this.rootComposite().layout();
    }

    protected TextDiffController createController() {
        return new TextDiffController();
    }

    protected Composite createDashboardCenter() {
        this.dbCenter = new TextDashboardCenter((Composite)this.dashboard(), 0, this);
        return this.dbCenter;
    }

    protected DiffModelListener createDeltaModelListener() {
        return new TextDiffModelListener(this);
    }

    protected Margin createMargin(Composite composite, Role role) {
        return new TextMargin(composite, this, role);
    }

    public void createMergeArrow(ITextViewer iTextViewer, Composite composite, int n, int n2, boolean bl) {
        this.mergeArrows.add(new MergeOverlayArrow(this, iTextViewer, composite, 0, n, n2, bl));
    }

    protected Sash createVerticalSash(Composite composite, Relation relation, boolean bl) {
        return new TextSash(composite, this, relation.toSet(), EnumSet.of(Direction.HORIZONTAL), bl, null);
    }

    protected void createVerticalSashes(Composite composite) {
        super.createVerticalSashes(composite);
        this.setTextSashUseSingleLine(this.preferences().getBoolean(PrefKey.T_USE_SINGLE_LINE.toString()));
    }

    public ITextDiffModel deltaModel() {
        return (ITextDiffModel)super.deltaModel();
    }

    public void dispose() {
        ((IDeltaNotifier)this.deltaModel()).removeDeltaListener(this.onDelta);
        this.editTracker.dispose();
        for (Control control : this.mergeArrows) {
            control.dispose();
        }
        this.mergeArrows.clear();
        if (this.uriBoss != null) {
            this.uriBoss.dispose();
            this.uriBoss = null;
        }
        for (ContentArea contentArea : this.contentAreas().values()) {
            contentArea.removeTraverseListener(this.onTraverse);
            ((TextContentArea)contentArea).dispose();
        }
        this.onTraverse = null;
        super.dispose();
    }

    protected void doVerticalScroll(int n, int n2, int n3, Control control) {
        Object object;
        boolean bl = this.isSyncedVScrolling();
        int n4 = 0;
        if (bl) {
            StyledText styledText;
            int n5;
            n4 = this.computeTotalDeltaHeight() - n3;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > (n5 = ((styledText = (object = this.viewer(Role.REF)).getTextWidget()).getWordWrap() ? styledText.getClientArea().height : TextViewerUtil.visibleLineCount((ITextViewer)object)) / 2)) {
                n4 = n5;
            }
        }
        if (bl || control == null) {
            object = new int[]{n, n2, n3};
            this.inScrolling = true;
            try {
                for (StyledText styledText : this.roles()) {
                    ISourceViewer iSourceViewer = this.viewer((Role)styledText);
                    StyledText styledText2 = iSourceViewer.getTextWidget();
                    if (control == styledText2) continue;
                    int n6 = this.computeRealScrollPosition((ITextViewer)iSourceViewer, (int)(object[styledText.toInt()] + n4));
                    int n7 = n6 - n4;
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (styledText2.getWordWrap()) {
                        styledText2.setTopPixel(n7);
                        continue;
                    }
                    iSourceViewer.setTopIndex(n7);
                }
            }
            finally {
                this.inScrolling = false;
            }
        }
        super.doVerticalScroll(n, n2, n3, control);
    }

    public TextEditor editor(Role role) {
        return this.contentArea(role).getEditor();
    }

    public TextEditor editor(Role role, boolean bl) {
        return this.contentArea(role).getEditor(bl);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
    }

    public boolean getCanEditReadOnly() {
        return this.canEditReadOnly;
    }

    public Color getColor(com.deltawalker.script.Delta delta, DeltaPart deltaPart) {
        boolean bl = this.deltaModel().getSelected() == delta;
        RGB rGB = DeltaColor.getColor((com.deltawalker.script.Delta)delta, (DeltaPart)deltaPart, (boolean)bl);
        return this.deltaColor().colorFromRgb(rGB);
    }

    public DiffRange getDeltaFromCursor(Role role) {
        if (role == null) {
            throw new NullPointerException("'role' cannot be null");
        }
        ISourceViewer iSourceViewer = this.viewer(role);
        Point point = iSourceViewer.getSelectedRange();
        return this.getHitDelta((ITextViewer)iSourceViewer, point.x, point.x + point.y);
    }

    public int getDeltaHeight(Role role, DiffRange diffRange) {
        return TextViewerUtil.positionHeight((ITextViewer)this.viewer(role), diffRange.position(role));
    }

    public List<DiffRange> getDeltas() {
        return this.deltaModel().getDeltas();
    }

    public EditTracker getEditTracker() {
        return this.editTracker;
    }

    public DiffRange getHitDelta(ITextViewer iTextViewer, int n, int n2) {
        DiffRange diffRange2;
        List<DiffRange> list = this.getDeltas();
        if (list.isEmpty()) {
            return null;
        }
        for (DiffRange diffRange2 : list) {
            if (!this.overlaps(diffRange2, iTextViewer, n, n2)) continue;
            return diffRange2;
        }
        if (n == n2 && n == (diffRange2 = iTextViewer.getDocument()).getLength()) {
            int n3 = diffRange2.getNumberOfLines();
            try {
                if (n3 != 0 && diffRange2.getLineLength(n3 - 1) != 0) {
                    return list.get(list.size() - 1);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    public DiffRange getHitDelta(ITextViewer iTextViewer, int n, Point point) {
        StyledText styledText = iTextViewer.getTextWidget();
        n = styledText.toControl((int)0, (int)n).y;
        Point point2 = TextViewerUtil.visibleLinePixelRange(iTextViewer);
        if (point2.y == 0) {
            return null;
        }
        int n2 = point2.x + point2.y;
        List list = this.deltaModel().getDeltas();
        Role role = ((DeltaSourceViewer)iTextViewer).role();
        if (!this.roles().contains(role)) {
            return null;
        }
        for (DiffRange diffRange : list) {
            Position position;
            if (diffRange.isSame() || (position = diffRange.position(role)) == null || position.offset < point2.x) continue;
            Point point3 = TextViewerUtil.linePixelRangeFromPosition(iTextViewer, position);
            int n3 = point3.x;
            int n4 = point3.y;
            if (n3 + n4 < 0) continue;
            if (n3 > n2) break;
            if (n4 <= 0) {
                int n5 = 10;
                n3 -= n5 / 2;
                n4 = n5;
            }
            if (n3 > n || n > n3 + n4) continue;
            if (point != null) {
                point.x = n3;
                point.y = n4;
            }
            return diffRange;
        }
        return null;
    }

    public Image getImage() {
        return ImageCache.getImage((String)ImageConst.PLAIN_TEXT);
    }

    public ITextDiffDoc getInput() {
        return (ITextDiffDoc)super.getInput();
    }

    public int getMaxDeltaHeight(DiffRange diffRange) {
        int n = TextViewerUtil.positionHeight((ITextViewer)this.viewer(Role.REF), diffRange.position(Role.REF));
        int n2 = TextViewerUtil.positionHeight((ITextViewer)this.viewer(Role.ONE), diffRange.position(Role.ONE));
        int n3 = Math.max(n, n2);
        if (this.isThreeWay()) {
            int n4 = TextViewerUtil.positionHeight((ITextViewer)this.viewer(Role.TWO), diffRange.position(Role.TWO));
            n3 = Math.max(n3, n4);
        }
        return n3;
    }

    public Relation getRelation(ITextViewer iTextViewer, boolean bl) {
        if (!this.isThreeWay()) {
            if (bl && this.viewer(Role.REF) == iTextViewer || !bl && this.viewer(Role.ONE) == iTextViewer) {
                return Relation.REF_ONE;
            }
        } else {
            boolean bl2;
            int n = this.getOrientation();
            boolean bl3 = bl2 = n == 768;
            if (this.viewer(Role.REF) == iTextViewer) {
                if (256 == n || 512 == n) {
                    return bl ? Relation.REF_TWO : Relation.ONE_REF;
                }
            } else if (this.viewer(Role.ONE) == iTextViewer) {
                if (bl) {
                    return bl2 ? Relation.ONE_TWO : Relation.ONE_REF;
                }
            } else if (this.viewer(Role.TWO) == iTextViewer && !bl) {
                return bl2 ? Relation.ONE_TWO : Relation.REF_TWO;
            }
        }
        return null;
    }

    public int getSashWidth() {
        return this.isSyncedVScrolling() ? 50 : super.getSashWidth();
    }

    public ISelection getSelection() {
        return new DiffSelection(this.deltaModel().getSelected());
    }

    public boolean hasDeltas(Set<Delta> set) {
        return this.deltaModel().hasTrueDiffs();
    }

    public boolean hasNextEdit() {
        return this.editTracker.hasNextEdit();
    }

    public boolean hasPreviousEdit() {
        return this.editTracker.hasPreviousEdit();
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Set set = Relation.roles((boolean)this.isThreeWay());
        for (Role role2 : set) {
            this.scrollable(role2).addListener(37, new Listener(){

                public void handleEvent(Event event) {
                    TextDiffView.this.onMouseWheel(event);
                }
            });
        }
        for (Role role : set) {
            Role role2;
            role2 = this.scrollable(role);
            role2.addListener(1, this.onKey);
            role2.addListener(2, this.onKey);
        }
    }

    protected void inputChanged(Object object, Object object2) {
        if (object2 != null) {
            IDiffModel iDiffModel = ((IDiffDoc)object2).diffModel(0);
            if (this.USE_MODEL_EVENTS) {
                ((IDeltaNotifier)iDiffModel).removeDeltaListener(this.onDelta);
            } else {
                this.removeDeltaListener(this.onDelta);
            }
            if (this.dbCenter != null) {
                this.dbCenter.disconnect();
            }
        }
        super.inputChanged(object, object2);
        if (object != null) {
            this.doInlineDeltas = this.preferences().getBoolean(PrefKey.T_DO_INLINE_DELTAS.toString());
            if (this.USE_MODEL_EVENTS) {
                ((IDeltaNotifier)this.deltaModel()).addDeltaListener(this.onDelta);
            } else {
                this.addDeltaListener(this.onDelta);
            }
            this.updateEditorFileExtensions((IDiffDoc)object);
        }
        if (object2 != null && object != null) {
            this.rootComposite().layout();
        }
        if (this.dbCenter != null) {
            this.dbCenter.connect((IMvcModel)object, null);
        }
    }

    protected boolean nextDelta(Goto goto_, boolean bl, Set<Delta> set) {
        Role role = this.getFocusRole();
        DiffRange diffRange = this.getDeltaFromCursor(role);
        return this.deltaModel().gotoDelta(goto_, bl, set, diffRange);
    }

    public void nextEdit() {
        this.editTracker.nextEdit();
    }

    private boolean overlaps(DiffRange diffRange, ITextViewer iTextViewer, int n, int n2) {
        Position position = diffRange.position(((DeltaSourceViewer)iTextViewer).role());
        if (position != null) {
            int n3 = position.getOffset();
            int n4 = n3 + position.getLength();
            if (n3 <= n2 && n < n4) {
                return true;
            }
        }
        return false;
    }

    public void previousEdit() {
        this.editTracker.previousEdit();
    }

    public void print(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        this.print((HeaderFooterPrintOp)new TextPrintOp(this, iPrinter, iProgressMonitor));
    }

    protected boolean propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        boolean bl = true;
        Object object = propertyChangeEvent.getSource();
        if (object instanceof IPreferenceStore) {
            IPreferenceStore iPreferenceStore = (IPreferenceStore)object;
            PrefKey prefKey = PrefKey.fromString((String)string);
            if (prefKey == null) {
                return false;
            }
            if (this.shouldRedrawDeltas(prefKey)) {
                if (string.equals(PrefKey.T_WRAP_LINES.toString())) {
                    boolean bl2 = iPreferenceStore.getBoolean(PrefKey.T_WRAP_LINES.toString());
                    for (Role role : this.roles()) {
                        this.styledText(role).setWordWrap(bl2);
                    }
                } else if (string.equals(PrefKey.T_DO_INLINE_DELTAS.toString())) {
                    this.doInlineDeltas = iPreferenceStore.getBoolean(PrefKey.T_DO_INLINE_DELTAS.toString());
                }
                this.clearStyleBackground();
                this.redrawDeltas(this.getDeltas(), true);
            } else if (string.equals(PrefKey.T_BREAK_AT_POSITION_ON.toString())) {
                if (this.docType().isCompoundDoc()) {
                    this.compare();
                }
            } else if (string.equals(PrefKey.T_USE_SINGLE_LINE.toString())) {
                this.setTextSashUseSingleLine(iPreferenceStore.getBoolean(PrefKey.T_USE_SINGLE_LINE.toString()));
            } else if (string.equals(PrefKey.F_ALLOW_READONLY_EDIT.toString())) {
                this.canEditReadOnly = false;
                IDiffViewContentProvider iDiffViewContentProvider = (IDiffViewContentProvider)this.getContentProvider();
                Role[] roleArray = Role.values();
                int n = roleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Role role = roleArray[n2];
                    this.contentArea(role).setEditable(iDiffViewContentProvider.isContentEditable((IDiffDoc)this.getInput(), role));
                    ++n2;
                }
            } else {
                bl = super.propertyChange(propertyChangeEvent);
            }
        } else if (string.equals("com.deltawalker.ui.editorFont")) {
            this.updateFont();
        } else if (string.equals("URI_INFO")) {
            if ("ERROR".equals(propertyChangeEvent.getNewValue())) {
                ITextDiffDoc iTextDiffDoc = this.getInput();
                this.dCtlr.alerts().alertForInvalidUris(iTextDiffDoc.uriInfos(), (IDiffDoc)this.getInput());
            } else {
                this.updateBrowseEntries();
                this.updateEditorFileExtensions((IDiffDoc)this.getInput());
            }
        } else if (string.equals("CONTENT")) {
            this.updateContent();
        } else {
            bl = super.propertyChange(propertyChangeEvent);
        }
        return bl;
    }

    public void redrawDeltas(List<DiffRange> list, boolean bl) {
        if (list == null) {
            throw new NullPointerException("deltas");
        }
        this.redrawControls(bl);
        this.redrawRulers();
        if (this.doInlineDeltas) {
            for (DiffRange diffRange : list) {
                this.redrawInlineDelta(diffRange);
            }
        }
    }

    public void redrawInlineDelta(DiffRange diffRange) {
        for (Role role : this.roles()) {
            StyleRange[] styleRangeArray2;
            StyledText styledText = this.styledText(role);
            Set set = diffRange.children();
            if (set == null || set.isEmpty()) continue;
            TreeSet<StyleRange> treeSet = new TreeSet<StyleRange>(StyleRangeComparator.INSTANCE);
            int n = 0;
            for (StyleRange[] styleRangeArray2 : set) {
                int n2 = styleRangeArray2.length(role);
                if (n2 == 0) {
                    ++n;
                    continue;
                }
                Color color = this.getColor((com.deltawalker.script.Delta)styleRangeArray2, DeltaPart.FG);
                Color color2 = role == Role.REF ? color : (diffRange.shouldSkipPaint(role) ? null : color);
                Position position = styleRangeArray2.position(role);
                StyleRange styleRange = new StyleRange(position.offset, position.length, null, color2);
                treeSet.add(styleRange);
            }
            styleRangeArray2 = treeSet.toArray(new StyleRange[treeSet.size()]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("redrawInlineDelta input=" + set.size() + ", skipped=" + n + ", combined=" + styleRangeArray2.length);
            }
            styledText.replaceStyleRanges(0, 0, styleRangeArray2);
        }
    }

    private void redrawRulers() {
        for (Role role : this.roles()) {
            this.editor(role).redrawRuler();
        }
    }

    public void refresh() {
        super.refresh();
        this.dbCenter.connect((IMvcModel)this.getInput(), null);
    }

    public void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
        for (Role role : Relation.roles((boolean)true)) {
            this.contentArea(role).removeFocusListener(focusListener);
        }
    }

    public void revealDelta(DiffRange diffRange, boolean bl) {
        int n;
        DiffRange diffRange22;
        Role role2;
        if (bl) {
            for (Role role2 : this.roles()) {
                ISourceViewer iSourceViewer = this.viewer(role2);
                Position position = diffRange.position(role2);
                Point point = iSourceViewer.getSelectedRange();
                if (position.offset <= point.x && point.x < position.offset + position.length) continue;
                StyledText styledText = iSourceViewer.getTextWidget();
                diffRange22 = styledText.getContent();
                int n2 = point.x - diffRange22.getOffsetAtLine(diffRange22.getLineAtOffset(point.x));
                int n3 = diffRange22.getLine(diffRange22.getLineAtOffset(position.offset)).length();
                int n4 = Math.min(n2, n3);
                styledText.setCaretOffset(position.offset + n4);
            }
        }
        role2 = this.getDeltas();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = this.isSyncedVScrolling();
        int n8 = 0;
        for (DiffRange diffRange22 : role2) {
            if (diffRange22 == diffRange) break;
            if (bl2) {
                n8 += this.getMaxDeltaHeight(diffRange22);
                continue;
            }
            n5 += TextViewerUtil.positionHeight((ITextViewer)this.viewer(Role.REF), diffRange22.position(Role.REF));
            n6 += TextViewerUtil.positionHeight((ITextViewer)this.viewer(Role.ONE), diffRange22.position(Role.ONE));
            n7 += TextViewerUtil.positionHeight((ITextViewer)this.viewer(Role.TWO), diffRange22.position(Role.TWO));
        }
        if (bl2) {
            n6 = n7 = n8;
            n5 = n7;
        }
        if ((n5 -= (n = ((diffRange22 = this.viewer(Role.REF)).getTextWidget().getWordWrap() ? TextViewerUtil.visibleLinePixelRange((ITextViewer)diffRange22).y : TextViewerUtil.visibleLineCount((ITextViewer)diffRange22)) / 2)) < 0) {
            n5 = 0;
        }
        if ((n6 -= n) < 0) {
            n6 = 0;
        }
        if ((n7 -= n) < 0) {
            n7 = 0;
        }
        this.doVerticalScroll(n5, n6, n7, null);
        ScrollBar scrollBar = this.commonScrollBar();
        if (scrollBar != null) {
            scrollBar.setSelection(n6);
        }
        for (Role role3 : this.roles()) {
            StyledText styledText = this.styledText(role3);
            if (bl) {
                styledText.showSelection();
                continue;
            }
            styledText.setHorizontalIndex(0);
        }
    }

    protected void scrollOther(Role role, Role role2, ScrollBar scrollBar, int n) {
        this.styledText(role2).setHorizontalPixel(n);
    }

    public void setCanEditReadOnly(boolean bl) {
        this.canEditReadOnly = bl;
    }

    private void setTextSashUseSingleLine(boolean bl) {
        Map map = this.verticalSashes();
        for (Control control : map.values()) {
            ((TextSash)control).setUseSingleLine(bl);
        }
    }

    public boolean shouldDoInlineDeltas() {
        return this.doInlineDeltas;
    }

    protected DiffView.Recompare shouldRecompare(IPreferenceStore iPreferenceStore, PrefKey prefKey, boolean bl) {
        switch (prefKey) {
            case C_FOLLOW_SYMLINKS: 
            case C_USE_OPTIMAL_DIFFERENCER: {
                return DiffView.Recompare.FULL;
            }
        }
        return DiffView.Recompare.NONE;
    }

    private boolean shouldRedrawDeltas(PrefKey prefKey) {
        switch (prefKey) {
            case T_DO_INLINE_DELTAS: 
            case T_WRAP_LINES: {
                return true;
            }
        }
        return false;
    }

    private StyledText styledText(Role role) {
        return this.viewer(role).getTextWidget();
    }

    public void syncViewport(ITextViewer iTextViewer, int n) {
        ScrollBar scrollBar;
        if (this.inScrolling) {
            return;
        }
        if (this.isSyncedVScrolling()) {
            int n2 = 0;
            StyledText styledText = iTextViewer.getTextWidget();
            if (styledText.getWordWrap()) {
                n2 = this.computeVirtualScrollPosition(iTextViewer, n);
            } else {
                int n3 = this.computeVirtualScrollPosition(iTextViewer, iTextViewer.getTopIndex());
                n2 = Math.max(0, Math.min(n3, this.computeTotalDeltaHeight() - TextViewerUtil.visibleLineCount(iTextViewer)));
            }
            this.doVerticalScroll(n2, n2, n2, (Control)styledText);
            this.sbCommon.setSelection(n2);
        }
        if (this.isSyncedHScrolling() && (scrollBar = iTextViewer.getTextWidget().getHorizontalBar()) != null) {
            scrollBar.notifyListeners(13, null);
        }
    }

    protected void updateColors() {
        super.updateColors();
        this.redrawDeltas(this.getDeltas(), true);
    }

    public void updateCommonScrollBar() {
        if (this.isSyncedVScrolling()) {
            ISourceViewer iSourceViewer = this.viewer(Role.REF);
            StyledText styledText = iSourceViewer.getTextWidget();
            Composite composite = this.getControl();
            composite.getDisplay().asyncExec(new Runnable((Control)composite, styledText, (ITextViewer)iSourceViewer){
                private final /* synthetic */ Control val$ctl;
                private final /* synthetic */ StyledText val$stText;
                private final /* synthetic */ ITextViewer val$tViewer;
                {
                    this.val$ctl = control;
                    this.val$stText = styledText;
                    this.val$tViewer = iTextViewer;
                }

                @Override
                public void run() {
                    int n;
                    if (this.val$ctl.isDisposed()) {
                        return;
                    }
                    int n2 = 0;
                    n2 = this.val$stText.getWordWrap() ? this.val$stText.getClientArea().height : TextViewerUtil.visibleLineCount(this.val$tViewer);
                    int n3 = TextDiffView.this.computeTotalDeltaHeight();
                    if (n3 < 1) {
                        n3 = 1;
                    }
                    int n4 = n2;
                    int n5 = n = n2 > n3 ? n3 : n2;
                    if (n < 1) {
                        n = 1;
                    }
                    TextDiffView.this.sbCommon.setMaximum(n3);
                    TextDiffView.this.sbCommon.setPageIncrement(n4);
                    TextDiffView.this.sbCommon.setThumb(n);
                }
            });
        }
    }

    protected void updateContent() {
        super.updateContent();
        for (Role role : this.roles()) {
            TextDoc textDoc = (TextDoc)this.doc(role);
            TextContentArea textContentArea = this.contentArea(role);
            textContentArea.setEditable(!DocType.PREVIEW.equals((Object)textDoc.docType()) && textDoc.isModifiable());
            textContentArea.setInput(textDoc);
        }
    }

    private void updateEditorFileExtensions(IDiffDoc iDiffDoc) {
        Map map = iDiffDoc.fileExtensions();
        for (Map.Entry entry : map.entrySet()) {
            TextContentArea textContentArea = this.contentArea((Role)entry.getKey());
            if (textContentArea == null) continue;
            textContentArea.getEditor().setFileExtension((String)entry.getValue());
        }
    }

    private void updateFont() {
        Font font = JFaceResources.getFont((String)"com.deltawalker.ui.editorFont");
        Set set = Relation.roles((boolean)this.isThreeWay());
        for (Role role : set) {
            ISourceViewer iSourceViewer = this.viewer(role);
            if (!(iSourceViewer instanceof DeltaSourceViewer)) continue;
            ((DeltaSourceViewer)iSourceViewer).setFont(font);
        }
    }

    public ISourceViewer viewer(Role role) {
        return this.editor(role).sourceViewer();
    }
}

