/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.ui;

import com.deltawalker.Msg;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.ITextDiffDoc;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.text.ITextDoc;
import com.deltawalker.text.TextDiffModel;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.text.internal.ui.OperationHistoryHandler;
import com.deltawalker.text.internal.ui.TextSummaryStatusLineGroup;
import com.deltawalker.text.internal.ui.actions.ConvertLineEndingsAction;
import com.deltawalker.text.internal.ui.actions.ReopenWithEncodingAction;
import com.deltawalker.text.internal.ui.actions.TransformXmlAction;
import com.deltawalker.text.ui.TextAlerts;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.SummaryStatusLineGroup;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.actions.GotoConflictAction;
import com.deltawalker.ui.actions.GotoDiffAction;
import com.deltawalker.ui.actions.GotoEditAction;
import com.deltawalker.ui.actions.MergeNonConflictsAction;
import com.deltawalker.ui.actions.ShowInAction;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.io.xml.XmlTransformer;
import com.deltopia.util.OS;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.ui.IActionBars;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDiffController
extends DiffController {
    private static final Logger LOG = LoggerFactory.getLogger(TextDiffController.class);
    private OperationHistoryHandler undoHandler;

    public TextAlerts alerts() {
        if (this.alerts == null) {
            this.alerts = new TextAlerts(this);
        }
        return (TextAlerts)this.alerts;
    }

    public void connect(IMvcModel iMvcModel, IMvcView iMvcView) {
        if (!ObjectUtil.areEqual((Object)iMvcModel, (Object)this.model())) {
            super.connect(iMvcModel, iMvcView);
            if (this.undoHandler == null) {
                this.undoHandler = new OperationHistoryHandler(this.view());
            } else {
                this.undoHandler.clear();
            }
        }
    }

    public IDiffModel createDiffModel() {
        return new TextDiffModel((IDiffDoc)this.model());
    }

    protected SummaryStatusLineGroup createSummaryPanels() {
        return new TextSummaryStatusLineGroup(this.view().getSite().getShell(), this.getActionBars());
    }

    protected void disconnectIndividualGlobalActions(IActionBars iActionBars) {
        super.disconnectIndividualGlobalActions(iActionBars);
        iActionBars.setGlobalActionHandler("setEncoding", null);
        iActionBars.setGlobalActionHandler("convertLineEndingsToWindows", null);
        iActionBars.setGlobalActionHandler("convertLineEndingsToMacOS9", null);
        iActionBars.setGlobalActionHandler("convertLineEndingsToUnix", null);
    }

    public void dispose() {
        try {
            if (this.undoHandler != null) {
                this.undoHandler.dispose();
                this.undoHandler = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    protected void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.showEncodingInStatusLine();
    }

    protected void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.getActionBars().getStatusLineManager().setMessage("");
    }

    protected String getIntroMessageText() {
        return TextMsg.TextView_introMsg;
    }

    protected void makeActions() {
        super.makeActions();
        TextDiffView textDiffView = this.view();
        this.addAction((IAction)new ConvertLineEndingsAction("\r\n", textDiffView));
        this.addAction((IAction)new ConvertLineEndingsAction("\n", textDiffView));
        this.addAction((IAction)new ConvertLineEndingsAction("\r", textDiffView));
        this.addAction((IAction)new ReopenWithEncodingAction(TextMsg.constructedKeyBundle(), textDiffView));
        this.addAction((IAction)new TransformXmlAction(TextMsg.constructedKeyBundle(), textDiffView, XmlTransformer.Op.PRETTIFY));
        this.addAction((IAction)new TransformXmlAction(TextMsg.constructedKeyBundle(), textDiffView, XmlTransformer.Op.CANONICALIZE));
        this.addAction((IAction)new ReopenWithEncodingAction(TextMsg.constructedKeyBundle(), textDiffView));
        this.addAction((IAction)new ShowInAction((DiffView)textDiffView, UIMsg.constructedKeyBundle()));
        ResourceBundle resourceBundle = TextMsg.constructedKeyBundle();
        this.addAction((IAction)new GotoDiffAction(resourceBundle, Goto.NEXT, (DiffView)textDiffView, false));
        this.addAction((IAction)new GotoDiffAction(resourceBundle, Goto.PREVIOUS, (DiffView)textDiffView, false));
        this.addAction((IAction)new GotoConflictAction(resourceBundle, Goto.NEXT, (DiffView)textDiffView, false));
        this.addAction((IAction)new GotoConflictAction(resourceBundle, Goto.PREVIOUS, (DiffView)textDiffView, false));
        ResourceBundle resourceBundle2 = Msg.constructedKeyBundle();
        this.addAction((IAction)new MergeNonConflictsAction(resourceBundle2, (DiffView)textDiffView, false));
        if (OS.COCOA) {
            this.addAction((IAction)new GotoDiffAction(resourceBundle, Goto.NEXT, (DiffView)textDiffView, true));
            this.addAction((IAction)new GotoDiffAction(resourceBundle, Goto.PREVIOUS, (DiffView)textDiffView, true));
            this.addAction((IAction)new GotoConflictAction(resourceBundle, Goto.NEXT, (DiffView)textDiffView, true));
            this.addAction((IAction)new GotoConflictAction(resourceBundle, Goto.PREVIOUS, (DiffView)textDiffView, true));
            this.addAction((IAction)new MergeNonConflictsAction(resourceBundle2, (DiffView)textDiffView, true));
        }
        this.initializeGotoDiffButtons();
        this.addAction((IAction)new GotoEditAction(Goto.NEXT, (DiffView)textDiffView));
        this.addAction((IAction)new GotoEditAction(Goto.PREVIOUS, (DiffView)textDiffView));
    }

    public ITextDiffDoc model() {
        return (ITextDiffDoc)super.model();
    }

    private void showEncodingInStatusLine() {
        TextDiffView textDiffView = this.view();
        Role role = textDiffView.getFocusRole();
        if (role != null) {
            ITextDoc iTextDoc = (ITextDoc)textDiffView.getInput().doc(0, role);
            IResource iResource = iTextDoc.resource();
            if (iResource == null) {
                return;
            }
            try {
                if (!iResource.contentType().isText(false)) {
                    return;
                }
            }
            catch (IOException iOException) {
                LOG.warn("Couldn't determine content type", (Throwable)iOException);
                return;
            }
            Locale locale = iTextDoc.getLocale();
            String string = "";
            if (locale != null) {
                string = locale.getDisplayName();
            } else {
                String string2 = iTextDoc.getEncoding().charset();
                if (string2.isEmpty()) {
                    return;
                }
                try {
                    Charset charset = Charset.forName(string2);
                    string = charset.name();
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    LOG.warn("Unsupported charset name: " + string2, (Throwable)unsupportedCharsetException);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    LOG.warn("Illegal charset name: " + string2, (Throwable)illegalCharsetNameException);
                }
            }
            if (!StringUtil.isEmpty((String)string)) {
                this.getActionBars().getStatusLineManager().setMessage(string);
            }
        }
    }

    public TextDiffView view() {
        return (TextDiffView)super.view();
    }
}

