/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.editor;

import com.deltawalker.DocType;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.text.ITextDoc;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.text.internal.ui.DeltaSourceViewer;
import com.deltawalker.text.internal.ui.EmptyRulerColumn;
import com.deltawalker.text.internal.ui.TextViewerUtil;
import com.deltawalker.text.internal.ui.editor.TextDocumentProvider;
import com.deltawalker.text.source.SourceViewerConfig;
import com.deltawalker.text.ui.TextDiffController;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.actions.ActionMaker;
import com.deltawalker.ui.actions.TogglePrefAction;
import com.deltopia.io.ContentType;
import com.deltopia.util.IDisposable;
import com.deltopia.util.OS;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class TextEditor
extends org.eclipse.ui.editors.text.TextEditor {
    private static final String[] TEXT_PREF_PAGES = new String[]{"com.deltawalker.text.AllPrefPage", "com.deltawalker.text.TextFiltersPrefPage"};
    private final IDocumentListener onDocument = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            IAction iAction = TextEditor.this.getAction("save");
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
        }
    };
    private final Role role;
    private TextDiffView tdView;

    public TextEditor(TextDiffView textDiffView, Role role) {
        this.tdView = textDiffView;
        this.role = role;
        this.setDocumentProvider((IDocumentProvider)new TextDocumentProvider(textDiffView.getInput().preferences()));
        DeltaColor.syncQuickdiffColors();
        this.setCompatibilityMode(false);
    }

    protected void adjustHighlightRange(int n, int n2) {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            iTextViewerExtension5.exposeModelRange((IRegion)new Region(n, n2));
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        return TEXT_PREF_PAGES;
    }

    protected CompositeRuler createCompositeRuler() {
        CompositeRuler compositeRuler = new CompositeRuler(){

            public void addDecorator(int n, IVerticalRulerColumn iVerticalRulerColumn) {
                super.addDecorator(n, iVerticalRulerColumn);
                if (!(iVerticalRulerColumn instanceof EmptyRulerColumn)) {
                    int n2 = 0;
                    Iterator iterator = this.getDecoratorIterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() instanceof EmptyRulerColumn) {
                            this.removeDecorator(n2);
                            break;
                        }
                        ++n2;
                    }
                    n2 = 0;
                    iterator = this.getDecoratorIterator();
                    while (iterator.hasNext()) {
                        ++n2;
                        iterator.next();
                    }
                    this.addDecorator(n2, new EmptyRulerColumn());
                }
            }
        };
        return compositeRuler;
    }

    public void createPartControl(Composite composite) {
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (sourceViewerConfiguration instanceof SourceViewerConfig) {
            String string = "";
            if (this.tdView != null) {
                Map map = this.tdView.getInput().fileExtensions();
                string = (String)map.get(this.role);
            }
            ((SourceViewerConfig)sourceViewerConfiguration).setFileExtension(string);
        }
        super.createPartControl(composite);
        this.installRulerLinePainter();
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        DeltaSourceViewer deltaSourceViewer = new DeltaSourceViewer(composite, iVerticalRuler, n, this.tdView, this.role);
        this.getSourceViewerDecorationSupport((ISourceViewer)deltaSourceViewer);
        return deltaSourceViewer;
    }

    public void dispose() {
        try {
            SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
            if (sourceViewerConfiguration instanceof IDisposable) {
                ((IDisposable)sourceViewerConfiguration).dispose();
            }
            ((ITextDoc)this.getEditorInput()).document().removeDocumentListener(this.onDocument);
            this.tdView = null;
        }
        finally {
            super.dispose();
        }
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        IDocument iDocument;
        IEditorInput iEditorInput2 = this.getEditorInput();
        if (iEditorInput != iEditorInput2) {
            super.doSetInput(iEditorInput);
            if (iEditorInput2 != null) {
                iDocument = ((ITextDoc)iEditorInput2).document();
                iDocument.removeDocumentListener(this.onDocument);
            }
        }
        if (iEditorInput != null) {
            iDocument = ((ITextDoc)iEditorInput).document();
            iDocument.addDocumentListener(this.onDocument);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        if (this.tdView.docType() == DocType.PREVIEW) {
            return;
        }
        iMenuManager.add((IContributionItem)new Separator("group.encoding"));
        iMenuManager.add((IContributionItem)new Separator("group.open"));
        iMenuManager.add((IContributionItem)new Separator("group.undo"));
        iMenuManager.add((IContributionItem)new Separator("group.copy"));
        iMenuManager.add((IContributionItem)new Separator("group.save"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        TextDiffController textDiffController = this.tdView.controller();
        if (this.isEditable()) {
            Role role = this.tdView.getFocusRole();
            boolean bl = false;
            if (role != null) {
                boolean bl2 = bl = this.tdView.getInput().doc(0, role).resource() != null;
            }
            if (bl) {
                iMenuManager.appendToGroup("group.encoding", textDiffController.getAction("setEncoding"));
            }
            if (textDiffController.model().contentType() == ContentType.TEXT_XML) {
                iMenuManager.appendToGroup("group.encoding", (IContributionItem)new Separator());
                iMenuManager.appendToGroup("group.encoding", textDiffController.getAction("prettifyXml"));
                iMenuManager.appendToGroup("group.encoding", textDiffController.getAction("canonicalizeXml"));
            }
            if (bl) {
                iMenuManager.appendToGroup("group.open", textDiffController.getAction("showIn"));
            }
            this.addAction(iMenuManager, "group.undo", ActionFactory.UNDO.getId());
            this.addAction(iMenuManager, "group.undo", ActionFactory.REDO.getId());
            this.addAction(iMenuManager, "group.copy", ActionFactory.CUT.getId());
            this.addAction(iMenuManager, "group.copy", ActionFactory.COPY.getId());
            this.addAction(iMenuManager, "group.copy", ActionFactory.PASTE.getId());
            this.addAction(iMenuManager, "group.copy", ActionFactory.SELECT_ALL.getId());
            iMenuManager.appendToGroup("group.copy", (IContributionItem)new Separator());
            if (textDiffController.model().isThreeWay()) {
                iMenuManager.appendToGroup("group.copy", textDiffController.getAction("mergeNonConflicts"));
            }
            iMenuManager.appendToGroup("group.save", textDiffController.getAction("saveAs"));
            iMenuManager.appendToGroup("group.save", textDiffController.getAction("saveAsRemote"));
        } else {
            iMenuManager.appendToGroup("group.open", textDiffController.getAction("showIn"));
            this.addAction(iMenuManager, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(iMenuManager, "group.copy", ITextEditorActionConstants.SELECT_ALL);
        }
        iMenuManager.appendToGroup("additions", (IContributionItem)new Separator("settings"));
        iMenuManager.appendToGroup("additions", textDiffController.getAction("createReportHtml"));
        iMenuManager.appendToGroup("additions", textDiffController.getAction("compareSummary"));
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new SourceViewerConfig(""));
    }

    private void installRulerLinePainter() {
        CompositeRuler compositeRuler = (CompositeRuler)this.getVerticalRuler();
        compositeRuler.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TextEditor.this.paintVerticalRulerColumn(paintEvent);
            }
        });
        Color color = this.getSourceViewer().getTextWidget().getBackground();
        Iterator iterator = compositeRuler.getDecoratorIterator();
        while (iterator.hasNext()) {
            ((IVerticalRulerColumn)iterator.next()).getControl().setBackground(color);
        }
    }

    private void paintVerticalRulerColumn(PaintEvent paintEvent) {
        boolean bl = this.tdView.isThreeWay();
        if (!bl && this.role == Role.TWO) {
            return;
        }
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (!(iSourceViewer instanceof DeltaSourceViewer)) {
            return;
        }
        ITextDiffModel iTextDiffModel = this.tdView.deltaModel();
        List list = iTextDiffModel.getDeltas();
        GC gC = paintEvent.gc;
        int n = paintEvent.height;
        int n2 = paintEvent.width;
        int n3 = paintEvent.y + paintEvent.height;
        Role role = ((DeltaSourceViewer)iSourceViewer).role();
        Point point = TextViewerUtil.visibleLinePixelRange((ITextViewer)iSourceViewer);
        for (DiffRange diffRange : list) {
            Position position;
            if (diffRange.shouldSkipPaint(role) || (position = diffRange.position(role)) == null || position.offset < point.x) continue;
            Point point2 = TextViewerUtil.linePixelRangeFromPosition((ITextViewer)iSourceViewer, diffRange.position(role));
            if (point2.x + point2.y < 0) continue;
            if (point2.x > n3) break;
            int n4 = point2.x + 1;
            int n5 = point2.y;
            gC.setBackground(this.tdView.getColor((Delta)diffRange, DeltaPart.FG));
            if (n4 > n) continue;
            gC.fillRectangle(0, n4 - 1, n2, 1);
            gC.fillRectangle(0, n4 + n5 - 1, n2, 1);
        }
    }

    public void redrawRuler() {
        CompositeRuler compositeRuler = (CompositeRuler)this.getVerticalRuler();
        Iterator iterator = compositeRuler.getDecoratorIterator();
        while (iterator.hasNext()) {
            ((IVerticalRulerColumn)iterator.next()).getControl().redraw();
        }
    }

    public final Role role() {
        return this.role;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.removeAll();
        ResourceBundle resourceBundle = TextMsg.constructedKeyBundle();
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        TogglePrefAction togglePrefAction = new TogglePrefAction(resourceBundle, "TogglePrefAction_showLineNumbers.", iPreferenceStore, "lineNumberRuler");
        iMenuManager.add((IAction)togglePrefAction);
        iMenuManager.update(true);
    }

    public void setAction(String string, IAction iAction) {
        if (OS.OSX && (string.equals(ActionMaker.UNDO.getId()) || string.equals(ActionMaker.REDO.getId()))) {
            iAction.setImageDescriptor(null);
            iAction.setDisabledImageDescriptor(null);
        }
        super.setAction(string, iAction);
    }

    public void setFileExtension(String string) {
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (sourceViewerConfiguration instanceof SourceViewerConfig) {
            SourceViewerConfig sourceViewerConfig = (SourceViewerConfig)sourceViewerConfiguration;
            if (!string.isEmpty() && !string.equals(sourceViewerConfig.getFileExtension())) {
                sourceViewerConfig.setFileExtension(string);
                ISourceViewer iSourceViewer = this.sourceViewer();
                if (iSourceViewer instanceof ISourceViewerExtension2) {
                    ((ISourceViewerExtension2)iSourceViewer).unconfigure();
                    iSourceViewer.configure(sourceViewerConfiguration);
                }
            }
        }
    }

    public ISourceViewer sourceViewer() {
        return this.getSourceViewer();
    }

    public boolean validateEditorInputState() {
        return this.isEditorInputModifiable();
    }
}

