/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.editor;

import com.deltawalker.EncodingUtil;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.resources.IResource;
import com.deltawalker.text.ITextDoc;
import com.deltawalker.text.source.BlockScanner;
import com.deltawalker.text.source.SourceConfig;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;

public class TextDocumentProvider
extends FileDocumentProvider
implements IStorageDocumentProvider {
    private String fileExt = "";
    private final IPreferenceStore prefs;

    public TextDocumentProvider(IPreferenceStore iPreferenceStore) {
        this.prefs = iPreferenceStore;
    }

    protected IAnnotationModel createAnnotationModel(Object object) throws CoreException {
        return new AnnotationModel();
    }

    protected IDocument createDocument(Object object) throws CoreException {
        BlockScanner blockScanner;
        ITextDoc iTextDoc = (ITextDoc)object;
        IDocument iDocument = iTextDoc.document();
        IResource iResource = iTextDoc.resource();
        if (iResource != null) {
            this.fileExt = iResource.getExtension();
        }
        if (SourceConfig.isKnownFileExtension((String)this.fileExt) && (blockScanner = SourceConfig.blockScanner((String)this.fileExt)) != null) {
            FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)blockScanner, SourceConfig.blockIds((String)this.fileExt));
            iDocument.setDocumentPartitioner((IDocumentPartitioner)fastPartitioner);
            fastPartitioner.connect(iDocument);
        }
        return iDocument;
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String getDefaultEncoding() {
        return EncodingUtil.getEncoding((IPreferenceStore)this.prefs);
    }

    public String getEncoding(Object object) {
        String string = "";
        if (object instanceof ITextDoc) {
            string = ((ITextDoc)object).getEncoding().charset();
        }
        return string;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor iProgressMonitor) {
        return null;
    }

    public boolean isModifiable(Object object) {
        if (object instanceof IDoc) {
            return ((IDoc)object).isModifiable();
        }
        return true;
    }

    public boolean isReadOnly(Object object) {
        if (object instanceof IDoc) {
            return !((IDoc)object).isWritable();
        }
        return false;
    }

    public void setEncoding(Object object, String string) {
        if (object instanceof ITextDoc) {
            ((ITextDoc)object).setEncoding(string, false);
        }
    }
}

