/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.BoldFontCache;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.text.internal.TextContextId;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.ui.EncodingChooser;
import com.deltawalker.ui.LineEndingChooser;
import com.deltawalker.ui.OverlayPrefStore;
import com.deltawalker.ui.UIUtil;
import com.deltopia.jface.util.DialogUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class TextPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button chbAllowEdit;
    private Button chbChangeAlert;
    private Button chbDeleteAlert;
    private Button chbEndings;
    private EncodingChooser csChooser;
    private LineEndingChooser endingChooser;
    private SelectionListener onSelect = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            String string = (String)button.getData();
            TextPrefPage.this.overlayPrefs.setValue(string, button.getSelection());
        }
    };
    private static final OverlayPrefStore.OverlayKey[] OVERLAY_KEYS = new OverlayPrefStore.OverlayKey[]{new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.F_ALLOW_READONLY_EDIT.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.F_ENABLE_CHANGE_ALERTS.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.F_ENABLE_DELETE_ALERTS.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.T_USE_LOCALE.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.STRING, PrefKey.T_ENCODING_CHARSET.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.STRING, PrefKey.T_ENCODING_LOCALE.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.STRING, PrefKey.T_LINE_ENDING.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.T_BREAK_AT_POSITION_ON.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.INT, PrefKey.T_BREAK_AT_POSITION.toString())};
    private OverlayPrefStore overlayPrefs;
    private Spinner spnEndingPos;

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, TextContextId.TEXT_PREF_PAGE);
        this.overlayPrefs = new OverlayPrefStore(PrefUtil.getGlobalPrefs(), OVERLAY_KEYS);
        this.overlayPrefs.load();
        this.overlayPrefs.start();
        Composite composite2 = DialogUtil.createPageComposite((Composite)composite);
        this.createControls(composite2);
        this.installListeners(true);
        DialogUtil.initializeFromPrefsAndNotify((Control)this.getControl(), (IPreferenceStore)this.overlayPrefs);
        this.applyDialogFont(composite2);
        return composite2;
    }

    private void createControls(Composite composite) {
        this.createEditingControls(DialogUtil.createPageComposite((Composite)composite));
        DialogUtil.insertSpace((Composite)composite, (boolean)true);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        label.setFont(BoldFontCache.get((Font)label.getFont()));
        label.setText("New text file:");
        Composite composite2 = DialogUtil.createIndentComposite((Composite)composite, (int)2, (int)1);
        this.createEncodingControls(composite2);
        this.createEndingControls(composite2);
        DialogUtil.insertSpace((Composite)composite, (boolean)true);
        this.createDocumentControls(composite);
    }

    private void createEndingControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(TextMsg.TextPrefPage_newEnding);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        this.endingChooser = new LineEndingChooser(composite, 12, true, false, (IPreferenceStore)this.overlayPrefs);
    }

    private void createDocumentControls(Composite composite) {
        Composite composite2 = DialogUtil.createPageComposite((Composite)composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.chbEndings = new Button(composite2, 32);
        this.chbEndings.setText(TextMsg.TextPrefPage_breakLines);
        this.chbEndings.addSelectionListener(this.onSelect);
        this.chbEndings.setData((Object)PrefKey.T_BREAK_AT_POSITION_ON.toString());
        this.chbEndings.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.spnEndingPos = new Spinner(composite2, 2048);
        this.spnEndingPos.setMaximum(10000);
        this.spnEndingPos.setData((Object)PrefKey.T_BREAK_AT_POSITION.toString());
        this.spnEndingPos.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.spnEndingPos.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextPrefPage.this.overlayPrefs.setValue(PrefKey.T_BREAK_AT_POSITION.toString(), TextPrefPage.this.spnEndingPos.getSelection());
            }
        });
        this.chbEndings.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TextPrefPage.this.spnEndingPos.setEnabled(TextPrefPage.this.overlayPrefs.getBoolean(PrefKey.T_BREAK_AT_POSITION_ON.toString()));
            }
        });
    }

    private void createEditingControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.chbAllowEdit = new Button(composite2, 32);
        this.chbAllowEdit.setText(TextMsg.TextPrefPage_canEditReadOnly);
        this.chbAllowEdit.setData((Object)PrefKey.F_ALLOW_READONLY_EDIT.toString());
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.chbAllowEdit.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.chbChangeAlert = new Button(composite2, 32);
        this.chbChangeAlert.setText(TextMsg.TextPrefPage_changeAlert);
        this.chbChangeAlert.setData((Object)PrefKey.F_ENABLE_CHANGE_ALERTS.toString());
        this.chbChangeAlert.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.chbDeleteAlert = new Button(composite2, 32);
        this.chbDeleteAlert.setText(TextMsg.TextPrefPage_deleteAlert);
        this.chbDeleteAlert.setData((Object)PrefKey.F_ENABLE_DELETE_ALERTS.toString());
        this.chbDeleteAlert.setLayoutData((Object)gridData);
    }

    private void createEncodingControls(Composite composite) {
        GridLayout gridLayout = DialogUtil.createGridLayout((int)1, (int)5, (int)5, (int)5);
        gridLayout.numColumns = 2;
        gridLayout.marginRight = 0;
        Label label = new Label(composite, 0);
        label.setText(TextMsg.TextPrefPage_newEncoding);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        this.csChooser = new EncodingChooser(composite, 12, true, false, (IPreferenceStore)this.overlayPrefs);
    }

    public void dispose() {
        if (this.overlayPrefs != null) {
            this.overlayPrefs.stop();
            this.overlayPrefs = null;
        }
        this.installListeners(false);
        super.dispose();
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void installListeners(boolean bl) {
        if (bl) {
            this.chbAllowEdit.addSelectionListener(this.onSelect);
            this.chbChangeAlert.addSelectionListener(this.onSelect);
            this.chbDeleteAlert.addSelectionListener(this.onSelect);
        } else {
            this.chbAllowEdit.removeSelectionListener(this.onSelect);
            this.chbChangeAlert.removeSelectionListener(this.onSelect);
            this.chbDeleteAlert.removeSelectionListener(this.onSelect);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.overlayPrefs.loadDefaults();
        this.csChooser.performDefaults();
        this.endingChooser.performDefaults();
        DialogUtil.initializeFromPrefsAndNotify((Control)this.getControl(), (IPreferenceStore)this.overlayPrefs);
        App.instance().stateBoss().saveState();
    }

    public void performHelp() {
        UIUtil.showHelp((String)"text-comparisons", (UIUtil.HelpContext)UIUtil.HelpContext.PREF_PAGE);
    }

    public boolean performOk() {
        this.csChooser.toPrefs();
        this.endingChooser.saveToPreferences();
        this.overlayPrefs.propagate();
        App.instance().stateBoss().saveState();
        return true;
    }
}

