/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.dialogs;

import com.deltawalker.DocType;
import com.deltawalker.FilterTable;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.script.Filter;
import com.deltawalker.text.TextFilter;
import com.deltawalker.text.internal.TextContextId;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.text.internal.ui.dialogs.TextFilterDialog;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.BaseFiltersPrefPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TextFiltersPrefPage
extends BaseFiltersPrefPage {
    protected Control createContents(Composite composite) {
        UIUtil.setHelpContextId((Control)composite, (String)TextContextId.TEXT_FILTERS_PREF_PAGE);
        return super.createContents(composite);
    }

    protected void createFilterTable(Composite composite) {
        this.filterTable = new FilterTable(composite, 0, this.overlayFilters()){

            protected String getColumnText(Object object, int n) {
                ITextFilter iTextFilter = (ITextFilter)object;
                switch (n) {
                    case 0: {
                        return iTextFilter.getDescription();
                    }
                    case 1: {
                        return TextFilter.regexToDisplayString((String)iTextFilter.getExpression());
                    }
                    case 2: {
                        return iTextFilter.target().toString();
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return "";
            }

            protected Object[] getFilterElements(List<IFilter> list) {
                ArrayList<IFilter> arrayList = new ArrayList<IFilter>(list.size());
                for (IFilter iFilter : list) {
                    if (!(iFilter instanceof ITextFilter) || !((ITextFilter)iFilter).isVisible()) continue;
                    arrayList.add(iFilter);
                }
                return arrayList.toArray();
            }

            protected void setupTable(Table table) {
                TableColumn tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(TextMsg.TextFiltersPrefPage_description);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(30));
                tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(TextMsg.TextFiltersPrefPage_expression);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(50));
                tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(TextMsg.TextFiltersPrefPage_target);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(15));
            }
        };
        this.filterTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filterTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TextFiltersPrefPage.this.updateToolBarItems();
            }
        });
    }

    protected void createNewItem(ToolBar toolBar) {
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setText(BaseFiltersPrefPage.Item.NEW.toString());
    }

    protected DocType docType() {
        return DocType.TEXT;
    }

    protected void handleEdit() {
        this.showFilterDialog(false);
    }

    protected void handleNew(ToolItem toolItem) {
        this.showFilterDialog(true);
    }

    public void performHelp() {
        UIUtil.showHelp((String)"all-comparisons-text-filters", (UIUtil.HelpContext)UIUtil.HelpContext.PREF_PAGE);
    }

    public boolean performOk() {
        this.activeFilters().makeSame(this.overlayFilters());
        return true;
    }

    protected ITextFilter selectedFilter() {
        return (ITextFilter)super.selectedFilter();
    }

    protected void showFilterDialog(boolean bl) {
        ITextFilter iTextFilter;
        ITextFilter iTextFilter2 = bl ? null : this.selectedFilter();
        TextFilterDialog textFilterDialog = new TextFilterDialog(this.getShell(), iTextFilter2);
        if (textFilterDialog.open() == 0 && (iTextFilter = textFilterDialog.filter()) != null) {
            IFilters iFilters = this.overlayFilters();
            if (bl) {
                iFilters.add((Filter)iTextFilter);
            } else if (iTextFilter2.equals(iTextFilter)) {
                iFilters.updateEnabled((IFilter)iTextFilter, true);
            } else {
                iFilters.replace((IFilter)iTextFilter2, (IFilter)iTextFilter, false);
            }
            this.filterTable.refresh(null);
        }
        this.filterTable.setFocus();
    }

    protected void updateToolBarItems() {
        ToolItem[] toolItemArray;
        if (this.toolBar.isDisposed()) {
            return;
        }
        ITextFilter iTextFilter = this.selectedFilter();
        boolean bl = iTextFilter != null;
        ToolItem[] toolItemArray2 = toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray2[n2];
            int n3 = this.toolBar.indexOf(toolItem);
            if (n3 == BaseFiltersPrefPage.Item.EDIT.id() || n3 == BaseFiltersPrefPage.Item.DELETE.id()) {
                toolItem.setEnabled(bl);
            }
            ++n2;
        }
    }
}

