/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.dialogs;

import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.text.TextFilter;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.AlertTrayDialog;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextFilterDialog
extends AlertTrayDialog {
    private Button btnChar;
    private Button btnLine;
    private ITextFilter filter;
    private Text txtDescription;
    private Text txtRegex;

    public TextFilterDialog(Shell shell, ITextFilter iTextFilter) {
        super(shell);
        this.filter = iTextFilter;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.filter == null ? UIMsg.BaseFiltersPrefPage_newFilter : UIMsg.BaseFiltersPrefPage_editFilter);
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        if (n == 0) {
            button.setEnabled(this.txtRegex.getText().length() > 0);
        }
        return button;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridData)composite2.getLayoutData()).heightHint = 140;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(composite3, 64);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label.setText(TextMsg.RegexFilterDialog_expression);
        this.txtRegex = new Text(composite3, 2052);
        this.txtRegex.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtRegex.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Button button = TextFilterDialog.this.getButton(0);
                if (button != null) {
                    button.setEnabled(TextFilterDialog.this.txtRegex.getText().length() > 0);
                }
            }
        });
        Label label2 = new Label(composite3, 64);
        label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label2.setText(TextMsg.RegexFilterDialog_description);
        this.txtDescription = new Text(composite3, 2052);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.filter != null) {
            this.txtRegex.setText(TextFilter.regexToDisplayString((String)this.filter.getExpression()));
            this.txtDescription.setText(this.filter.getDescription());
        }
        this.btnLine = new Button(composite2, 16);
        this.btnLine.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnLine.setText(TextMsg.RegexFilterDialog_forceLine);
        this.btnChar = new Button(composite2, 16);
        this.btnChar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnChar.setText(TextMsg.RegexFilterDialog_ignoreChars);
        if (this.filter != null && this.filter.target() == TextFilter.Target.CHARS) {
            this.btnChar.setSelection(true);
        } else {
            this.btnLine.setSelection(true);
        }
        TextFilterDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public ITextFilter filter() {
        return this.filter;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void helpPressed() {
        UIUtil.showHelp((String)"text-comparison-filter", (UIUtil.HelpContext)UIUtil.HelpContext.DIALOG);
    }

    protected void okPressed() {
        String string = this.txtRegex.getText();
        String string2 = this.txtDescription.getText();
        if (string.length() > 0) {
            TextFilter.Target target = this.btnChar.getSelection() ? TextFilter.Target.CHARS : TextFilter.Target.LINES;
            string = TextFilter.displayStringToRegex((String)string);
            this.validateRegex(string);
            this.filter = new TextFilter(string, target, string2);
        }
        super.okPressed();
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        return super.open();
    }

    private void validateRegex(String string) {
        try {
            Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.showAlert(true, NLS.bind((String)UIMsg.RegexAlert_invalidRegex, (Object)patternSyntaxException.getMessage()), 1);
        }
    }
}

