/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.dialogs;

import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.script.Role;
import com.deltawalker.text.TextDoc;
import com.deltawalker.text.internal.TextContextId;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.text.internal.ui.PreviewDiffDoc;
import com.deltawalker.text.internal.ui.dialogs.BasePrefPage;
import com.deltawalker.text.ui.TextDiffView;
import com.deltawalker.ui.OverlayPrefStore;
import com.deltawalker.ui.UIUtil;
import com.deltopia.ClassUtil;
import com.deltopia.io.FileType;
import com.deltopia.jface.util.DialogUtil;
import java.util.EnumMap;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TextDisplayPrefPage
extends BasePrefPage
implements IWorkbenchPreferencePage {
    private static final OverlayPrefStore.OverlayKey[] OVERLAY_KEYS = new OverlayPrefStore.OverlayKey[]{new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.T_DO_INLINE_DELTAS.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.T_SHOW_PSEUDO_CONFLICTS.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.T_USE_SINGLE_LINE.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.T_WRAP_LINES.toString())};

    @Override
    protected Control createContents(Composite composite) {
        UIUtil.setHelpContextId((Control)composite, (String)TextContextId.TEXT_DISPLAY_PREF_PAGE);
        this.overlayPrefs = new OverlayPrefStore(this.getPreferenceStore(), OVERLAY_KEYS);
        this.overlayPrefs.load();
        this.overlayPrefs.start();
        this.createControls(composite);
        Dialog.applyDialogFont((Control)composite);
        DialogUtil.initializeFromPrefsAndNotify((Control)this.getControl(), (IPreferenceStore)this.overlayPrefs);
        return composite;
    }

    @Override
    protected void createControls(Composite composite) {
        DialogUtil.insertSpace((Composite)composite);
        this.createVisualizationContols(composite);
        DialogUtil.insertSpace((Composite)composite);
        Composite composite2 = DialogUtil.createPageComposite((Composite)composite);
        composite2.setLayoutData((Object)new GridData(1808));
        Control control = this.createTextDiffView(composite2);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = this.convertVerticalDLUsToPixels(120);
        control.setLayoutData((Object)gridData);
        DialogUtil.insertSpace((Composite)composite);
        DialogUtil.insertSpace((Composite)composite);
    }

    protected Control createTextDiffView(Composite composite) {
        TextDiffView textDiffView = new TextDiffView(composite, 2048, 0);
        EnumMap<Role, UriInfo> enumMap = new EnumMap<Role, UriInfo>(Role.class);
        UriInfoUtil.makeUriInfosSafe(enumMap, (FileType)FileType.FILE);
        textDiffView.setInput((Object)new PreviewDiffDoc(enumMap, (IPreferenceStore)this.overlayPrefs));
        ResourceBundle resourceBundle = TextMsg.constructedKeyBundle();
        String string = ClassUtil.getSimpleName(((Object)((Object)this)).getClass());
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            String string2 = resourceBundle.getString(String.valueOf(string) + '.' + role);
            ((TextDoc)textDiffView.doc(role)).initialize(string2);
            ++n2;
        }
        return textDiffView.getControl();
    }

    private void createVisualizationContols(Composite composite) {
        Composite composite2 = DialogUtil.createPageComposite((Composite)composite);
        this.addCheckBox(composite2, Msg.TextPrefPage_showInlineDiffs, PrefKey.T_DO_INLINE_DELTAS);
        this.addCheckBox(composite2, Msg.TextPrefPage_showPseudoConflicts, PrefKey.T_SHOW_PSEUDO_CONFLICTS);
        this.addCheckBox(composite2, TextMsg.TextPrefPage_useSingleLine, PrefKey.T_USE_SINGLE_LINE);
        this.addCheckBox(composite2, Msg.TextPrefPage_wrapLines, PrefKey.T_WRAP_LINES);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void performHelp() {
        UIUtil.showHelp((String)"text-comparisons-display", (UIUtil.HelpContext)UIUtil.HelpContext.PREF_PAGE);
    }
}

