/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.dialogs;

import com.deltawalker.text.internal.TextContextId;
import com.deltawalker.ui.EncodingChooser;
import com.deltawalker.ui.IApplyListener;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltopia.io.TextEncoding;
import java.util.Locale;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectEncodingDialog
extends TrayDialog {
    private static final int APPLY_ID = 1025;
    private IApplyListener applyListener;
    private TextEncoding encoding;
    private EncodingChooser charsetChooser;
    private Locale locale;
    private final IPreferenceStore prefs;

    public SelectEncodingDialog(Shell shell, TextEncoding textEncoding, Locale locale, IApplyListener iApplyListener, IPreferenceStore iPreferenceStore) {
        super(shell);
        this.encoding = textEncoding;
        this.locale = locale;
        this.applyListener = iApplyListener;
        this.prefs = iPreferenceStore;
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            this.charsetChooser.toPrefs();
            this.charsetChooser.reload();
            this.applyListener.applyPressed(this.charsetChooser);
            this.updateButtonStates(false);
        } else {
            super.buttonPressed(n);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, TextContextId.SET_ENCODING_DIALOG);
        shell.setText(UIMsg.SelectEncodingDlg_title);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        Canvas canvas = new Canvas(composite, 0);
        canvas.setLayoutData((Object)gridData);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.makeColumnsEqualWidth = false;
        ++gridLayout.numColumns;
        this.createButton(composite, 1025, UIMsg.SelectEncodingDlg_apply, false);
        this.updateButtonStates(false);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.charsetChooser = new EncodingChooser(composite2, 0, false, false, this.prefs);
        this.charsetChooser.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.locale != null) {
            this.charsetChooser.setSelectedLocale(this.locale);
        } else if (this.encoding != null) {
            this.charsetChooser.setSelectedEncoding(this.encoding);
        }
        this.charsetChooser.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectEncodingDialog.this.updateButtonStates(SelectEncodingDialog.this.charsetChooser.isValidSelection(SelectEncodingDialog.this.charsetChooser.getSelectionIndex()));
            }
        });
        this.charsetChooser.setFocus();
        return composite2;
    }

    public EncodingChooser getCharsetChooser() {
        return this.charsetChooser;
    }

    public Locale getSelectedLocale() {
        return this.charsetChooser.getSelectedLocale();
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void helpPressed() {
        UIUtil.showHelp((String)"select-character-encoding", (UIUtil.HelpContext)UIUtil.HelpContext.DIALOG);
    }

    public boolean isCharsetSelected() {
        return this.charsetChooser.isCharsetSelected();
    }

    protected void okPressed() {
        this.buttonPressed(1025);
        super.okPressed();
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        return super.open();
    }

    public void setSelectedEncoding(TextEncoding textEncoding) {
        this.encoding = textEncoding;
    }

    public void setSelectedLocale(Locale locale) {
        this.locale = locale;
    }

    private void updateButtonStates(boolean bl) {
        this.getButton(1025).setEnabled(bl);
    }
}

