/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.text.internal.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.ContentTypeEntry;
import com.deltawalker.interfaces.IContentTypeBoss;
import com.deltawalker.text.internal.TextContextId;
import com.deltawalker.text.internal.TextMsg;
import com.deltawalker.text.internal.ui.dialogs.ContentTypeEntryDialog;
import com.deltawalker.ui.UIUtil;
import com.deltopia.jface.util.DialogUtil;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ContentTypesPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int COL_IX_ASSOCIATION = 2;
    private static final int COL_IX_EXTENSION = 0;
    private static final int COL_IX_TYPE = 1;
    private IContentTypeBoss.IChangeListener onContentType = new IContentTypeBoss.IChangeListener(){

        public void changed() {
            Control control = ContentTypesPrefPage.this.tableViewer.getControl();
            if (control != null && !control.isDisposed()) {
                ContentTypesPrefPage.this.tableViewer.refresh();
            }
        }
    };
    private TableViewer tableViewer;
    private final TableColumnLayout tcLayout = new TableColumnLayout();

    private Control createButtonBar(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        final Button button = new Button(composite2, 8);
        button.setLayoutData((Object)new GridData(4, 16384, true, false));
        button.setText(TextMsg.ContentTypesPrefPage_add);
        final Button button2 = new Button(composite2, 8);
        button2.setLayoutData((Object)new GridData(4, 16384, true, false));
        button2.setText(TextMsg.ContentTypesPrefPage_edit);
        final Button button3 = new Button(composite2, 8);
        button3.setLayoutData((Object)new GridData(4, 16384, true, false));
        button3.setText(TextMsg.ContentTypesPrefPage_remove);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ContentTypeEntry contentTypeEntry;
                Widget widget = event.widget;
                if (widget == button) {
                    ContentTypesPrefPage.this.edit(null);
                } else if (widget == button2) {
                    ContentTypesPrefPage.this.edit(ContentTypesPrefPage.this.getSelection());
                } else if (widget == button3 && (contentTypeEntry = ContentTypesPrefPage.this.getSelection()) != null) {
                    App.instance().contentTypeBoss().removeEntry(contentTypeEntry);
                }
            }
        };
        button.addListener(13, listener);
        button2.addListener(13, listener);
        button3.addListener(13, listener);
        ISelectionChangedListener iSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                boolean bl = ContentTypesPrefPage.this.getSelection() != null;
                button2.setEnabled(bl);
                button3.setEnabled(bl);
            }
        };
        this.tableViewer.addSelectionChangedListener(iSelectionChangedListener);
        iSelectionChangedListener.selectionChanged(null);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ContentTypesPrefPage.this.edit(ContentTypesPrefPage.this.getSelection());
            }
        });
        return composite2;
    }

    protected Control createContents(Composite composite) {
        UIUtil.setHelpContextId((Control)composite, (String)TextContextId.CONTENT_TYPES_PREF_PAGE);
        Composite composite2 = DialogUtil.createPageComposite((Composite)composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(4, 16384, true, false);
        gridData.horizontalSpan = gridLayout.numColumns;
        Label label = new Label(composite2, 64);
        label.setLayoutData((Object)gridData);
        label.setText(TextMsg.ContentTypesPrefPage_label);
        this.createTable(composite2);
        Control control = this.createButtonBar(composite2);
        control.setLayoutData((Object)new GridData(131072, 4, false, true));
        IContentTypeBoss iContentTypeBoss = App.instance().contentTypeBoss();
        this.tableViewer.setInput((Object)iContentTypeBoss);
        iContentTypeBoss.addListener(this.onContentType);
        this.applyDialogFont(composite2);
        return composite2;
    }

    private void createTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.tcLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(composite2, 67588){

            protected void checkSubclass() {
            }

            public Point computeSize(int n, int n2, boolean bl) {
                if (n2 == -1) {
                    n2 = 2 * this.getBorderWidth() + this.getHeaderHeight() + this.getItemHeight();
                }
                return super.computeSize(n, n2, bl);
            }
        };
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384, 0);
        tableColumn.setText(TextMsg.ContentTypesPrefPage_colExtension);
        this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(20));
        tableColumn = new TableColumn(table, 16384, 1);
        tableColumn.setText(TextMsg.ContentTypesPrefPage_colType);
        this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(20));
        tableColumn = new TableColumn(table, 16384, 2);
        tableColumn.setText(TextMsg.ContentTypesPrefPage_colAssociation);
        this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(60));
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ContentTypeContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ContentTypeLabelProvider());
    }

    public void dispose() {
        try {
            App.instance().contentTypeBoss().removeListener(this.onContentType);
        }
        finally {
            super.dispose();
        }
    }

    private void edit(ContentTypeEntry contentTypeEntry) {
        ContentTypeEntryDialog contentTypeEntryDialog = new ContentTypeEntryDialog(this.getShell(), contentTypeEntry);
        if (contentTypeEntryDialog.open() == 0) {
            ContentTypeEntry contentTypeEntry2 = contentTypeEntryDialog.getEntry();
            App.instance().contentTypeBoss().replaceEntry(contentTypeEntry, contentTypeEntry2);
        }
    }

    private ContentTypeEntry getSelection() {
        Object object;
        ISelection iSelection = this.tableViewer.getSelection();
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) != null) {
            return (ContentTypeEntry)object;
        }
        return null;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public boolean performCancel() {
        App.instance().stateBoss().loadState(UIUtil.getActiveWindow());
        return true;
    }

    protected void performDefaults() {
        try {
            App.instance().contentTypeBoss().restoreDefaults();
            App.instance().stateBoss().saveState();
            this.tableViewer.refresh();
        }
        finally {
            super.performDefaults();
        }
    }

    public void performHelp() {
        UIUtil.showHelp((String)"all-comparisons-content-types", (UIUtil.HelpContext)UIUtil.HelpContext.PREF_PAGE);
    }

    public boolean performOk() {
        App.instance().stateBoss().saveState();
        return true;
    }

    private class ContentTypeContentProvider
    implements IStructuredContentProvider {
        private ContentTypeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return ((IContentTypeBoss)object).userContentTypeEntries().toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class ContentTypeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ContentTypeLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            Image image;
            if (n == 0) {
                ContentTypeEntry contentTypeEntry = (ContentTypeEntry)object;
                image = contentTypeEntry.image();
            } else {
                image = null;
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            String string;
            ContentTypeEntry contentTypeEntry = (ContentTypeEntry)object;
            switch (n) {
                case 0: {
                    string = "*." + contentTypeEntry.extension();
                    break;
                }
                case 2: {
                    string = contentTypeEntry.programName();
                    break;
                }
                case 1: {
                    string = contentTypeEntry.docType().contentDisplayName();
                    break;
                }
                default: {
                    string = "";
                }
            }
            return string;
        }
    }
}

